/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.service.goods.impl;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.gmc.domain.sellingstrategy.MultipleItemVO;
import com.digiwin.dap.middleware.gmc.entity.MultipleItem;
import com.digiwin.dap.middleware.gmc.repository.MultipleItemRepository;
import com.digiwin.dap.middleware.gmc.service.goods.MultipleItemCrudService;
import com.digiwin.dap.middleware.gmc.service.goods.MultipleItemService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MultipleItemServiceImpl
implements MultipleItemService {
    @Autowired
    private MultipleItemCrudService multipleItemCrudService;
    @Autowired
    private MultipleItemRepository multipleItemRepository;

    public void save(List<MultipleItemVO> multipleItemVOS, long sellingStrategySid) {
        multipleItemVOS.forEach(multipleItemVO -> {
            MultipleItem multipleItem = multipleItemVO.generateMultipleItem();
            multipleItem.setSellingStrategySid(Long.valueOf(sellingStrategySid));
            if (multipleItemVO.getSid() == 0L) {
                this.multipleItemCrudService.create((BaseEntity)multipleItem);
            } else {
                this.multipleItemCrudService.update((BaseEntity)multipleItem);
            }
        });
    }

    public void deleteBySid(List<Long> sids) {
        if (sids == null) {
            return;
        }
        sids.forEach(sid -> this.multipleItemCrudService.deleteById(sid.longValue()));
    }

    public List<MultipleItemVO> getMultipleItemVOS(long sellingStrategySid) {
        List multipleItems = this.multipleItemRepository.findAllBySellingStrategySid(sellingStrategySid);
        ArrayList<MultipleItemVO> multipleItemVOS = new ArrayList<MultipleItemVO>();
        multipleItems.forEach(multipleItem -> {
            MultipleItemVO multipleItemVO = new MultipleItemVO();
            multipleItemVO.generateMultipleItemVO(multipleItem);
            multipleItemVOS.add(multipleItemVO);
        });
        return multipleItemVOS;
    }

    public List<MultipleItemVO> getMultipleItemVOS(List<Long> sellingStrategySidList) {
        List multipleItems = this.multipleItemRepository.findAllBySellingStrategySidIn(sellingStrategySidList);
        return multipleItems.stream().map(multipleItem -> new MultipleItemVO().generateMultipleItemVO(multipleItem)).collect(Collectors.toList());
    }
}

