/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.service.goods.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.gmc.constant.I18nError;
import com.digiwin.dap.middleware.gmc.entity.SellingStrategy;
import com.digiwin.dap.middleware.gmc.mapper.OrderMapper;
import com.digiwin.dap.middleware.gmc.repository.GoodsRepository;
import com.digiwin.dap.middleware.gmc.repository.MultipleItemRepository;
import com.digiwin.dap.middleware.gmc.repository.SellingStrategyRepository;
import com.digiwin.dap.middleware.gmc.service.goods.SellingStrategyCrudService;
import com.digiwin.dap.middleware.gmc.service.marketing.MarketingConfigCrudService;
import com.digiwin.dap.middleware.gmc.service.pack.PackService;
import com.digiwin.dap.middleware.service.impl.BaseEntityManagerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;

@Service
public class SellingStrategyCrudServiceImpl
extends BaseEntityManagerService<SellingStrategy>
implements SellingStrategyCrudService {
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private SellingStrategyRepository sellingStrategyRepository;
    @Autowired
    private MultipleItemRepository multipleItemRepository;
    @Autowired
    private GoodsRepository goodsRepository;
    @Autowired
    private PackService packService;
    @Autowired
    private MarketingConfigCrudService marketingConfigCrudService;

    protected JpaRepository getRepository() {
        return this.sellingStrategyRepository;
    }

    public void deleteByCode(String sellingStrategyCode) {
        SellingStrategy sellingStrategy = this.sellingStrategyRepository.getByCode(sellingStrategyCode);
        if (sellingStrategy != null) {
            this.packService.checkDeletablePackStrategy(Long.valueOf(sellingStrategy.getSid()));
            long count = this.orderMapper.countByStrategySid(sellingStrategy.getSid());
            if (count > 0L) {
                throw new BusinessException((ErrorHandler)I18nError.ERROR_SELLING_STRATEGYE_ORDER_COMPLETED_DELET, new Object[]{sellingStrategy.getCode()});
            }
            this.deleteById(sellingStrategy.getSid());
            this.multipleItemRepository.deleteBySellingStrategySid(sellingStrategy.getSid());
            this.marketingConfigCrudService.deleteByMainStrategySid(Long.valueOf(sellingStrategy.getSid()));
        }
    }

    public SellingStrategy findByCode(String code) {
        return this.sellingStrategyRepository.getByCode(code);
    }
}

