/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.service.goods.impl;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.gmc.constant.GmcConstant;
import com.digiwin.dap.middleware.gmc.domain.accessory.AccessoryGoodsVO;
import com.digiwin.dap.middleware.gmc.domain.goods.GoodsOnPlatformVO;
import com.digiwin.dap.middleware.gmc.domain.goods.GoodsVO;
import com.digiwin.dap.middleware.gmc.domain.sellingstrategy.ApportionType;
import com.digiwin.dap.middleware.gmc.domain.sellingstrategy.GoodsStrategyVO;
import com.digiwin.dap.middleware.gmc.domain.sellingstrategy.MultipleItemVO;
import com.digiwin.dap.middleware.gmc.domain.sellingstrategy.QueryStrategyDTO;
import com.digiwin.dap.middleware.gmc.domain.sellingstrategy.SellingStrategyVO;
import com.digiwin.dap.middleware.gmc.entity.SellingStrategy;
import com.digiwin.dap.middleware.gmc.mapper.AccessoryGoodsMapper;
import com.digiwin.dap.middleware.gmc.mapper.GoodsMapper;
import com.digiwin.dap.middleware.gmc.mapper.GoodsOnPlatformMapper;
import com.digiwin.dap.middleware.gmc.mapper.SellingStrategyMapper;
import com.digiwin.dap.middleware.gmc.repository.MultipleItemRepository;
import com.digiwin.dap.middleware.gmc.repository.SellingStrategyRepository;
import com.digiwin.dap.middleware.gmc.service.goods.GoodsService;
import com.digiwin.dap.middleware.gmc.service.goods.MultipleItemService;
import com.digiwin.dap.middleware.gmc.service.goods.SellingStrategyCrudService;
import com.digiwin.dap.middleware.gmc.service.goods.SellingStrategyService;
import com.github.pagehelper.PageSerializable;
import com.github.pagehelper.page.PageMethod;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class SellingStrategyServiceImpl
implements SellingStrategyService {
    @Autowired
    private SellingStrategyRepository sellingStrategyRepository;
    @Autowired
    private SellingStrategyCrudService sellingStrategyCrudService;
    @Autowired
    private GoodsService goodsService;
    @Autowired
    private MultipleItemService multipleItemService;
    @Autowired
    private MultipleItemRepository multipleItemRepository;
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private SellingStrategyMapper sellingStrategyMapper;
    @Autowired
    private AccessoryGoodsMapper accessoryGoodsMapper;
    @Autowired
    private GoodsOnPlatformMapper goodsOnPlatformMapper;

    public long create(SellingStrategyVO sellingStrategyVO) {
        long sid = this.sellingStrategyCrudService.create((BaseEntity)sellingStrategyVO.generateSellingStrategy());
        this.multipleItemService.save(sellingStrategyVO.getMultipleItems(), sid);
        this.setMainPush(sellingStrategyVO.getGoodsCode(), sellingStrategyVO.getCode(), sellingStrategyVO.getMainPush().booleanValue());
        return sid;
    }

    public long createDefaultStrategy(String goodsCode, String goodsName) {
        String sellingStrategyCode = String.format("%s_landing", goodsCode);
        SellingStrategy sellingStrategy = this.sellingStrategyRepository.getByCode(sellingStrategyCode);
        if (null != sellingStrategy) {
            return sellingStrategy.getSid();
        }
        SellingStrategyVO sellingStrategyVO = new SellingStrategyVO();
        sellingStrategyVO.setCode(sellingStrategyCode);
        sellingStrategyVO.setName(sellingStrategyCode);
        sellingStrategyVO.setGoodsCode(goodsCode);
        sellingStrategyVO.setLimitPurchaseQuantity(Long.valueOf(9999L));
        sellingStrategyVO.setSortNumber(Long.valueOf(999L));
        sellingStrategyVO.setEnable(Boolean.valueOf(true));
        sellingStrategyVO.setPrice(BigDecimal.ZERO);
        sellingStrategyVO.setDealer(Boolean.valueOf(false));
        sellingStrategyVO.setAdvisory(Boolean.valueOf(false));
        sellingStrategyVO.setContractDate(Boolean.valueOf(false));
        sellingStrategyVO.setMainPush(Boolean.valueOf(false));
        sellingStrategyVO.setUseCount(Long.valueOf(-1L));
        sellingStrategyVO.setTrialDays(Long.valueOf(0L));
        sellingStrategyVO.setPromotionPrice(BigDecimal.ZERO);
        sellingStrategyVO.setOriginalPrice(BigDecimal.ZERO);
        sellingStrategyVO.setLimitUsersNumber(Boolean.valueOf(false));
        sellingStrategyVO.setExperienceScheme(Boolean.valueOf(false));
        sellingStrategyVO.setBeta(Boolean.valueOf(false));
        sellingStrategyVO.setUsersNumber(Long.valueOf(5L));
        MultipleItemVO multipleItem = new MultipleItemVO();
        multipleItem.setSid(Long.valueOf(0L));
        multipleItem.setSellingStrategySid(Long.valueOf(0L));
        multipleItem.setItemCode(goodsCode);
        multipleItem.setItemName(goodsName);
        multipleItem.setApportionType(ApportionType.VARIABLECOST);
        multipleItem.setQuantity(Integer.valueOf(1));
        multipleItem.setUnit("\u5355\u4f4d");
        multipleItem.setUnitPrice(BigDecimal.ZERO);
        multipleItem.setOriginalPrice(BigDecimal.ZERO);
        multipleItem.setContractPrice(BigDecimal.ZERO);
        multipleItem.setPreset(Boolean.valueOf(true));
        multipleItem.setStandardPrice(BigDecimal.ZERO);
        ArrayList<MultipleItemVO> multipleItemVOS = new ArrayList<MultipleItemVO>();
        multipleItemVOS.add(multipleItem);
        sellingStrategyVO.setMultipleItems(multipleItemVOS);
        long sid = this.create(sellingStrategyVO);
        return sid;
    }

    public void update(SellingStrategyVO sellingStrategyVO) {
        this.sellingStrategyCrudService.update((BaseEntity)sellingStrategyVO.generateSellingStrategy(), true);
        this.multipleItemService.deleteBySid(sellingStrategyVO.getDeletedItemSid());
        this.multipleItemRepository.flush();
        this.multipleItemService.save(sellingStrategyVO.getMultipleItems(), sellingStrategyVO.getId().longValue());
        this.setMainPush(sellingStrategyVO.getGoodsCode(), sellingStrategyVO.getCode(), sellingStrategyVO.getMainPush().booleanValue());
    }

    public List<SellingStrategyVO> getSellingStrategyList(String goodsCode, boolean isIncludeDealerSales) {
        List sellingStrategies = this.sellingStrategyRepository.findAllByGoodsCode(goodsCode);
        ArrayList<SellingStrategyVO> sellingStrategyVOS = new ArrayList<SellingStrategyVO>();
        List strategySids = sellingStrategies.stream().map(BaseEntity::getSid).collect(Collectors.toList());
        List accessoryGoodsVOS = new ArrayList();
        if (!CollectionUtils.isEmpty(strategySids)) {
            accessoryGoodsVOS = this.accessoryGoodsMapper.findAccessoryMarketConfigByStrategySids(strategySids);
        }
        Map<Long, List<AccessoryGoodsVO>> accessoryGoods = accessoryGoodsVOS.stream().collect(Collectors.groupingBy(AccessoryGoodsVO::getStrategySid));
        List multipleItemVOS = this.multipleItemService.getMultipleItemVOS(strategySids);
        HashMap multipleItemVOMap = new HashMap();
        for (MultipleItemVO u : multipleItemVOS) {
            List itemVOS = (List)multipleItemVOMap.get(u.getSellingStrategySid());
            if (itemVOS != null) {
                itemVOS.add(u);
                continue;
            }
            LinkedList<MultipleItemVO> linkedList = new LinkedList<MultipleItemVO>();
            linkedList.add(u);
            multipleItemVOMap.put(u.getSellingStrategySid(), linkedList);
        }
        sellingStrategies.forEach(sellingStrategy -> {
            if (!isIncludeDealerSales && sellingStrategy.getDealer().booleanValue()) {
                return;
            }
            SellingStrategyVO sellingStrategyVO = new SellingStrategyVO();
            sellingStrategyVO.generateSellingStrategyVO(sellingStrategy);
            sellingStrategyVO.changeModulesAndCustomAttributeType();
            sellingStrategyVO.setMultipleItems((List)multipleItemVOMap.get(sellingStrategy.getSid()));
            sellingStrategyVOS.add(sellingStrategyVO);
            sellingStrategyVO.setAccessoryGoods((List)accessoryGoods.get(sellingStrategy.getSid()));
        });
        return sellingStrategyVOS;
    }

    public List<SellingStrategyVO> getSellingStrategyList(List<String> goodsCodeList, boolean isIncludeDealerSales) {
        List sellingStrategies = this.sellingStrategyRepository.findAllByGoodsCodeIn(goodsCodeList);
        if (sellingStrategies.isEmpty()) {
            return Collections.emptyList();
        }
        List sellingStrategySidList = sellingStrategies.stream().map(BaseEntity::getSid).collect(Collectors.toList());
        List multipleItemVOList = this.multipleItemService.getMultipleItemVOS(sellingStrategySidList);
        Map<Long, List<MultipleItemVO>> multipleItemVoMap = multipleItemVOList.stream().collect(Collectors.groupingBy(MultipleItemVO::getSellingStrategySid));
        ArrayList<SellingStrategyVO> sellingStrategyVOList = new ArrayList<SellingStrategyVO>();
        sellingStrategies.forEach(sellingStrategy -> {
            if (!isIncludeDealerSales && Boolean.TRUE.equals(sellingStrategy.getDealer()) || Boolean.TRUE.equals(sellingStrategy.isDisabled())) {
                return;
            }
            SellingStrategyVO sellingStrategyVO = new SellingStrategyVO();
            sellingStrategyVO.generateSellingStrategyVO(sellingStrategy);
            sellingStrategyVO.changeModulesAndCustomAttributeType();
            sellingStrategyVO.setMultipleItems(multipleItemVoMap.getOrDefault(sellingStrategy.getSid(), Collections.emptyList()));
            sellingStrategyVOList.add(sellingStrategyVO);
        });
        return sellingStrategyVOList;
    }

    public SellingStrategyVO getSellingStrategyWithGoodsByCode(String goodsCode, String sellingStrategyCode) {
        SellingStrategy sellingStrategy = this.sellingStrategyRepository.getByCode(sellingStrategyCode);
        return this.returnSellingStrategyVO(sellingStrategy);
    }

    public SellingStrategyVO getSellingStrategyWithGoodsById(String sellingStrategyId) {
        SellingStrategy sellingStrategy = (SellingStrategy)this.sellingStrategyCrudService.findBySid(Long.parseLong(sellingStrategyId));
        return this.returnSellingStrategyVO(sellingStrategy);
    }

    public void setMainPush(String goodsCode, String sellingStrategyCode, boolean mainPush) {
        if (mainPush) {
            this.sellingStrategyRepository.setMainPush(GmcConstant.MAIN_PUSH.booleanValue(), sellingStrategyCode);
            this.sellingStrategyRepository.setNotMainPush(GmcConstant.NOT_MAIN_PUSH.booleanValue(), sellingStrategyCode, goodsCode);
        }
    }

    private SellingStrategyVO returnSellingStrategyVO(SellingStrategy sellingStrategy) {
        if (sellingStrategy == null) {
            return null;
        }
        SellingStrategyVO sellingStrategyVO = new SellingStrategyVO();
        sellingStrategyVO.generateSellingStrategyVO(sellingStrategy);
        sellingStrategyVO.changeModulesAndCustomAttributeType();
        GoodsVO goodsVO = this.goodsService.getGoodsInfoByCode(sellingStrategyVO.getGoodsCode());
        sellingStrategyVO.setGoods(goodsVO);
        sellingStrategyVO.setMultipleItems(this.multipleItemService.getMultipleItemVOS(sellingStrategy.getSid()));
        return sellingStrategyVO;
    }

    public PageSerializable<GoodsStrategyVO> getSellingStrategy(QueryStrategyDTO dto) {
        this.businessBefore(dto);
        PageMethod.startPage((int)dto.getPageNum(), (int)dto.getPageSize(), (String)dto.getOrderBy());
        return new PageSerializable(this.sellingStrategyMapper.findSellingStrategy(dto));
    }

    private void businessBefore(QueryStrategyDTO dto) {
        if (Boolean.TRUE.equals(dto.getExcludePlatformStrategy()) && StringUtils.hasLength((String)dto.getExcludeGood())) {
            dto.setExcludeSids(this.goodsOnPlatformMapper.getPlatformByGoodsCode(dto.getExcludeGood()).stream().map(GoodsOnPlatformVO::getDefaultStrategySid).collect(Collectors.toList()));
        }
    }
}

