/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.service.goods.impl;

import com.digiwin.dap.middleware.domain.Page;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.gmc.domain.unitconversion.dto.CreateUnitConversionDTO;
import com.digiwin.dap.middleware.gmc.domain.unitconversion.dto.QueryUnitConversionDTO;
import com.digiwin.dap.middleware.gmc.domain.unitconversion.dto.UpdateUnitConversionDTO;
import com.digiwin.dap.middleware.gmc.domain.unitconversion.vo.UnitConversionVO;
import com.digiwin.dap.middleware.gmc.entity.Goods;
import com.digiwin.dap.middleware.gmc.entity.UnitConversion;
import com.digiwin.dap.middleware.gmc.mapper.UnitConversionMapper;
import com.digiwin.dap.middleware.gmc.repository.GoodsRepository;
import com.digiwin.dap.middleware.gmc.repository.UnitConversionRepository;
import com.digiwin.dap.middleware.gmc.service.goods.UnitConversionService;
import com.digiwin.dap.middleware.gmc.support.remote.CacService;
import com.digiwin.dap.middleware.service.impl.BaseEntityManagerService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageSerializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UnitConversionServiceImpl
extends BaseEntityManagerService<UnitConversion>
implements UnitConversionService {
    @Autowired
    private UnitConversionRepository unitConversionRepository;
    @Autowired
    private UnitConversionMapper unitConversionMapper;
    @Autowired
    private GoodsRepository goodsRepository;
    @Autowired
    private CacService cacService;

    protected JpaRepository getRepository() {
        return this.unitConversionRepository;
    }

    public Long createUnitConversion(CreateUnitConversionDTO dto) {
        Goods goods = this.goodsRepository.findByCode(dto.getGoodsCode());
        if (Objects.isNull(goods)) {
            throw new BusinessException("\u5546\u54c1\u4e0d\u5b58\u5728!");
        }
        List unitConversionList = this.unitConversionRepository.findUnitConversionByIdAndGoodsCode(dto.getId(), dto.getGoodsCode());
        if (!CollectionUtils.isEmpty((Collection)unitConversionList)) {
            throw new BusinessException("\u5f53\u524d\u5546\u54c1\u5df2\u5b58\u5728\u76f8\u540cid\u7684\u5355\u4f4d\u6362\u7b97\u914d\u7f6e!");
        }
        UnitConversion unitConversion = this.buildUnitConversion(dto);
        this.create((BaseEntity)unitConversion);
        this.cacService.mergeUnitConversion(unitConversion);
        return unitConversion.getSid();
    }

    public void updateUnitConversion(UpdateUnitConversionDTO dto) {
        UnitConversion unitConversion = this.unitConversionRepository.findById((Object)dto.getSid()).orElse(null);
        if (Objects.isNull(unitConversion)) {
            throw new BusinessException("\u5355\u4f4d\u6362\u7b97\u914d\u7f6e\u4e0d\u5b58\u5728!");
        }
        List unitConversionList = this.unitConversionRepository.findUnitConversionByIdAndGoodsCode(dto.getId(), unitConversion.getGoodsCode());
        if (!CollectionUtils.isEmpty(unitConversionList = unitConversionList.stream().filter(x -> !Objects.equals(x.getSid(), dto.getSid())).collect(Collectors.toList()))) {
            throw new BusinessException("\u5f53\u524d\u5546\u54c1\u5df2\u5b58\u5728\u76f8\u540cid\u7684\u5355\u4f4d\u6362\u7b97\u914d\u7f6e!");
        }
        this.update((BaseEntity)this.buildUnitConversion(dto));
        this.cacService.mergeUnitConversion(unitConversion);
    }

    public void deleteUnitConversion(Long sid) {
        UnitConversion unitConversion = this.unitConversionRepository.findById((Object)sid).orElse(null);
        if (Objects.isNull(unitConversion)) {
            throw new BusinessException("\u5355\u4f4d\u6362\u7b97\u914d\u7f6e\u4e0d\u5b58\u5728!");
        }
        try {
            this.cacService.deleteUnitConversion(unitConversion.getId(), unitConversion.getGoodsCode());
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
        this.deleteById(sid.longValue());
    }

    public PageSerializable<UnitConversionVO> pageUnitConversion(QueryUnitConversionDTO dto, Page page) {
        PageHelper.startPage((int)page.getPageNum(), (int)page.getPageSize());
        List unitConversionList = this.unitConversionMapper.findUnitConversionByPage(dto.getId(), dto.getModifyById(), dto.getGoodsCode());
        return PageSerializable.of((List)unitConversionList);
    }

    private UnitConversion buildUnitConversion(CreateUnitConversionDTO dto) {
        if (dto == null) {
            return null;
        }
        UnitConversion unitConversion = new UnitConversion();
        unitConversion.setId(dto.getId());
        unitConversion.setName(dto.getName());
        unitConversion.setConversionPoint(dto.getConversionPoint());
        unitConversion.setDescription(dto.getDescription());
        unitConversion.setGoodsCode(dto.getGoodsCode());
        return unitConversion;
    }

    private UnitConversion buildUnitConversion(UpdateUnitConversionDTO dto) {
        if (dto == null) {
            return null;
        }
        UnitConversion unitConversion = new UnitConversion();
        unitConversion.setSid(dto.getSid().longValue());
        unitConversion.setId(dto.getId());
        unitConversion.setName(dto.getName());
        unitConversion.setConversionPoint(dto.getConversionPoint());
        unitConversion.setDescription(dto.getDescription());
        return unitConversion;
    }

    private UnitConversionVO buildUnitConversionVO(UnitConversion unitConversion) {
        if (unitConversion == null) {
            return null;
        }
        UnitConversionVO unitConversionVO = new UnitConversionVO();
        unitConversionVO.setId(unitConversion.getId());
        unitConversionVO.setName(unitConversion.getName());
        unitConversionVO.setConversionPoint(unitConversion.getConversionPoint());
        unitConversionVO.setDescription(unitConversion.getDescription());
        unitConversionVO.setGoodsCode(unitConversion.getGoodsCode());
        unitConversionVO.setSid(Long.valueOf(unitConversion.getSid()));
        unitConversionVO.setCreateBy(unitConversion.getCreateBy());
        unitConversionVO.setCreateById(unitConversion.getCreateById());
        unitConversionVO.setCreateDate(unitConversion.getCreateDate());
        unitConversionVO.setModifyBy(unitConversion.getModifyBy());
        unitConversionVO.setModifyById(unitConversion.getModifyById());
        unitConversionVO.setModifyDate(unitConversion.getModifyDate());
        return unitConversionVO;
    }
}

