/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.service.goodsalias.impl;

import com.digiwin.dap.middleware.gmc.domain.goods.GoodsLanguage;
import com.digiwin.dap.middleware.gmc.domain.goodsalias.GoodsAliasDTO;
import com.digiwin.dap.middleware.gmc.domain.multilanguage.MultiLanguageQueryVO;
import com.digiwin.dap.middleware.gmc.entity.GoodsAlias;
import com.digiwin.dap.middleware.gmc.mapper.GoodsAliasMapper;
import com.digiwin.dap.middleware.gmc.repository.GoodsAliasRepository;
import com.digiwin.dap.middleware.gmc.service.goodsalias.GoodsAliasCrudService;
import com.digiwin.dap.middleware.service.impl.BaseEntityManagerService;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class GoodsAliasCrudServiceImpl
extends BaseEntityManagerService<GoodsAlias>
implements GoodsAliasCrudService {
    @Autowired
    private GoodsAliasRepository goodsAliasRepository;
    @Autowired
    private GoodsAliasMapper goodsAliasMapper;

    protected JpaRepository getRepository() {
        return this.goodsAliasRepository;
    }

    public void setGoodsAliasByGoods(List<String> goodsCodes, List<GoodsLanguage> goods) {
        if (CollectionUtils.isEmpty(goods)) {
            return;
        }
        List goodsAlias = this.goodsAliasRepository.findByGoodsCodeInAndLanguage(goodsCodes, LocaleContextHolder.getLocale().toLanguageTag());
        if (CollectionUtils.isEmpty((Collection)goodsAlias)) {
            return;
        }
        Map<String, List<GoodsAlias>> goodsAliasMap = goodsAlias.stream().collect(Collectors.groupingBy(GoodsAlias::getGoodsCode));
        goods.forEach(o -> {
            if (goodsAliasMap.keySet().contains(o.getGoodsCode())) {
                o.setGoodsAliases((List)goodsAliasMap.get(o.getGoodsCode()));
            }
        });
    }

    public void setGoodsAliasByMultiLanguage(List<String> goodsCodes, List<MultiLanguageQueryVO> goodsMultiLanguageVOs) {
        if (CollectionUtils.isEmpty(goodsMultiLanguageVOs)) {
            return;
        }
        List goodsAlias = this.goodsAliasRepository.findByGoodsCodeInAndLanguage(goodsCodes, LocaleContextHolder.getLocale().toLanguageTag());
        if (CollectionUtils.isEmpty((Collection)goodsAlias)) {
            return;
        }
        Map<String, List<GoodsAlias>> goodsAliasMap = goodsAlias.stream().collect(Collectors.groupingBy(GoodsAlias::getGoodsCode));
        goodsMultiLanguageVOs.forEach(o -> {
            if (goodsAliasMap.keySet().contains(o.getId())) {
                o.setGoodsAliases((List)goodsAliasMap.get(o.getId()));
            }
        });
    }

    public List<GoodsAlias> findGoodsAliasList(GoodsAliasDTO dto) {
        return this.goodsAliasMapper.findGoodsAliasList(dto);
    }

    public void deleteByCodesCode(String code) {
        this.goodsAliasRepository.deleteByGoodsCode(code);
    }
}

