/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.service.goodscategory.impl;

import com.digiwin.dap.middleware.gmc.domain.goods.GoodsLanguage;
import com.digiwin.dap.middleware.gmc.domain.multilanguage.MultiLanguageQueryVO;
import com.digiwin.dap.middleware.gmc.entity.GoodsCategory;
import com.digiwin.dap.middleware.gmc.repository.GoodsCategoryRepository;
import com.digiwin.dap.middleware.gmc.service.goodscategory.GoodsCategoryCrudService;
import com.digiwin.dap.middleware.service.impl.BaseEntityManagerService;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class GoodsCategoryCrudServiceImpl
extends BaseEntityManagerService<GoodsCategory>
implements GoodsCategoryCrudService {
    @Autowired
    private GoodsCategoryRepository goodsCategoryRepository;

    protected JpaRepository getRepository() {
        return this.goodsCategoryRepository;
    }

    public void deleteByCategoryId(String categoryId) {
        this.goodsCategoryRepository.deleteByCategoryId(categoryId);
    }

    public void setGoodsCategoryList(List<String> goodsCodes, List<GoodsLanguage> goods) {
        if (CollectionUtils.isEmpty(goods)) {
            return;
        }
        List goodsCategoryList = this.goodsCategoryRepository.findByGoodsCodeIn(goodsCodes);
        if (CollectionUtils.isEmpty((Collection)goodsCategoryList)) {
            return;
        }
        Map<String, List<GoodsCategory>> goodsCategoryMap = goodsCategoryList.stream().collect(Collectors.groupingBy(o -> o.getGoodsCode()));
        goods.forEach(o -> {
            if (goodsCategoryMap.containsKey(o.getGoodsCode())) {
                o.setGoodsCategoryList((List)goodsCategoryMap.get(o.getGoodsCode()));
            }
        });
    }

    public void setGoodsCategoryList4MultiLanguage(List<String> goodsCodes, List<MultiLanguageQueryVO> goodsMultiLanguages) {
        if (CollectionUtils.isEmpty(goodsMultiLanguages)) {
            return;
        }
        List goodsCategoryList = this.goodsCategoryRepository.findByGoodsCodeIn(goodsCodes);
        if (CollectionUtils.isEmpty((Collection)goodsCategoryList)) {
            return;
        }
        Map<String, List<GoodsCategory>> goodsCategoryMap = goodsCategoryList.stream().collect(Collectors.groupingBy(GoodsCategory::getGoodsCode));
        goodsMultiLanguages.forEach(o -> {
            if (goodsCategoryMap.containsKey(o.getId())) {
                o.setGoodsCategoryList((List)goodsCategoryMap.get(o.getId()));
            }
        });
    }
}

