/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.service.goodscounsel.impl;

import com.digiwin.dap.middleware.commons.util.StrUtils;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.gmc.constant.I18nError;
import com.digiwin.dap.middleware.gmc.domain.goods.GoodsCounselDTO;
import com.digiwin.dap.middleware.gmc.domain.remote.Order;
import com.digiwin.dap.middleware.gmc.domain.remote.OrderDetail;
import com.digiwin.dap.middleware.gmc.domain.remote.ShoppingCartOrderVO;
import com.digiwin.dap.middleware.gmc.entity.Goods;
import com.digiwin.dap.middleware.gmc.entity.SellingStrategy;
import com.digiwin.dap.middleware.gmc.mapper.OrderDetailMapper;
import com.digiwin.dap.middleware.gmc.mapper.OrderMapper;
import com.digiwin.dap.middleware.gmc.repository.GoodsRepository;
import com.digiwin.dap.middleware.gmc.service.goods.GoodsCrudService;
import com.digiwin.dap.middleware.gmc.service.goods.SellingStrategyCrudService;
import com.digiwin.dap.middleware.gmc.service.goodscounsel.GoodsCounselCrudService;
import com.digiwin.dap.middleware.gmc.service.goodscounsel.GoodsCounselService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GoodsCounselServiceImpl
implements GoodsCounselService {
    @Autowired
    private GoodsCrudService goodsCrudService;
    @Autowired
    private GoodsCounselCrudService goodsCounselCrudService;
    @Autowired
    private SellingStrategyCrudService sellingStrategyCrudService;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrderDetailMapper orderDetailMapper;
    @Autowired
    private GoodsRepository goodsRepository;

    @Transactional
    public long addGoodsCounsel(GoodsCounselDTO dto) {
        if (dto.getGoodsSid() != null) {
            Goods goods = (Goods)Optional.ofNullable(this.goodsCrudService.findBySid(dto.getGoodsSid().longValue())).orElseThrow(() -> new BusinessException(String.format("\u6ca1\u6709\u6b64\u5546\u54c1[%s]", dto.getGoodsSid())));
            if (StrUtils.isEmpty((String)dto.getGoodsCode())) {
                dto.setGoodsCode(goods.getCode());
                dto.setGoodsName(goods.getDisplayName());
            }
        }
        if (dto.getStrategySid() != null) {
            SellingStrategy sellingStrategy = (SellingStrategy)Optional.ofNullable(this.sellingStrategyCrudService.findBySid(dto.getStrategySid().longValue())).orElseThrow(() -> new BusinessException(String.format("\u6ca1\u6709\u6b64\u9500\u552e\u65b9\u6848[%s]", dto.getStrategySid())));
            if (StrUtils.isEmpty((String)dto.getStrategyCode())) {
                dto.setStrategyCode(sellingStrategy.getCode());
                dto.setStrategyName(sellingStrategy.getName());
            }
        }
        String cartCode = "";
        if (StrUtils.isNotEmpty((String)dto.getOrderCode())) {
            Goods goods;
            Order order = this.orderMapper.findByOrderCode(dto.getOrderCode());
            if (order == null) {
                throw new BusinessException((ErrorHandler)I18nError.ERROR_ORDER_NOT_EXIST, new Object[]{dto.getOrderCode()});
            }
            List orderDetails = this.orderDetailMapper.findByOrderSid(order.getSid());
            if (!orderDetails.isEmpty() && null != (goods = this.goodsRepository.findByCode(((OrderDetail)orderDetails.get(0)).getGoodsCode()))) {
                dto.setGoodsCode(((OrderDetail)orderDetails.get(0)).getGoodsCode());
                dto.setGoodsSid(Long.valueOf(goods.getSid()));
                dto.setGoodsName(goods.getDisplayName());
            }
            cartCode = order.getCartCode();
        }
        if (StrUtils.isNotEmpty((String)dto.getCartCode())) {
            List cartOrderVos = this.orderDetailMapper.getShoppingCartOrderVos(new ShoppingCartOrderVO(dto.getCartCode(), null));
            if (cartOrderVos.isEmpty()) {
                throw new BusinessException((ErrorHandler)I18nError.ERROR_CART_ORDER_NOT_EXIST, new Object[]{dto.getCartCode()});
            }
            if (!cartCode.equals(dto.getCartCode())) {
                throw new BusinessException((ErrorHandler)I18nError.ERROR_CART_ORDER_NOT_EXIST_ORDER_CODE, new Object[]{dto.getCartCode(), dto.getOrderCode()});
            }
        }
        return this.goodsCounselCrudService.create((BaseEntity)dto.doForward());
    }
}

