/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.service.goodsextra.impl;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.gmc.constant.enums.ChangeTypeEnum;
import com.digiwin.dap.middleware.gmc.domain.goods.GoodsVO;
import com.digiwin.dap.middleware.gmc.domain.pack.PackVO;
import com.digiwin.dap.middleware.gmc.entity.GoodsExtra;
import com.digiwin.dap.middleware.gmc.repository.GoodsExtraRepository;
import com.digiwin.dap.middleware.gmc.service.goodsextra.GoodsExtraCrudService;
import com.digiwin.dap.middleware.gmc.support.remote.RemoteLMCService;
import com.digiwin.dap.middleware.service.impl.BaseEntityManagerService;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GoodsExtraCrudServiceImpl
extends BaseEntityManagerService<GoodsExtra>
implements GoodsExtraCrudService {
    @Autowired
    private GoodsExtraRepository goodsExtraRepository;
    @Autowired
    private RemoteLMCService remoteLMCService;

    protected GoodsExtraRepository getRepository() {
        return this.goodsExtraRepository;
    }

    public GoodsExtra findByGoodsCode(String goodsCode) {
        return this.goodsExtraRepository.findByGoodsCode(goodsCode);
    }

    public List<GoodsExtra> findByGoodsCodeIn(List<String> goodsCodes) {
        return this.goodsExtraRepository.findByGoodsCodeIn(goodsCodes);
    }

    @Transactional
    public void save(GoodsVO goodsVO) {
        GoodsExtra goodsExtra = this.goodsExtraRepository.findByGoodsCode(goodsVO.getCode());
        if (goodsExtra != null) {
            this.update((BaseEntity)goodsVO.toExtra(goodsExtra));
        } else {
            this.create((BaseEntity)goodsVO.toExtra());
        }
    }

    public void updateGoodsPurpose(GoodsVO goodsVO) {
        GoodsExtra goodsExtra = this.goodsExtraRepository.findByGoodsCode(goodsVO.getCode());
        if (goodsExtra != null) {
            goodsExtra.setGoodsPurpose(goodsVO.getGoodsPurpose());
            this.update((BaseEntity)goodsExtra);
        }
    }

    public void save(PackVO packVO) {
        GoodsExtra goodsExtra = this.goodsExtraRepository.findByGoodsCode(packVO.getCode());
        if (goodsExtra != null) {
            PackVO existedPackVO = PackVO.fromExtra((Long)packVO.getSid(), (GoodsExtra)goodsExtra);
            this.update((BaseEntity)packVO.toExtra(goodsExtra));
            HashMap<String, String> logField = new HashMap<String, String>();
            logField.put("fieldName", "goodsPurpose");
            logField.put("displayName", "\u5546\u54c1\u76ee\u6807");
            this.remoteLMCService.logChangeFields(ChangeTypeEnum.PACK_GOODS_INFO_UPDATE.getName(), (Object)existedPackVO, (Object)packVO, "digiwincloud", Arrays.asList(logField), Arrays.asList("sid"), String.valueOf(packVO.getSid()));
        } else {
            this.create((BaseEntity)packVO.toExtra());
        }
    }
}

