/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.service.goodsresource.impl;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.gmc.entity.GoodsResource;
import com.digiwin.dap.middleware.gmc.repository.GoodsResourceRepository;
import com.digiwin.dap.middleware.gmc.repository.MarketingConfigRepository;
import com.digiwin.dap.middleware.gmc.repository.SellingStrategyRepository;
import com.digiwin.dap.middleware.gmc.service.goodsresource.GoodsResourceService;
import com.digiwin.dap.middleware.util.EntityUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GoodsResourceServiceImpl
implements GoodsResourceService {
    @Autowired
    private GoodsResourceRepository goodsResourceRepository;
    @Autowired
    private SellingStrategyRepository sellingStrategyRepository;
    @Autowired
    private MarketingConfigRepository marketingConfigRepository;

    @Transactional
    public void save(String code, List<String> newResourceCodes) {
        List resources = this.goodsResourceRepository.findByCode(code);
        List delResourceCodes = resources.stream().map(GoodsResource::getResourceCode).filter(resourceCode -> !newResourceCodes.contains(resourceCode)).collect(Collectors.toList());
        this.goodsResourceRepository.deleteByResourceCodeIn(delResourceCodes);
        List oldResourceCodes = resources.stream().map(GoodsResource::getResourceCode).collect(Collectors.toList());
        ArrayList newResources = new ArrayList();
        newResourceCodes.stream().filter(p -> !oldResourceCodes.contains(p)).forEach(resourceCode -> {
            GoodsResource goodsResource = new GoodsResource();
            goodsResource.setCode(code);
            goodsResource.setResourceCode(resourceCode);
            EntityUtils.setCreateFields((BaseEntity)goodsResource);
            newResources.add(goodsResource);
        });
        this.goodsResourceRepository.saveAll(newResources);
        List goodsStrategies = this.sellingStrategyRepository.findAllByGoodsCode(code);
        goodsStrategies.forEach(strategy -> this.marketingConfigRepository.deleteByMainStrategySidAndAttachedGoodsCodeIn(strategy.getSid(), delResourceCodes));
    }

    public boolean check(String code, List<String> delResourceCodes) {
        List goodsStrategies = this.sellingStrategyRepository.findAllByGoodsCode(code);
        List strategySids = goodsStrategies.stream().map(BaseEntity::getSid).collect(Collectors.toList());
        List accessoryGoods = this.marketingConfigRepository.findByMainStrategySidIn(strategySids);
        return accessoryGoods.stream().anyMatch(p -> delResourceCodes.contains(p.getAttachedGoodsCode()));
    }
}

