/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.service.goodswebsite.impl;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.gmc.domain.goods.GoodsVO;
import com.digiwin.dap.middleware.gmc.entity.GoodsCloudWebSite;
import com.digiwin.dap.middleware.gmc.repository.GoodsCloudWebsiteRepository;
import com.digiwin.dap.middleware.gmc.service.goodswebsite.GoodsCloudWebsiteCrudService;
import com.digiwin.dap.middleware.service.impl.BaseEntityManagerService;
import com.digiwin.dap.middleware.util.EntityUtils;
import com.digiwin.dap.middleware.util.SnowFlake;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;

@Service
public class GoodsCloudWebsiteCrudServiceImpl
extends BaseEntityManagerService<GoodsCloudWebSite>
implements GoodsCloudWebsiteCrudService {
    @Autowired
    private GoodsCloudWebsiteRepository goodsCloudWebsiteRepository;

    protected JpaRepository getRepository() {
        return this.goodsCloudWebsiteRepository;
    }

    public void saveAll(GoodsVO goodsVO) {
        List cloudWebSites = this.goodsCloudWebsiteRepository.findByGoodsCode(goodsVO.getCode());
        goodsVO.getCloudWebsiteVOS().forEach(w -> {
            GoodsCloudWebSite existed = cloudWebSites.stream().filter(e -> e.getTenantComeFrom().equals(w.getTenantComeFrom())).findFirst().orElse(null);
            if (existed != null) {
                existed.setWebsite(w.getWebsite());
                EntityUtils.setModifyFields((BaseEntity)existed);
            } else {
                existed = new GoodsCloudWebSite();
                existed.setSid(SnowFlake.getInstance().newId());
                existed.setGoodsCode(goodsVO.getCode());
                existed.setTenantComeFrom(w.getTenantComeFrom());
                existed.setWebsite(w.getWebsite());
                EntityUtils.setCreateFields((BaseEntity)existed);
            }
            this.goodsCloudWebsiteRepository.save((Object)existed);
        });
        if (cloudWebSites.size() > goodsVO.getCloudWebsiteVOS().size()) {
            cloudWebSites.forEach(w -> {
                if (goodsVO.getCloudWebsiteVOS().stream().noneMatch(e -> e.getTenantComeFrom().equals(w.getTenantComeFrom()))) {
                    this.goodsCloudWebsiteRepository.delete(w);
                }
            });
        }
    }
}

