/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.service.impl;

import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.commons.core.codec.Base64;
import com.digiwin.dap.middleware.gmc.constant.I18nError;
import com.digiwin.dap.middleware.gmc.service.CyberSecurityService;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class CyberSecurityServiceImpl
implements CyberSecurityService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CyberSecurityServiceImpl.class);

    public void logSecurityError(Object reqData) {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        this.logSecurityError(UserUtils.getUserName(), UserUtils.getUserId(), AppAuthContextHolder.getContext().getClientIP(), request.getMethod(), request.getRequestURI(), UserUtils.getToken(), UserUtils.getAppToken(), Base64.encode((String)JsonUtils.writeValue((Object)reqData)));
    }

    public void logSecurityError(String requestUri, Object reqData) {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        this.logSecurityError(UserUtils.getUserName(), UserUtils.getUserId(), AppAuthContextHolder.getContext().getClientIP(), request.getMethod(), requestUri, UserUtils.getToken(), UserUtils.getAppToken(), Base64.encode((String)JsonUtils.writeValue((Object)reqData)));
    }

    public void logSecurityError(String userName, String userId, String ip, String method, String requestUri, String userToken, String appToken, String encryptData) {
        StackTraceElement caller = this.findCaller(Thread.currentThread().getStackTrace());
        LOGGER.error("\u5b89\u5168\u65e5\u5fd7\u6765\u6e90-->>> {}#{}: {}", new Object[]{caller.getClassName(), caller.getMethodName(), caller.getLineNumber()});
        String msg = I18nError.GMC_USER_PERMISSION_COMMON_ERROR_LOG.getMessage(new Object[]{userName, userId, ip, method, requestUri, userToken, appToken, encryptData});
        LOGGER.error(msg);
    }

    private StackTraceElement findCaller(StackTraceElement[] trace) {
        for (StackTraceElement element : trace) {
            String cls = element.getClassName();
            if (cls.startsWith("java.lang.Thread") || cls.contains("CyberSecurityServiceImpl")) continue;
            return element;
        }
        return trace[0];
    }
}

