/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.service.marketing.impl;

import com.digiwin.dap.middleware.gmc.domain.marketing.MarketingConfigDetailVO;
import com.digiwin.dap.middleware.gmc.entity.MarketingConfig;
import com.digiwin.dap.middleware.gmc.mapper.MarketConfigMapper;
import com.digiwin.dap.middleware.gmc.repository.MarketingConfigRepository;
import com.digiwin.dap.middleware.gmc.service.marketing.MarketingConfigCrudService;
import com.digiwin.dap.middleware.service.impl.BaseEntityManagerService;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class MarketingConfigCrudServiceImpl
extends BaseEntityManagerService<MarketingConfig>
implements MarketingConfigCrudService {
    @Autowired
    private MarketingConfigRepository marketingConfigRepository;
    @Autowired
    private MarketConfigMapper marketConfigMapper;

    protected JpaRepository getRepository() {
        return this.marketingConfigRepository;
    }

    public List<MarketingConfigDetailVO> findPlatformByMainGoodsCodeIn(List<String> goodsCodes) {
        if (CollectionUtils.isEmpty(goodsCodes)) {
            return Collections.emptyList();
        }
        return this.marketConfigMapper.findPlatformByMainGoodsCodeIn(goodsCodes);
    }

    public List<MarketingConfig> findByAttachedStrategySid(Long attachedStrategySid) {
        return this.marketingConfigRepository.findByAttachedStrategySid(attachedStrategySid);
    }

    @Transactional
    public void deleteByMainStrategySid(Long mainStrategySid) {
        this.marketingConfigRepository.deleteByMainStrategySid(mainStrategySid);
    }
}

