/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.service.marketing.impl;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.Page;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.gmc.constant.I18nError;
import com.digiwin.dap.middleware.gmc.constant.enums.MarketingConfigTypeEnum;
import com.digiwin.dap.middleware.gmc.domain.marketing.MarketingConfigAddRequest;
import com.digiwin.dap.middleware.gmc.domain.marketing.MarketingConfigChangeMailVO;
import com.digiwin.dap.middleware.gmc.domain.marketing.MarketingConfigDetailVO;
import com.digiwin.dap.middleware.gmc.domain.marketing.MarketingConfigSearchRequest;
import com.digiwin.dap.middleware.gmc.domain.marketing.MarketingConfigSearchResponse;
import com.digiwin.dap.middleware.gmc.entity.Goods;
import com.digiwin.dap.middleware.gmc.entity.MarketingConfig;
import com.digiwin.dap.middleware.gmc.entity.SellingStrategy;
import com.digiwin.dap.middleware.gmc.mapper.MarketConfigMapper;
import com.digiwin.dap.middleware.gmc.repository.GoodsRepository;
import com.digiwin.dap.middleware.gmc.repository.MarketingConfigRepository;
import com.digiwin.dap.middleware.gmc.repository.SellingStrategyRepository;
import com.digiwin.dap.middleware.gmc.service.marketing.MarketingConfigCrudService;
import com.digiwin.dap.middleware.gmc.service.marketing.MarketingConfigService;
import com.digiwin.dap.middleware.gmc.support.stream.PutawayMessageService;
import com.github.pagehelper.PageSerializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class MarketingConfigServiceImpl
implements MarketingConfigService {
    @Resource
    private MarketingConfigCrudService marketingConfigCrudService;
    @Resource
    private MarketingConfigRepository marketingConfigRepository;
    @Resource
    private SellingStrategyRepository sellingStrategyRepository;
    @Resource
    private PutawayMessageService putawayMessageService;
    @Resource
    private GoodsRepository goodsRepository;
    @Resource
    private MarketConfigMapper marketConfigMapper;

    @Transactional
    public void save(MarketingConfigAddRequest request) {
        List exist = this.marketingConfigRepository.findByMainGoodsCode(request.getMainGoodsCode());
        MarketingConfigServiceImpl.checkRequest((MarketingConfigAddRequest)request, (List)exist);
        this.doSave(request);
        this.sendMail(request, exist.stream().filter(a -> Objects.equals(a.getType(), request.getType()) && Objects.equals(a.getMainStrategySid(), request.getMainStrategySid())).collect(Collectors.toList()));
    }

    private void doSave(MarketingConfigAddRequest request) {
        List details = request.getDetails();
        List existingConfigs = this.marketingConfigRepository.findByMainGoodsCodeAndTypeAndMainStrategySid(request.getMainGoodsCode(), request.getType(), request.getMainStrategySid());
        List newConfigs = CollectionUtils.isEmpty((Collection)details) ? Collections.emptyList() : details.stream().map(a -> new MarketingConfig(request.getType(), request.getMainGoodsCode(), request.getMainStrategySid(), a.getAttachedGoodsCode(), a.getAttachedStrategySid())).collect(Collectors.toList());
        List toDelete = existingConfigs.stream().filter(existing -> !newConfigs.contains(existing)).collect(Collectors.toList());
        List toAdd = newConfigs.stream().filter(newConfig -> !existingConfigs.contains(newConfig)).collect(Collectors.toList());
        List toUpdate = existingConfigs.stream().filter(newConfigs::contains).collect(Collectors.toList());
        toUpdate.addAll(toAdd);
        if (!CollectionUtils.isEmpty(toDelete)) {
            this.marketingConfigRepository.deleteAll(toDelete);
        }
        if (!CollectionUtils.isEmpty(toUpdate)) {
            this.marketingConfigCrudService.saveAll(toUpdate);
        }
    }

    private void sendMail(MarketingConfigAddRequest request, List<MarketingConfig> exist) {
        List newConfigs = request.getDetails().stream().map(a -> new MarketingConfig(request.getType(), request.getMainGoodsCode(), request.getMainStrategySid(), a.getAttachedGoodsCode(), a.getAttachedStrategySid())).collect(Collectors.toList());
        List<MarketingConfigChangeMailVO> addedList = newConfigs.stream().filter(newConfig -> !exist.contains(newConfig)).map(config -> this.toMailVO(config, "add")).filter(Objects::nonNull).collect(Collectors.toList());
        List<MarketingConfigChangeMailVO> canceledList = exist.stream().filter(existConfig -> !newConfigs.contains(existConfig)).map(config -> this.toMailVO(config, "del")).filter(Objects::nonNull).collect(Collectors.toList());
        if (!addedList.isEmpty()) {
            addedList.forEach(a -> this.putawayMessageService.sendMarketConfigChangeMail(a));
        }
        if (!canceledList.isEmpty()) {
            canceledList.forEach(a -> this.putawayMessageService.sendMarketConfigChangeMail(a));
        }
    }

    private MarketingConfigChangeMailVO toMailVO(MarketingConfig config, String flag) {
        String selector;
        Optional optionalSellingStrategy = this.sellingStrategyRepository.findById((Object)config.getAttachedStrategySid());
        if (!optionalSellingStrategy.isPresent()) {
            return null;
        }
        MarketingConfigChangeMailVO vo = new MarketingConfigChangeMailVO();
        vo.setChangeFlag(flag);
        vo.setType(config.getType());
        vo.setCode(config.getAttachedGoodsCode());
        vo.setGoodsInCharge(optionalSellingStrategy.map(a -> {
            Goods goods = Optional.ofNullable(this.goodsRepository.findByCode(a.getGoodsCode())).orElse(new Goods());
            return CharSequenceUtil.format((CharSequence)"{}({}) - {}({})", (Object[])new Object[]{goods.getDisplayName(), goods.getCode(), a.getName(), a.getCode()});
        }).orElse(""));
        Goods mainGoods = this.goodsRepository.findByCode(config.getMainGoodsCode());
        if (config.getMainStrategySid() == null) {
            selector = CharSequenceUtil.format((CharSequence)"{}({})", (Object[])new Object[]{mainGoods.getDisplayName(), mainGoods.getCode()});
        } else {
            SellingStrategy mainStrategy = this.sellingStrategyRepository.findById((Object)config.getMainStrategySid()).orElse(new SellingStrategy());
            selector = CharSequenceUtil.format((CharSequence)"{}({}) - {}({})", (Object[])new Object[]{mainGoods.getDisplayName(), mainGoods.getCode(), mainStrategy.getName(), mainStrategy.getCode()});
        }
        vo.setSelector(selector);
        return vo;
    }

    private static void checkRequest(MarketingConfigAddRequest request, List<MarketingConfig> exist) {
        if (CollectionUtils.isEmpty((Collection)request.getDetails())) {
            return;
        }
        Integer type = request.getType();
        List attachedGoodsCodes = request.getDetails().stream().map(MarketingConfigDetailVO::getAttachedGoodsCode).collect(Collectors.toList());
        if (MarketingConfigTypeEnum.isPlatform((Integer)type)) {
            boolean hasOtherPlatformType = exist.stream().anyMatch(e -> MarketingConfigTypeEnum.isPlatform((Integer)e.getType()) && !Objects.equals(type, e.getType()));
            if (hasOtherPlatformType) {
                throw new BusinessException((ErrorHandler)I18nError.GMC_MARKETING_COEXIST, request.getMainGoodsCode());
            }
            List collect = exist.stream().filter(e -> MarketingConfigTypeEnum.RELATED.getType().equals(e.getType()) && attachedGoodsCodes.contains(e.getAttachedGoodsCode())).collect(Collectors.toList());
            if (!collect.isEmpty()) {
                throw new BusinessException((ErrorHandler)I18nError.GMC_MARKETING_BOTH_CONFIG_PLATFORM_RELATED_ERROR, new Object[]{request.getMainGoodsCode(), collect.stream().map(MarketingConfig::getAttachedGoodsCode).collect(Collectors.joining(","))});
            }
            return;
        }
        if (MarketingConfigTypeEnum.RELATED.getType().equals(type)) {
            List collect = exist.stream().filter(e -> MarketingConfigTypeEnum.isPlatform((Integer)e.getType()) && attachedGoodsCodes.contains(e.getAttachedGoodsCode())).collect(Collectors.toList());
            if (!collect.isEmpty()) {
                throw new BusinessException((ErrorHandler)I18nError.GMC_MARKETING_BOTH_CONFIG_PLATFORM_RELATED_ERROR, new Object[]{request.getMainGoodsCode(), collect.stream().map(MarketingConfig::getAttachedGoodsCode).collect(Collectors.joining(","))});
            }
            return;
        }
        throw new BusinessException(StrUtil.format((CharSequence)"\u4e0d\u652f\u6301\u7684\u8425\u9500\u914d\u7f6e\u7c7b\u578b: {}", (Object[])new Object[]{type}));
    }

    public PageSerializable<MarketingConfigSearchResponse> search(MarketingConfigSearchRequest request, Page page) {
        List list = this.marketConfigMapper.searchMarketConfig(request, page.getPageNum().intValue(), page.getPageSize().intValue(), page.getOrderBy());
        List mainGoodsCodes = list.stream().map(MarketingConfigSearchResponse::getMainGoodsCode).collect(Collectors.toList());
        List details = new ArrayList();
        if (!CollectionUtils.isEmpty(mainGoodsCodes)) {
            details = this.marketConfigMapper.findDetail(mainGoodsCodes, request.getTypes());
            details.forEach(MarketingConfigDetailVO::changeModules);
        }
        Map<String, List<MarketingConfigDetailVO>> groupedDetails = details.stream().collect(Collectors.groupingBy(detail -> this.generateGroupKey(detail.getType(), detail.getMainGoodsCode(), detail.getMainStrategySid())));
        list.forEach(response -> {
            String key = this.generateGroupKey(response.getType(), response.getMainGoodsCode(), response.getMainStrategySid());
            List detailList = groupedDetails.getOrDefault(key, new ArrayList());
            response.setDetails(detailList);
            for (MarketingConfigDetailVO detail : detailList) {
                if (!detail.getModifyDate().isAfter(response.getModifyDate())) continue;
                response.setModifyDate(detail.getModifyDate());
                response.setModifyById(detail.getModifyById());
            }
        });
        return PageSerializable.of((List)list);
    }

    private String generateGroupKey(Integer type, String mainGoodsCode, Long mainStrategySid) {
        return String.format("%d_%s_%s", type == null ? 0 : type, mainGoodsCode == null ? "" : mainGoodsCode, mainStrategySid == null ? "null" : mainStrategySid.toString());
    }
}

