/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.service.multilanguageresource.Impl;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.gmc.constant.GmcConstant;
import com.digiwin.dap.middleware.gmc.domain.goods.GoodsLanguage;
import com.digiwin.dap.middleware.gmc.domain.goods.MultiLanguageVO;
import com.digiwin.dap.middleware.gmc.domain.multilanguage.DataVO;
import com.digiwin.dap.middleware.gmc.entity.Goods;
import com.digiwin.dap.middleware.gmc.entity.MultiLanguageResource;
import com.digiwin.dap.middleware.gmc.mapper.MultiLanguageResourceMapper;
import com.digiwin.dap.middleware.gmc.repository.MultiLanguageResourceRepository;
import com.digiwin.dap.middleware.gmc.service.multilanguageresource.LanguageService;
import com.digiwin.dap.middleware.gmc.service.multilanguageresource.MultiLanguageResourceCrudService;
import com.digiwin.dap.middleware.gmc.support.remote.IamService;
import com.digiwin.dap.middleware.language.entity.LanguageResource;
import com.digiwin.dap.middleware.language.mapper.LanguageMapper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ibatis.annotations.Param;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service(value="gmcLanguageServiceImpl")
public class LanguageServiceImpl
implements LanguageService {
    private static final Logger logger = LoggerFactory.getLogger(LanguageServiceImpl.class);
    @Autowired
    private IamService iamService;
    @Autowired
    private MultiLanguageResourceMapper multiLanguageResourceMapper;
    @Autowired
    private MultiLanguageResourceCrudService multiLanguageResourceCrudService;
    @Autowired
    private MultiLanguageResourceRepository multiLanguageResourceRepository;
    @Autowired
    private LanguageMapper languageMapper;

    private static List<Field> getFields(Class<?> clazz) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        while (clazz != null) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                if (field.isSynthetic()) continue;
                fieldList.add(field);
            }
            clazz = clazz.getSuperclass();
        }
        return fieldList;
    }

    private long getSidValue(Object object, List<Field> fields) {
        for (Field field : fields) {
            field.setAccessible(true);
            try {
                if ("sid".equals(field.getName())) {
                    return (Long)field.get(object);
                }
                field.setAccessible(false);
            }
            catch (Exception e) {
                logger.warn("\u83b7\u53d6\u4e3b\u952e\u503c\uff1a{}", (Object)e.getMessage());
            }
        }
        return 0L;
    }

    public List<MultiLanguageResource> getLanguage(List<Long> dataSids, String language) {
        List byDataSidsAndLanguage = this.languageMapper.findByDataSidsAndLanguage(dataSids, language);
        LinkedList<MultiLanguageResource> ret = new LinkedList<MultiLanguageResource>();
        for (LanguageResource languageResource : byDataSidsAndLanguage) {
            MultiLanguageResource multiLanguageResource = new MultiLanguageResource();
            multiLanguageResource.setDataSid(languageResource.getDataSid());
            multiLanguageResource.setFieldName(languageResource.getFieldName());
            multiLanguageResource.setContent(languageResource.getContent());
            multiLanguageResource.setLanguage(languageResource.getLanguage());
            ret.add(multiLanguageResource);
        }
        return ret;
    }

    public List<GoodsLanguage> getGoodsByCodes(@Param(value="goodsCodes") List<String> goodsCodes) {
        return this.multiLanguageResourceMapper.getGoodsByCodes(goodsCodes);
    }

    public void setLanguage(List<?> objects, List<Long> sids, Class<?> clazz) {
        List languages = this.getLanguage(sids, LocaleContextHolder.getLocale().toLanguageTag());
        if (languages.isEmpty() && !GmcConstant.DEFAULT_LANGUAGES.contains(LocaleContextHolder.getLocale().toLanguageTag())) {
            languages = this.getLanguage(sids, "en-US");
        }
        List dataSids = languages.stream().map(MultiLanguageResource::getDataSid).collect(Collectors.toList());
        List filedNames = languages.stream().map(MultiLanguageResource::getFieldName).collect(Collectors.toList());
        Map contents = languages.stream().collect(Collectors.toMap(o -> o.getDataSid() + "-" + o.getFieldName(), Function.identity()));
        List fields = LanguageServiceImpl.getFields(clazz);
        List languageFields = fields.stream().filter(field -> filedNames.contains(field.getName())).collect(Collectors.toList());
        for (Object object : objects) {
            long dataSid = this.getSidValue(object, fields);
            if (!dataSids.contains(dataSid)) continue;
            for (Field field2 : languageFields) {
                field2.setAccessible(true);
                try {
                    if (null == contents.get(dataSid + "-" + field2.getName())) continue;
                    String languageFileValue = ((MultiLanguageResource)contents.get(dataSid + "-" + field2.getName())).getContent();
                    if (languageFileValue != null) {
                        field2.set(object, languageFileValue);
                    }
                    field2.setAccessible(false);
                }
                catch (Exception e) {
                    logger.warn("\u8d4b\u503c\u591a\u8bed\u8a00\uff1a{}", (Object)e.getMessage());
                }
            }
        }
    }

    public void saveMultiLanguage(Long dataSid, String language, List<DataVO> datas) {
        if (CollectionUtils.isEmpty(datas)) {
            return;
        }
        for (DataVO data : datas) {
            MultiLanguageResource multiLanguageResource = this.multiLanguageResourceRepository.findByDataSidAndFieldNameAndLanguage(dataSid.longValue(), data.getFieldName(), language);
            if (multiLanguageResource == null) {
                MultiLanguageResource multiLanguageResource1 = new MultiLanguageResource();
                multiLanguageResource1.setDataSid(dataSid.longValue());
                multiLanguageResource1.setFieldName(data.getFieldName());
                multiLanguageResource1.setLanguage(language);
                multiLanguageResource1.setContent(data.getContent());
                this.multiLanguageResourceCrudService.create((BaseEntity)multiLanguageResource1);
                continue;
            }
            multiLanguageResource.setContent(data.getContent());
            this.multiLanguageResourceCrudService.update((BaseEntity)multiLanguageResource);
        }
    }

    public void saveMultiLanguage(Goods goods, List<MultiLanguageVO> multiLanguageVOS) {
        if (CollectionUtils.isEmpty(multiLanguageVOS)) {
            return;
        }
        for (MultiLanguageVO multiLanguageVO : multiLanguageVOS) {
            if (null == multiLanguageVO.getDataSid() || 0L == multiLanguageVO.getDataSid()) {
                multiLanguageVO.setDataSid(Long.valueOf(goods.getSid()));
            }
            this.saveMultiLanguage(multiLanguageVO.getDataSid(), multiLanguageVO.getLanguage(), multiLanguageVO.getData());
        }
    }
}

