/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.service.pack.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.gmc.constant.I18nError;
import com.digiwin.dap.middleware.gmc.constant.enums.GoodsCategoryEnum;
import com.digiwin.dap.middleware.gmc.domain.goods.GoodsVO;
import com.digiwin.dap.middleware.gmc.domain.pack.PackDetailVO;
import com.digiwin.dap.middleware.gmc.domain.pack.PackGoodsVO;
import com.digiwin.dap.middleware.gmc.domain.pack.PackVO;
import com.digiwin.dap.middleware.gmc.entity.Goods;
import com.digiwin.dap.middleware.gmc.entity.GoodsResource;
import com.digiwin.dap.middleware.gmc.entity.PackDetail;
import com.digiwin.dap.middleware.gmc.mapper.GoodsResourceMapper;
import com.digiwin.dap.middleware.gmc.mapper.PackMapper;
import com.digiwin.dap.middleware.gmc.repository.GoodsRepository;
import com.digiwin.dap.middleware.gmc.repository.PackDetailRepository;
import com.digiwin.dap.middleware.gmc.service.goods.GoodsCrudService;
import com.digiwin.dap.middleware.gmc.service.goodsextra.GoodsExtraCrudService;
import com.digiwin.dap.middleware.gmc.service.pack.PackDetailCrudService;
import com.digiwin.dap.middleware.gmc.service.pack.PackService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class PackServiceImpl
implements PackService {
    @Autowired
    private PackDetailCrudService packDetailCrudService;
    @Autowired
    private PackDetailRepository packDetailRepository;
    @Autowired
    private GoodsRepository goodsRepository;
    @Autowired
    private GoodsCrudService goodsCrudService;
    @Autowired
    private PackMapper packMapper;
    @Autowired
    private GoodsResourceMapper goodsResourceMapper;
    @Autowired
    private GoodsExtraCrudService goodsExtraCrudService;

    public long savePack(PackVO packVO) {
        Goods pack = packVO.generatePack(packVO);
        Goods existedGoods = this.goodsCrudService.findByCode(packVO.getCode());
        if (StringUtils.isEmpty((Object)packVO.getSid()) || packVO.getSid() == 0L) {
            if (null != existedGoods) {
                throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, String.format("\u7ec4\u5408\u5546\u54c1[%s]\u5df2\u5b58\u5728", packVO.getCode()));
            }
            this.goodsCrudService.create((BaseEntity)pack);
        } else {
            this.goodsCrudService.update((BaseEntity)pack);
        }
        packVO.setSid(Long.valueOf(pack.getSid()));
        this.goodsExtraCrudService.save(packVO);
        return pack.getSid();
    }

    @Transactional
    public List<Long> savePackDetail(List<PackDetailVO> packDetailVOS, Long packSid) {
        Goods goods = (Goods)this.goodsCrudService.findBySid(packSid.longValue());
        this.goodsCrudService.update((BaseEntity)goods);
        ArrayList<Long> sids = new ArrayList<Long>();
        packDetailVOS.forEach(o -> {
            if (o.getState().equals(2)) {
                this.packDetailRepository.deleteBySid(o.getSid().longValue());
            }
        });
        this.packDetailRepository.flush();
        packDetailVOS.forEach(o -> {
            o.setPackSid(packSid);
            PackDetail packDetail = o.generatePackDetail(o);
            if (o.getState().equals(0)) {
                long sid = this.packDetailCrudService.create((BaseEntity)packDetail);
                sids.add(sid);
            }
            if (o.getState().equals(1)) {
                this.packDetailCrudService.update((BaseEntity)packDetail);
                sids.add(packDetail.getSid());
            }
        });
        return sids;
    }

    public long deletePack(Long sid) {
        this.packDetailRepository.deleteByPackSid(sid.longValue());
        return this.goodsRepository.deleteBySid(sid.longValue());
    }

    public void checkDeletablePackStrategy(Long strategySid) {
        List goodsVOS = this.packMapper.findPackByCondition(null, strategySid, Boolean.valueOf(true));
        if (!CollectionUtils.isEmpty((Collection)goodsVOS)) {
            throw new BusinessException((ErrorHandler)I18nError.GMC_STRATEGY_IN_PACK, new Object[]{goodsVOS.stream().map(GoodsVO::getCode).collect(Collectors.joining(","))});
        }
    }

    public void checkDeletablePackGoods(Long goodsSid) {
        List goodsVOS = this.packMapper.findPackByCondition(goodsSid, null, Boolean.valueOf(true));
        if (!CollectionUtils.isEmpty((Collection)goodsVOS)) {
            throw new BusinessException((ErrorHandler)I18nError.GMC_GOODS_IN_PACK, new Object[]{goodsVOS.stream().map(GoodsVO::getCode).collect(Collectors.joining(","))});
        }
    }

    public String checkDeletableResourceGoods(String categoryId, String goodsCode, boolean throwException) {
        List resourceGoods;
        if (GoodsCategoryEnum.isResource((String)categoryId) && !(resourceGoods = this.goodsResourceMapper.findByResourceCode(goodsCode)).isEmpty()) {
            String goodsInfo = resourceGoods.stream().map(p -> p.getName() + "(" + p.getCode() + ")").collect(Collectors.joining(","));
            if (throwException) {
                throw new BusinessException("\u5f53\u524d\u5546\u54c1\u5df2\u88ab\u3010" + goodsInfo + "\u3011\u5f15\u7528\u4f7f\u7528\uff0c\u8bf7\u5148\u53bb\u53d6\u6d88\u5f15\u7528\u3002");
            }
            return "\u5f53\u524d\u5546\u54c1\u5df2\u88ab\u3010" + goodsInfo + "\u3011\u5f15\u7528\u4f7f\u7528\u3002\u82e5\u957f\u671f\u4e0b\u67b6\uff0c\u5efa\u8bae\u5148\u53bb\u53d6\u6d88\u5f15\u7528\u3002";
        }
        return null;
    }

    public void checkDeletableResourceGoodsStrategy(String strategyCode) {
        List resourceGoods = this.goodsResourceMapper.findByResourceStrategyCode(strategyCode);
        if (!resourceGoods.isEmpty()) {
            String goodsInfo = resourceGoods.stream().map(p -> p.getName() + "(" + p.getCode() + ")").collect(Collectors.joining(","));
            String errMsg = "\u5f53\u524d\u9500\u552e\u65b9\u6848\u5df2\u88ab\u3010" + goodsInfo + "\u3011\u7684\u9500\u552e\u65b9\u6848\u642d\u914d\u6216\u76f8\u4f9d\u4f7f\u7528\uff0c\u8bf7\u5148\u53bb\u53d6\u6d88\u8425\u9500\u914d\u7f6e\u3002";
            throw new BusinessException(errMsg);
        }
    }

    public void checkAuditResourceGoods(long packGoodSid) {
        List packGoods = this.packMapper.findPackGoods(packGoodSid);
        List<String> resourceCodes = packGoods.stream().filter(g -> GoodsCategoryEnum.RESOURCE.name().equalsIgnoreCase(g.getCategoryId())).map(PackGoodsVO::getGoodsCode).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(resourceCodes)) {
            return;
        }
        List appCodes = packGoods.stream().filter(g -> GoodsCategoryEnum.APP.name().equalsIgnoreCase(g.getCategoryId())).map(PackGoodsVO::getGoodsCode).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(appCodes)) {
            throw new BusinessException((ErrorHandler)I18nError.GMC_RESOURCE_NO_APP_RELATION);
        }
        List goodsResourceList = this.goodsResourceMapper.findByResourceCodeList(resourceCodes);
        if (CollectionUtils.isEmpty((Collection)goodsResourceList)) {
            throw new BusinessException((ErrorHandler)I18nError.GMC_RESOURCE_NO_APP_RELATION);
        }
        Map resourceAppMap = goodsResourceList.stream().collect(Collectors.groupingBy(GoodsResource::getResourceCode, Collectors.mapping(GoodsResource::getCode, Collectors.toList())));
        resourceCodes.forEach(resourceCode -> {
            List apps = resourceAppMap.getOrDefault(resourceCode, Collections.emptyList());
            if (appCodes.stream().noneMatch(apps::contains)) {
                throw new BusinessException((ErrorHandler)I18nError.GMC_RESOURCE_NO_APP_RELATION);
            }
        });
    }
}

