/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.service.recommendactivity.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.gmc.constant.I18nError;
import com.digiwin.dap.middleware.gmc.domain.recommendactivity.QueryParemater;
import com.digiwin.dap.middleware.gmc.domain.recommendactivity.RecommendActivityVO;
import com.digiwin.dap.middleware.gmc.entity.RecommendActivity;
import com.digiwin.dap.middleware.gmc.mapper.OrderMapper;
import com.digiwin.dap.middleware.gmc.repository.RecommendActivityRepository;
import com.digiwin.dap.middleware.gmc.service.coupon.CouponRuleCrudService;
import com.digiwin.dap.middleware.gmc.service.recommendactivity.RecommendActivityCrudService;
import com.digiwin.dap.middleware.gmc.service.recommendactivity.RecommendActivityService;
import com.digiwin.dap.middleware.gmc.util.CodeUtil;
import org.apache.logging.log4j.util.Strings;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
public class RecommendActivityServiceImpl
implements RecommendActivityService {
    @Autowired
    RecommendActivityRepository recommendActivityRepository;
    @Autowired
    CouponRuleCrudService couponRuleCrudService;
    @Autowired
    RecommendActivityCrudService recommendActivityCrudService;
    @Autowired
    OrderMapper orderMapper;

    public long addRecommendActivity(RecommendActivityVO recommendActivityVO) {
        Assert.notNull((Object)recommendActivityVO, (String)"recommendActivityVO is null");
        this.checkParameter(recommendActivityVO);
        if (recommendActivityVO.getUseCouponRule().booleanValue() && recommendActivityVO.getCouponRuleSid() == 0L) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, "\u4f7f\u7528\u5238\u89c4\u5219\u65f6\uff0c\u5238sid\u4e0d\u80fd\u4e3a0\uff01");
        }
        if (recommendActivityVO.getUseCouponRule().booleanValue() && !this.couponRuleCrudService.exists(recommendActivityVO.getCouponRuleSid())) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, String.format("\u6ca1\u6709\u53ef\u4f7f\u7528\u7684\u5238\u89c4\u5219:[%s]", recommendActivityVO.getCouponRuleSid()));
        }
        RecommendActivity newRecommendActivity = new RecommendActivity();
        BeanUtils.copyProperties((Object)recommendActivityVO, (Object)newRecommendActivity);
        String code = this.getRandomCode();
        newRecommendActivity.setReferralCode(code);
        return this.recommendActivityCrudService.create((BaseEntity)newRecommendActivity);
    }

    public void modifyRecommendActivity(RecommendActivityVO recommendActivityVO) {
        Assert.notNull((Object)recommendActivityVO, (String)"recommendActivityVO is null");
        this.checkParameter(recommendActivityVO);
        if (recommendActivityVO.getSid() == 0L) {
            throw new IllegalArgumentException("sid is 0");
        }
        RecommendActivity oldRecommendActivity = (RecommendActivity)this.recommendActivityCrudService.findBySid(recommendActivityVO.getSid());
        if (oldRecommendActivity == null) {
            throw new IllegalArgumentException(String.format("\u4e0d\u5b58\u5728\u63a8\u8350\u6d3b\u52a8:[%s]", recommendActivityVO.getSid()));
        }
        oldRecommendActivity.setResponsiblePerson(recommendActivityVO.getResponsiblePerson());
        oldRecommendActivity.setRemark(recommendActivityVO.getRemark());
        oldRecommendActivity.setShareAchievement(recommendActivityVO.getShareAchievement().booleanValue());
        oldRecommendActivity.setEndDate(recommendActivityVO.getEndDate());
        this.recommendActivityCrudService.update((BaseEntity)oldRecommendActivity);
    }

    public void updateShareAchievement(QueryParemater queryParemater) {
        Assert.notNull((Object)queryParemater, (String)"queryParemater is null");
        RecommendActivity recommendActivity = (RecommendActivity)this.recommendActivityCrudService.findBySid(queryParemater.getSid());
        if (recommendActivity == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, String.format("\u6ca1\u6709\u6b21\u63a8\u8350\u6d3b\u52a8:[%s]", queryParemater.getSid()));
        }
        recommendActivity.setShareAchievement(queryParemater.isShareAchievement());
        this.recommendActivityCrudService.update((BaseEntity)recommendActivity);
    }

    public void removeRecommendActivity(long sid) {
        int orderCount;
        RecommendActivity recommendActivity = (RecommendActivity)this.recommendActivityCrudService.findBySid(sid);
        if (recommendActivity == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, String.format("\u6ca1\u6709\u6b64\u63a8\u8350\u6d3b\u52a8[%s]", sid));
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (recommendActivity.isStatus()) {
            stringBuilder.append(String.format("\u63a8\u8350\u6d3b\u52a8[%s]\u4e3a\u5f00\u542f\u72b6\u6001,", sid));
        }
        if ((orderCount = this.orderMapper.countByRecommendedCode(recommendActivity.getReferralCode())) > 0) {
            stringBuilder.append(String.format("\u63a8\u8350\u6d3b\u52a8[%s]\u5df2\u88ab\u4f7f\u7528,", sid));
        }
        if (!Strings.isBlank((String)stringBuilder.toString())) {
            stringBuilder.append("\u4e0d\u53ef\u5220\u9664\uff01");
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, stringBuilder.toString());
        }
        this.recommendActivityCrudService.deleteById(sid);
    }

    private String getRandomCode() {
        String code = CodeUtil.getRandomCode();
        if (this.recommendActivityRepository.existsByReferralCode(code)) {
            code = this.getRandomCode();
        }
        return code;
    }

    private void checkParameter(RecommendActivityVO recommendActivityVO) {
        StringBuilder stringBuilder = new StringBuilder();
        if (StringUtils.isEmpty((Object)recommendActivityVO.getName())) {
            stringBuilder.append("recommendActivityVO.name\u4e0d\u80fd\u4e3a\u7a7a,");
        }
        if (StringUtils.isEmpty((Object)recommendActivityVO.getResponsiblePerson())) {
            stringBuilder.append("recommendActivityVO.responsiblePerson\u4e0d\u80fd\u4e3a\u7a7a,");
        }
        if (StringUtils.isEmpty((Object)recommendActivityVO.getBeginDate())) {
            stringBuilder.append("recommendActivityVO.beginDate\u4e0d\u80fd\u4e3a\u7a7a,");
        }
        if (StringUtils.isEmpty((Object)recommendActivityVO.getEndDate())) {
            stringBuilder.append("recommendActivityVO.endDate\u4e0d\u80fd\u4e3a\u7a7a,");
        }
        if (StringUtils.isEmpty((Object)recommendActivityVO.getUseCouponRule())) {
            stringBuilder.append("recommendActivityVO.useCouponRule\u4e0d\u80fd\u4e3a\u7a7a,");
        }
        if (StringUtils.isEmpty((Object)recommendActivityVO.getShareAchievement())) {
            stringBuilder.append("recommendActivityVO.shareAchievement\u4e0d\u80fd\u4e3a\u7a7a,");
        }
        if (StringUtils.isEmpty((Object)recommendActivityVO.getGoodsCategory())) {
            stringBuilder.append("recommendActivityVO.goodsCategory\u4e0d\u80fd\u4e3a\u7a7a,");
        }
        if (StringUtils.isEmpty((Object)recommendActivityVO.getGoodsCode())) {
            stringBuilder.append("recommendActivityVO.goodsCode\u4e0d\u80fd\u4e3a\u7a7a,");
        }
        if (StringUtils.isEmpty((Object)recommendActivityVO.getGoodsName())) {
            stringBuilder.append("recommendActivityVO.goodsName\u4e0d\u80fd\u4e3a\u7a7a,");
        }
        if (!Strings.isBlank((String)stringBuilder.toString())) {
            throw new IllegalArgumentException(stringBuilder.toString());
        }
    }
}

