/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.service.recommenduser.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.gmc.constant.I18nError;
import com.digiwin.dap.middleware.gmc.domain.EnvProperties;
import com.digiwin.dap.middleware.gmc.domain.coupon.CouponRuleVO;
import com.digiwin.dap.middleware.gmc.domain.coupon.UseStatus;
import com.digiwin.dap.middleware.gmc.domain.recommendactivity.RecommendActivityVO;
import com.digiwin.dap.middleware.gmc.domain.recommenduser.RecommendUserVO;
import com.digiwin.dap.middleware.gmc.domain.recommenduser.ValidateReferralCodeResult;
import com.digiwin.dap.middleware.gmc.domain.remote.ShareFileUrlVO;
import com.digiwin.dap.middleware.gmc.entity.RecommendActivity;
import com.digiwin.dap.middleware.gmc.entity.RecommendUser;
import com.digiwin.dap.middleware.gmc.entity.coupon.MyCoupon;
import com.digiwin.dap.middleware.gmc.mapper.CouponRuleMapper;
import com.digiwin.dap.middleware.gmc.repository.RecommendUserRepository;
import com.digiwin.dap.middleware.gmc.service.coupon.CouponRuleService;
import com.digiwin.dap.middleware.gmc.service.coupon.MyCouponCrudService;
import com.digiwin.dap.middleware.gmc.service.recommendactivity.RecommendActivityCrudService;
import com.digiwin.dap.middleware.gmc.service.recommenduser.RecommendUserCrudService;
import com.digiwin.dap.middleware.gmc.service.recommenduser.RecommendUserService;
import com.digiwin.dap.middleware.gmc.support.remote.DmcService;
import com.digiwin.dap.middleware.gmc.util.QRCodeUtil;
import com.digiwin.dap.middleware.util.ObjectCopyUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.time.LocalDateTime;
import javax.imageio.ImageIO;
import org.apache.logging.log4j.util.Strings;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
public class RecommendUserServiceImpl
implements RecommendUserService {
    @Autowired
    DmcService dmcService;
    @Autowired
    EnvProperties envProperties;
    @Autowired
    CouponRuleMapper couponRuleMapper;
    @Autowired
    CouponRuleService couponRuleService;
    @Autowired
    MyCouponCrudService myCouponCrudService;
    @Autowired
    RecommendUserRepository recommendUserRepository;
    @Autowired
    RecommendUserCrudService recommendUserCrudService;
    @Autowired
    RecommendActivityCrudService recommendActivityCrudService;

    public long addRecommendActivity(RecommendUserVO recommendUserVO) {
        Assert.notNull((Object)recommendUserVO, (String)"recommendUserVO is null");
        this.checkParameter(recommendUserVO);
        RecommendActivity recommendActivity = (RecommendActivity)this.recommendActivityCrudService.findBySid(recommendUserVO.getRecommendActivitySid());
        if (recommendActivity == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, String.format("\u4e0d\u5b58\u5728\u6b64\u63a8\u8350\u6d3b\u52a8:[%s]", recommendUserVO.getRecommendActivitySid()));
        }
        RecommendUser oldRecommendUser = (RecommendUser)this.recommendUserCrudService.findByUnionKey(new Object[]{recommendUserVO.getBusinessCode(), recommendUserVO.getDepartCode(), recommendUserVO.getRecommendActivitySid()});
        if (oldRecommendUser != null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, String.format("\u90e8\u95e8\u53f7:[%s],itcode:[%s]\u5728\u8be5\u63a8\u8350\u6d3b\u52a8[%s]\u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", recommendUserVO.getDepartCode(), recommendUserVO.getBusinessCode(), recommendUserVO.getRecommendActivitySid()));
        }
        RecommendUser recommendUser = new RecommendUser();
        BeanUtils.copyProperties((Object)recommendUserVO, (Object)recommendUser);
        String exclusiveReferralCode = recommendActivity.getReferralCode() + recommendUserVO.getDepartCode() + recommendUserVO.getBusinessCode();
        recommendUser.setExclusiveReferralCode(exclusiveReferralCode);
        String url = this.envProperties.getDigiwinCloudUrl() + "/product-details?goodsCode=" + recommendActivity.getGoodsCode() + "&exclusiveReferralCode=" + exclusiveReferralCode + "&departCode=" + recommendUserVO.getDepartCode() + "&businessCode=" + recommendUserVO.getBusinessCode();
        recommendUser.setExclusiveReferralUrl(url);
        byte[] qrCode = this.getQrCode(url);
        ShareFileUrlVO shareFileUrlVO = this.dmcService.getShareUrl(exclusiveReferralCode, qrCode);
        recommendUser.setTwoDimensionalCode(shareFileUrlVO.getUrl());
        return this.recommendUserCrudService.create((BaseEntity)recommendUser);
    }

    private byte[] getQrCode(String url) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            BufferedImage bufferedImage = QRCodeUtil.encode((String)url);
            ImageIO.write((RenderedImage)bufferedImage, "JPG", byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception e) {
            throw new BusinessException("\u751f\u6210\u4e8c\u7ef4\u7801\u51fa\u9519", (Throwable)e);
        }
    }

    public void modifyRecommendActivity(RecommendUserVO recommendUserVO) {
        Assert.notNull((Object)recommendUserVO, (String)"recommendUserVO is null");
        this.checkParameter(recommendUserVO);
        RecommendUser oldRecommendUser = (RecommendUser)this.recommendUserCrudService.findBySid(recommendUserVO.getSid());
        if (oldRecommendUser == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, String.format("\u4e0d\u5b58\u5728\u6b64\u63a8\u8350\u4eba:[%s]", recommendUserVO.getSid()));
        }
        if (!this.recommendActivityCrudService.exists(recommendUserVO.getRecommendActivitySid())) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, String.format("\u4e0d\u5b58\u5728\u6b64\u63a8\u8350\u6d3b\u52a8:[%s]", recommendUserVO.getRecommendActivitySid()));
        }
        oldRecommendUser.setName(recommendUserVO.getName());
        oldRecommendUser.setEmail(recommendUserVO.getEmail());
        this.recommendUserCrudService.update((BaseEntity)oldRecommendUser);
    }

    public ValidateReferralCodeResult validateReferralCode(long tenantSid, long userSid, String code, String appId) {
        RecommendActivity activity;
        RecommendUser user = this.recommendUserCrudService.findByExclusiveReferralCode(code);
        if (user != null && !code.equals(user.getExclusiveReferralCode())) {
            user = null;
        }
        ValidateReferralCodeResult result = new ValidateReferralCodeResult();
        if (user != null) {
            activity = (RecommendActivity)this.recommendActivityCrudService.findBySid(user.getRecommendActivitySid());
            if (activity != null) {
                RecommendUserVO userVO = new RecommendUserVO();
                ObjectCopyUtil.mergeDifferentTypeObject((Object)user, (Object)userVO);
                result.setUser(userVO);
            } else {
                result.setSuccess(false);
            }
        } else {
            activity = this.recommendActivityCrudService.findByReferralCode(code);
            if (activity != null && !code.equals(activity.getReferralCode())) {
                activity = null;
            }
        }
        if (activity != null && activity.isStatus() && appId.equals(activity.getGoodsCode()) && LocalDateTime.now().isBefore(activity.getEndDate()) && LocalDateTime.now().isAfter(activity.getBeginDate())) {
            CouponRuleVO coupon = this.couponRuleMapper.findCouponRuleInfo(activity.getCouponRuleSid());
            RecommendActivityVO activityVO = new RecommendActivityVO();
            ObjectCopyUtil.mergeDifferentTypeObject((Object)activity, (Object)activityVO);
            result.setActivity(activityVO);
            result.setCoupon(coupon);
            result.setReachLimit(false);
            MyCoupon myCoupon = (MyCoupon)this.myCouponCrudService.findByUnionKey(new Object[]{tenantSid, userSid, activity.getCouponRuleSid()});
            if (myCoupon != null && myCoupon.getUseStatus().equals((Object)UseStatus.USED)) {
                result.setCouponUsed(true);
                result.setSuccess(false);
            } else {
                if (coupon != null && Integer.parseInt(coupon.getCurrentNumber()) >= Integer.parseInt(coupon.getEndNumber())) {
                    result.setReachLimit(true);
                }
                result.setCouponUsed(false);
                result.setSuccess(true);
            }
        } else {
            result.setSuccess(false);
        }
        return result;
    }

    private void checkParameter(RecommendUserVO recommendUserVO) {
        StringBuilder stringBuilder = new StringBuilder();
        if (StringUtils.isEmpty((Object)recommendUserVO.getName())) {
            stringBuilder.append("recommendUserVO.name\u4e0d\u80fd\u4e3a\u7a7a,");
        }
        if (StringUtils.isEmpty((Object)recommendUserVO.getEmail())) {
            stringBuilder.append("recommendUserVO.email\u4e0d\u80fd\u4e3a\u7a7a,");
        }
        if (StringUtils.isEmpty((Object)recommendUserVO.getDepartCode())) {
            stringBuilder.append("recommendUserVO.departCode\u4e0d\u80fd\u4e3a\u7a7a,");
        }
        if (StringUtils.isEmpty((Object)recommendUserVO.getBusinessCode())) {
            stringBuilder.append("recommendUserVO.businessCode\u4e0d\u80fd\u4e3a\u7a7a,");
        }
        if (recommendUserVO.getRecommendActivitySid() == 0L) {
            stringBuilder.append("recommendUserVO.recommendActivitySid\u4e0d\u80fd\u4e3a0,");
        }
        if (!Strings.isBlank((String)stringBuilder.toString())) {
            throw new IllegalArgumentException(stringBuilder.toString());
        }
    }
}

