/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.service.release.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.digiwin.dap.middleware.dmc.model.ShareInfo;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.gmc.constant.enums.ReleaseDetailTypeEnum;
import com.digiwin.dap.middleware.gmc.domain.excel.ImportExcelResultVO;
import com.digiwin.dap.middleware.gmc.domain.excel.ReleaseDetailExcelVO;
import com.digiwin.dap.middleware.gmc.domain.excel.ReleaseHeadExcelVO;
import com.digiwin.dap.middleware.gmc.domain.release.ReleaseDescriptionAllVO;
import com.digiwin.dap.middleware.gmc.domain.release.ReleaseDescriptionDTO;
import com.digiwin.dap.middleware.gmc.domain.release.ReleaseDescriptionDetailVO;
import com.digiwin.dap.middleware.gmc.domain.release.ReleaseDescriptionRemoteInputVO;
import com.digiwin.dap.middleware.gmc.domain.release.ReleaseDescriptionRemoteLevel1VO;
import com.digiwin.dap.middleware.gmc.domain.release.ReleaseDescriptionRemoteLevel2VO;
import com.digiwin.dap.middleware.gmc.domain.release.ReleaseDescriptionRemoteLevel3VO;
import com.digiwin.dap.middleware.gmc.domain.release.ReleaseDescriptionVO;
import com.digiwin.dap.middleware.gmc.entity.Goods;
import com.digiwin.dap.middleware.gmc.entity.release.ReleaseDescription;
import com.digiwin.dap.middleware.gmc.entity.release.ReleaseDescriptionDetail;
import com.digiwin.dap.middleware.gmc.mapper.GoodsMapper;
import com.digiwin.dap.middleware.gmc.mapper.GoodsOnPlatformMapper;
import com.digiwin.dap.middleware.gmc.mapper.ReleaseDescriptionMapper;
import com.digiwin.dap.middleware.gmc.repository.GoodsOnPlatformRepository;
import com.digiwin.dap.middleware.gmc.repository.GoodsRepository;
import com.digiwin.dap.middleware.gmc.repository.MarketingConfigRepository;
import com.digiwin.dap.middleware.gmc.repository.ReleaseDescriptionDetailRepository;
import com.digiwin.dap.middleware.gmc.repository.ReleaseDescriptionRepository;
import com.digiwin.dap.middleware.gmc.service.release.ReleaseDescriptionService;
import com.digiwin.dap.middleware.gmc.support.ReleaseDescriptionHolder;
import com.digiwin.dap.middleware.gmc.support.remote.DmcService;
import com.digiwin.dap.middleware.util.EntityUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import com.github.pagehelper.PageSerializable;
import com.github.pagehelper.page.PageMethod;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ReleaseDescriptionServiceImpl
implements ReleaseDescriptionService {
    private static final Logger log = LoggerFactory.getLogger(ReleaseDescriptionServiceImpl.class);
    public static final int COLUMN_LENGTH = 2000;
    @Resource
    private ReleaseDescriptionRepository headRepository;
    @Resource
    private ReleaseDescriptionDetailRepository detailRepository;
    @Resource
    private ReleaseDescriptionMapper mapper;
    @Resource
    private DmcService dmcService;
    @Resource
    private GoodsRepository goodsRepository;
    @Resource
    private GoodsOnPlatformRepository goodsOnPlatformRepository;
    @Autowired
    private MarketingConfigRepository marketingConfigRepository;
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private GoodsOnPlatformMapper goodsOnPlatformMapper;

    @Transactional(rollbackFor={Exception.class})
    public ImportExcelResultVO importExcel(String fileId, String appId) {
        ReleaseDescriptionHolder holder = ReleaseDescriptionHolder.read((String)fileId);
        return this.getImportExcelResultVO(fileId, appId, holder);
    }

    public ImportExcelResultVO getImportExcelResultVO(String fileId, String appId, ReleaseDescriptionHolder holder) {
        holder.setOnWhichApp(appId);
        ImportExcelResultVO result = new ImportExcelResultVO();
        if (!this.checkContent(holder)) {
            result.setErrorCount(Integer.valueOf(1));
            ShareInfo shareInfo = this.dmcService.uploadExcel(holder.write());
            result.setErrorFileUri(shareInfo.getUrl());
            result.setErrorFileName(shareInfo.getFileName());
            return result;
        }
        ReleaseDescription headSaved = this.saveHead(fileId, holder);
        this.saveDetail(headSaved, ReleaseDetailTypeEnum.NEW, holder.getNewRequest());
        this.saveDetail(headSaved, ReleaseDetailTypeEnum.OPTIMISATION, holder.getOptimiseRequest());
        this.saveDetail(headSaved, ReleaseDetailTypeEnum.OVERALL, holder.getOverall());
        result.setSuccessCount(Integer.valueOf(1));
        return result;
    }

    private ReleaseDescription saveHead(String fileId, ReleaseDescriptionHolder holder) {
        ReleaseDescription releaseDescription = new ReleaseDescription(holder.getHead(), fileId);
        releaseDescription.setFileName(this.dmcService.getShareFileInfo(fileId).getFileName());
        return (ReleaseDescription)this.headRepository.save((Object)releaseDescription);
    }

    private boolean checkContent(ReleaseDescriptionHolder holder) {
        Optional exist;
        boolean noError = true;
        if (holder.getHead() == null) {
            ReleaseHeadExcelVO head = new ReleaseHeadExcelVO();
            holder.setHead(head);
            head.setError("\u4fe1\u606f\u672a\u4f20");
            return false;
        }
        ReleaseHeadExcelVO head = holder.getHead();
        if (!holder.getOnWhichApp().equals(head.getAppId())) {
            head.appendError("\u5546\u54c1ID\u4e0d\u7b26");
            noError = false;
        }
        if ((exist = this.headRepository.findByAppIdAndVersion(head.getAppId(), head.getVersion())).isPresent()) {
            head.appendError("\u7248\u672c\u8aaa\u660e\u5df2\u5b58\u5728\uff0c\u8acb\u4e0b\u67b6\u522a\u9664\u5f8c\u518d\u5c0e\u5165");
            noError = false;
        }
        noError = ReleaseDescriptionServiceImpl.checkDetail((List)holder.getOverall()) && noError;
        noError = ReleaseDescriptionServiceImpl.checkDetail((List)holder.getNewRequest()) && noError;
        noError = ReleaseDescriptionServiceImpl.checkDetail((List)holder.getOptimiseRequest()) && noError;
        return noError;
    }

    private static boolean checkDetail(List<ReleaseDetailExcelVO> details) {
        boolean noError = true;
        if (!CollectionUtils.isEmpty(details)) {
            for (ReleaseDetailExcelVO detail : details) {
                if (ObjectUtils.isEmpty((Object)detail.getDescription())) {
                    noError = ReleaseDescriptionServiceImpl.isNoError((ReleaseDetailExcelVO)detail, (String)"\u9700\u6c42\u8bf4\u660e\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.hasLength((String)detail.getDescription()) && detail.getDescription().length() > 2000) {
                    noError = ReleaseDescriptionServiceImpl.isNoError((ReleaseDetailExcelVO)detail, (String)"\u9700\u6c42\u8bf4\u660e\u957f\u5ea6\u8d85\u8fc72000");
                }
                if (StringUtils.hasLength((String)detail.getVideoUrl()) && detail.getVideoUrl().length() > 2000) {
                    noError = ReleaseDescriptionServiceImpl.isNoError((ReleaseDetailExcelVO)detail, (String)"\u89c6\u9891\u94fe\u63a5\u957f\u5ea6\u8d85\u8fc72000");
                }
                if (StringUtils.hasLength((String)detail.getImgUrl()) && detail.getImgUrl().length() > 2000) {
                    noError = ReleaseDescriptionServiceImpl.isNoError((ReleaseDetailExcelVO)detail, (String)"\u56fe\u7247\u94fe\u63a5\u957f\u5ea6\u8d85\u8fc72000");
                }
                if (!StringUtils.hasLength((String)detail.getAttachmentUrl()) || detail.getAttachmentUrl().length() <= 2000) continue;
                noError = ReleaseDescriptionServiceImpl.isNoError((ReleaseDetailExcelVO)detail, (String)"\u9644\u4ef6\u94fe\u63a5\u957f\u5ea6\u8d85\u8fc72000");
            }
        }
        return noError;
    }

    public static boolean isNoError(ReleaseDetailExcelVO detail, String content) {
        boolean noError = false;
        detail.appendError(content);
        return noError;
    }

    private void saveDetail(ReleaseDescription headSaved, ReleaseDetailTypeEnum typeEnum, List<ReleaseDetailExcelVO> requests) {
        List requestToSave = requests.stream().filter(a -> !a.isEmpty()).map(a -> {
            ReleaseDescriptionDetail request = new ReleaseDescriptionDetail(a);
            BeanUtils.copyProperties((Object)a, (Object)request);
            request.setType(Integer.valueOf(typeEnum.getType()));
            request.setReleaseSid(headSaved.getSid());
            return request;
        }).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(requestToSave)) {
            this.detailRepository.saveAll(requestToSave);
        }
    }

    public PageSerializable<ReleaseDescriptionVO> search(ReleaseDescriptionDTO body) {
        PageMethod.startPage((int)body.getPageNum(), (int)body.getPageSize(), (String)body.getOrderBy());
        List messages = this.mapper.queryHead(body);
        return new PageSerializable(messages);
    }

    @Transactional
    public void shelve(boolean status, long sid) {
        this.headRepository.findById((Object)sid).ifPresent(a -> {
            if (status) {
                a.setShelveTime(LocalDateTime.now());
            } else {
                a.setOffShelveTime(LocalDateTime.now());
            }
            a.setShelve(Boolean.valueOf(status));
            a.setModifyDate(LocalDateTime.now());
            a.setModifyBy(Long.valueOf(UserUtils.getUserSid()));
            a.setModifyById(UserUtils.getUserName());
        });
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(ReleaseDescriptionDTO input) {
        if (this.headRepository.existsById((Object)input.getSid())) {
            this.detailRepository.deleteByReleaseSid(input.getSid());
            this.headRepository.deleteById((Object)input.getSid());
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteDetail(ReleaseDescriptionDTO input) {
        if (this.detailRepository.existsById((Object)input.getSid())) {
            this.detailRepository.deleteById((Object)input.getSid());
        }
    }

    @Transactional
    public void modDetail(ReleaseDescriptionDetailVO input) {
        Optional optionalDetail = this.detailRepository.findById((Object)input.getSid());
        optionalDetail.ifPresent(detail -> {
            BeanUtil.copyProperties((Object)input, (Object)detail, (CopyOptions)CopyOptions.create(null, (boolean)true, (String[])new String[0]));
            EntityUtils.setModifyFields((BaseEntity)detail);
        });
    }

    public ReleaseDescriptionAllVO find(ReleaseDescriptionDTO input) {
        ReleaseDescriptionAllVO result = new ReleaseDescriptionAllVO();
        Optional byId = this.headRepository.findById((Object)input.getSid());
        byId.ifPresent(a -> result.setHead(a.toVO()));
        List detail = this.detailRepository.findByReleaseSid(input.getSid());
        result.setNewRequest(detail.stream().filter(a -> ReleaseDetailTypeEnum.NEW.getType() == a.getType().intValue()).map(ReleaseDescriptionDetail::toVO).collect(Collectors.toList()));
        result.setOptimiseRequest(detail.stream().filter(a -> ReleaseDetailTypeEnum.OPTIMISATION.getType() == a.getType().intValue()).map(ReleaseDescriptionDetail::toVO).collect(Collectors.toList()));
        result.setOverall(detail.stream().filter(a -> ReleaseDetailTypeEnum.OVERALL.getType() == a.getType().intValue()).map(ReleaseDescriptionDetail::toVO).collect(Collectors.toList()));
        return result;
    }

    public List<ReleaseDescriptionRemoteLevel1VO> remoteQuery(ReleaseDescriptionRemoteInputVO input) {
        this.lookupPlatformGoods(input);
        PageMethod.startPage((int)input.getPageNum(), (int)input.getPageSize(), (String)input.getOrderBy());
        List level1 = this.mapper.remoteQuery(input);
        if (CollectionUtils.isEmpty((Collection)level1)) {
            return level1;
        }
        this.findGoodsName(level1);
        this.getDetails(input, level1);
        return level1;
    }

    private void getDetails(ReleaseDescriptionRemoteInputVO input, List<ReleaseDescriptionRemoteLevel1VO> level1) {
        if (input.isElaborate()) {
            List sids = level1.stream().map(ReleaseDescriptionRemoteLevel1VO::getSid).collect(Collectors.toList());
            List allDetails = this.detailRepository.findByReleaseSidIn(sids);
            Map<Long, List<ReleaseDescriptionDetail>> byHead = allDetails.stream().collect(Collectors.groupingBy(ReleaseDescriptionDetail::getReleaseSid));
            for (ReleaseDescriptionRemoteLevel1VO head : level1) {
                List<ReleaseDescriptionDetail> details = byHead.get(head.getSid());
                if (CollectionUtils.isEmpty(details)) continue;
                head.setDetails(Arrays.asList(new ReleaseDescriptionRemoteLevel2VO("\u6982\u8981\u603b\u89c8", ReleaseDescriptionServiceImpl.assembleLevel3(details, (ReleaseDetailTypeEnum)ReleaseDetailTypeEnum.OVERALL)), new ReleaseDescriptionRemoteLevel2VO("\u65b0\u589e\u5185\u5bb9", ReleaseDescriptionServiceImpl.assembleLevel3(details, (ReleaseDetailTypeEnum)ReleaseDetailTypeEnum.NEW)), new ReleaseDescriptionRemoteLevel2VO("\u4f18\u5316\u5185\u5bb9", ReleaseDescriptionServiceImpl.assembleLevel3(details, (ReleaseDetailTypeEnum)ReleaseDetailTypeEnum.OPTIMISATION))));
            }
        }
    }

    private void findGoodsName(List<ReleaseDescriptionRemoteLevel1VO> level1) {
        List goods = this.goodsRepository.findByCodeIn(new ArrayList(level1.stream().map(ReleaseDescriptionRemoteLevel1VO::getCode).collect(Collectors.toSet())));
        HashMap goodMap = goods.stream().collect(HashMap::new, (m, v) -> m.put(v.getCode(), v), HashMap::putAll);
        level1.forEach(l -> {
            Goods good = (Goods)goodMap.get(l.getCode());
            l.setName(good.getDisplayName());
            if (Boolean.FALSE.equals(good.getPlatform())) {
                l.setTitle(l.getTitle().replace("\u5e73\u53f0\u7248\u672c", good.getDisplayName()));
            }
        });
    }

    private void lookupPlatformGoods(ReleaseDescriptionRemoteInputVO input) {
        String platform = input.getPlatform();
        if (!ObjectUtils.isEmpty((Object)platform)) {
            ArrayList<String> platformGoods = new ArrayList<String>();
            input.setCodes(platformGoods);
            if (!CollectionUtils.isEmpty((Collection)input.getCodes())) {
                platformGoods.addAll(input.getCodes());
            }
            platformGoods.add(platform);
            platformGoods.addAll(this.goodsOnPlatformMapper.getGoodsCodeByPlatformCode(platform));
        }
    }

    private static List<ReleaseDescriptionRemoteLevel3VO> assembleLevel3(List<ReleaseDescriptionDetail> details, ReleaseDetailTypeEnum typeEnum) {
        return details.stream().filter(a -> typeEnum.getType() == a.getType().intValue()).map(a -> {
            ReleaseDescriptionRemoteLevel3VO level3 = new ReleaseDescriptionRemoteLevel3VO();
            level3.setText(a.getDescription());
            level3.setVideoUrl(a.getVideoUrl());
            level3.setImgUrl(a.getImgUrl());
            level3.setAttachmentUrl(a.getAttachmentUrl());
            return level3;
        }).collect(Collectors.toList());
    }
}

