/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.service.tag.impl;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.gmc.domain.tag.TagCategoryVO;
import com.digiwin.dap.middleware.gmc.entity.tag.TagCategory;
import com.digiwin.dap.middleware.gmc.entity.tag.TagContent;
import com.digiwin.dap.middleware.gmc.mapper.TagMapper;
import com.digiwin.dap.middleware.gmc.repository.TagContentRepository;
import com.digiwin.dap.middleware.gmc.service.tag.TagCategoryCrudService;
import com.digiwin.dap.middleware.gmc.service.tag.TagContentCrudService;
import com.digiwin.dap.middleware.gmc.service.tag.TagService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.transaction.Transactional;
import org.springframework.stereotype.Service;

@Service
public class TagServiceImpl
implements TagService {
    @Resource
    private TagCategoryCrudService tagCategoryCrudService;
    @Resource
    private TagContentRepository tagContentRepository;
    @Resource
    private TagContentCrudService tagContentCrudService;
    @Resource
    private TagMapper tagMapper;

    @Transactional
    public void saveCategory(TagCategoryVO vo) {
        long categorySid;
        if (vo.getSid() == null) {
            TagCategory tagCategory = (TagCategory)vo.doForward();
            tagCategory.setDisabled(true);
            categorySid = this.tagCategoryCrudService.create((BaseEntity)tagCategory);
            List content = vo.getContent().stream().map(a -> new TagContent(categorySid, a)).collect(Collectors.toList());
            this.tagContentCrudService.saveAll(content);
        } else {
            TagCategory exist = (TagCategory)this.tagCategoryCrudService.findBySid(vo.getSid().longValue());
            categorySid = exist.getSid();
            exist.setName(vo.getName());
            exist.setPriority(vo.getPriority());
            exist.setRemark(vo.getRemark());
        }
        this.tagContentRepository.deleteByUpperSid(categorySid);
        List content = vo.getContent().stream().map(a -> new TagContent(categorySid, a)).collect(Collectors.toList());
        this.tagContentCrudService.saveAll(content);
    }

    @Transactional
    public void delCategory(TagCategoryVO vo) {
        TagCategory exist = (TagCategory)this.tagCategoryCrudService.findBySid(vo.getSid().longValue());
        if (exist != null) {
            this.tagContentRepository.deleteByUpperSid(exist.getSid());
            this.tagCategoryCrudService.deleteById(vo.getSid().longValue());
        }
    }

    public void shelveCategory(TagCategoryVO vo) {
        TagCategory exist = (TagCategory)this.tagCategoryCrudService.findBySid(vo.getSid().longValue());
        if (exist != null) {
            exist.setDisabled(vo.getDisabled().booleanValue());
            this.tagCategoryCrudService.update((BaseEntity)exist);
        }
    }

    public List<TagCategoryVO> findALlCategory(TagCategoryVO vo) {
        if (vo.getUpperSid() == null) {
            return new ArrayList<TagCategoryVO>();
        }
        return this.tagMapper.findTagCategory(vo);
    }
}

