/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.support.aspect;

import com.digiwin.dap.middleware.constant.GlobalConstants;
import com.digiwin.dap.middleware.gmc.domain.EnvProperties;
import com.digiwin.dap.middleware.gmc.support.aspect.FieldValue;
import com.digiwin.dap.middleware.util.UserUtils;
import com.github.pagehelper.util.ExecutorUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Resource;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class})})
public class DataPolicyInterceptor
implements Interceptor {
    private static final int PARAM_COUNT = 4;
    @Autowired
    EnvProperties envProperties;
    private static final String DATA_POLICY_QUERY = "com.digiwin.dap.middleware.gmc.mapper.GoodsMapper.findGoods";
    private static final String REFERRAL_CODE_DATA_POLICY_QUERY = "com.digiwin.dap.middleware.gmc.mapper.RecommendActivityMapper.getRecommendActivityResultVos";
    private static final String PACK_GOODS_DATA_POLICY_QUERY = "com.digiwin.dap.middleware.gmc.mapper.PackMapper.findPackGoodsVOSByCondition";
    private static final String SERVICER_GOODS_DATA_POLICY_QUERY = "com.digiwin.dap.middleware.gmc.mapper.GoodsMapper.findGoodsCondition";
    private static final String GOODS_COUNSEL_DATA_POLICY_QUERY = "com.digiwin.dap.middleware.gmc.mapper.GoodsCounselMapper.findGoodsCounsel";
    private static final String GOODS_CATEGORY_DATA_POLICY_QUERY = "com.digiwin.dap.middleware.gmc.mapper.ProductMapper.listPolicy";
    private static final List<String> FILTERS = new ArrayList();
    private static final List<String> OPERATOR;
    private static final Logger logger;
    @Autowired
    private RestTemplate restTemplate;
    @Resource(name="dapRetryRestTemplate")
    private RestTemplate restTemplate2;

    public void setProperties(Properties properties) {
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public Object intercept(Invocation invocation) throws Throwable {
        CacheKey cacheKey;
        BoundSql boundSql;
        Object[] args = invocation.getArgs();
        MappedStatement ms = (MappedStatement)args[0];
        Object parameter = args[1];
        RowBounds rowBounds = (RowBounds)args[2];
        ResultHandler resultHandler = (ResultHandler)args[3];
        Executor executor = (Executor)invocation.getTarget();
        if (args.length == 4) {
            boundSql = ms.getBoundSql(parameter);
            cacheKey = executor.createCacheKey(ms, parameter, rowBounds, boundSql);
        } else {
            cacheKey = (CacheKey)args[4];
            boundSql = (BoundSql)args[5];
        }
        String dataPolicySql = boundSql.getSql();
        if (FILTERS.contains(ms.getId())) {
            if (ms.getId().endsWith("com.digiwin.dap.middleware.gmc.mapper.GoodsMapper.findGoods") || ms.getId().endsWith("com.digiwin.dap.middleware.gmc.mapper.PackMapper.findPackGoodsVOSByCondition")) {
                dataPolicySql = this.getSql(dataPolicySql, 1);
            } else if (ms.getId().endsWith("com.digiwin.dap.middleware.gmc.mapper.RecommendActivityMapper.getRecommendActivityResultVos")) {
                dataPolicySql = this.getSql(dataPolicySql, 2);
            } else if (ms.getId().endsWith("com.digiwin.dap.middleware.gmc.mapper.GoodsMapper.findGoodsCondition")) {
                dataPolicySql = this.getSql(dataPolicySql, 3);
            } else if (ms.getId().endsWith("com.digiwin.dap.middleware.gmc.mapper.GoodsCounselMapper.findGoodsCounsel")) {
                dataPolicySql = this.getSql(dataPolicySql, 4);
            } else if (ms.getId().endsWith("com.digiwin.dap.middleware.gmc.mapper.ProductMapper.listPolicy")) {
                dataPolicySql = this.getSql(dataPolicySql, 5);
            }
        }
        BoundSql dataBoundSql = new BoundSql(ms.getConfiguration(), dataPolicySql, boundSql.getParameterMappings(), parameter);
        Map additionalParameters = ExecutorUtil.getAdditionalParameter((BoundSql)boundSql);
        for (String key : additionalParameters.keySet()) {
            dataBoundSql.setAdditionalParameter(key, additionalParameters.get(key));
        }
        return executor.query(ms, parameter, rowBounds, resultHandler, cacheKey, dataBoundSql);
    }

    private String getSql(String sql, int type) {
        Map map = this.getRowPermission(UserUtils.getToken(), type);
        if (null == map) {
            return 5 == type ? sql + " and pr.sid = 0 " : sql + " and g.sid = 0";
        }
        boolean superadmin = Boolean.valueOf(map.get("superadmin").toString());
        if (superadmin) {
            return sql;
        }
        Map rowMap = (Map)map.get("rowPermission");
        if (rowMap.isEmpty()) {
            return 5 == type ? sql + " and pr.sid = 0 " : sql + " and g.sid = 0";
        }
        String temp = DataPolicyInterceptor.getSql((Object)rowMap, null);
        if (1 == type || 4 == type) {
            temp = temp.replace("goodsCode", "g.code").replace("categoryId", "g.categoryid").replace("productCode", "g.productcode");
        } else if (2 == type) {
            temp = temp.replace("goodsCode", "g.goods_code").replace("categoryId", "g.goods_category").replace("productCode", "(select d.productcode from goods d where d.code = g.goods_code)");
        } else if (5 == type) {
            temp = this.getSql4Product((Object)rowMap, null);
            temp = temp.replace("productCode", "pr.productcode");
        }
        if (StringUtils.hasLength((String)temp)) {
            return String.format("%s and %s", sql, temp);
        }
        return sql;
    }

    private String getSql4Product(Object object, String operator) {
        if (null == object) {
            return "";
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            if (0 == map.size()) {
                return "";
            }
            FieldValue fieldValue = new FieldValue(map);
            if (OPERATOR.contains(fieldValue.getFilterType())) {
                return this.getSql4Product(fieldValue.getFilterValue(), fieldValue.getFilterType());
            }
            if ("productCode".equals(fieldValue.getFilterField())) {
                return fieldValue.getWhere();
            }
            return "";
        }
        if (object instanceof List) {
            StringBuilder stringBuilder = new StringBuilder();
            List list = (List)object;
            for (Object o : list) {
                String result = this.getSql4Product(o, null);
                if (!StringUtils.hasLength((String)result)) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(" ").append(operator).append(" ");
                }
                stringBuilder.append(result);
            }
            String string = stringBuilder.toString();
            if (StringUtils.hasLength((String)string)) {
                stringBuilder.append(")");
                return "(" + stringBuilder.toString();
            }
            return string;
        }
        return "";
    }

    private static String getSql(Object object, String operator) {
        if (null == object) {
            return "";
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            if (0 == map.size()) {
                return "";
            }
            FieldValue fieldValue = new FieldValue(map);
            if (OPERATOR.contains(fieldValue.getFilterType())) {
                return DataPolicyInterceptor.getSql((Object)fieldValue.getFilterValue(), (String)fieldValue.getFilterType());
            }
            return fieldValue.getWhere();
        }
        if (object instanceof List) {
            List list = (List)object;
            ArrayList<String> values = new ArrayList<String>();
            for (Object o : list) {
                String temp = DataPolicyInterceptor.getSql(o, null);
                if ("".equals(temp)) continue;
                values.add(temp);
            }
            int size = values.size();
            if (size == 1) {
                return (String)values.get(0);
            }
            if (size > 1) {
                String temp = String.join((CharSequence)String.format(" %s ", operator), values);
                return String.format("(%s)", temp);
            }
        }
        return "";
    }

    private Map getRowPermission(String userToken, int type) {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, userToken);
            HashMap<String, String> requestContent = new HashMap<String, String>(3);
            if (3 == type) {
                requestContent.put("sysId", "isv");
                requestContent.put("moduleId", "isv-platform");
                requestContent.put("actionId", "isv-goods");
            } else if (4 == type) {
                requestContent.put("sysId", "boss");
                requestContent.put("moduleId", "boss-customer");
                requestContent.put("actionId", "boss-consultation-management");
            } else {
                requestContent.put("sysId", "boss");
                requestContent.put("moduleId", "boss-goods");
                requestContent.put("actionId", "boss-goods-management");
            }
            HttpEntity request = new HttpEntity(requestContent, (MultiValueMap)headers);
            String url = this.envProperties.getIamUri() + "/api/iam/v2/permission/data/row";
            ResponseEntity responseEntity = this.restTemplate2.postForEntity(url, (Object)request, Map.class, new Object[0]);
            return (Map)responseEntity.getBody();
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6570\u636e\u6743\u9650\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    static {
        FILTERS.add("com.digiwin.dap.middleware.gmc.mapper.GoodsMapper.findAuthorizationGoods");
        FILTERS.add("com.digiwin.dap.middleware.gmc.mapper.GoodsMapper.findGoods");
        FILTERS.add("com.digiwin.dap.middleware.gmc.mapper.RecommendActivityMapper.getRecommendActivityResultVos");
        FILTERS.add("com.digiwin.dap.middleware.gmc.mapper.PackMapper.findPackGoodsVOSByCondition");
        FILTERS.add("com.digiwin.dap.middleware.gmc.mapper.GoodsMapper.findGoodsCondition");
        FILTERS.add("com.digiwin.dap.middleware.gmc.mapper.GoodsCounselMapper.findGoodsCounsel");
        FILTERS.add("com.digiwin.dap.middleware.gmc.mapper.ProductMapper.listPolicy");
        OPERATOR = new ArrayList();
        OPERATOR.add("and");
        OPERATOR.add("or");
        logger = LoggerFactory.getLogger(DataPolicyInterceptor.class);
    }
}

