/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.support.aspect;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.util.EntityUtils;
import com.digiwin.dap.middleware.util.SnowFlake;
import java.util.List;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Aspect
@Component
@Transactional(readOnly=true, rollbackFor={Exception.class})
public class EntityRepositioryAspect {
    @Pointcut(value="execution(public !void org.springframework.data.repository.Repository+.save(..))")
    public void save() {
    }

    @Pointcut(value="execution(public !void org.springframework.data.repository.Repository+.saveAll(..))")
    public void saveAll() {
    }

    @Around(value="save()")
    public Object addManagerEntityPropertiesValue(ProceedingJoinPoint pjp) throws Throwable {
        Object[] args;
        for (Object arg : args = pjp.getArgs()) {
            if (!(arg instanceof BaseEntity)) continue;
            BaseEntity entity = (BaseEntity)arg;
            if (entity.getSid() == 0L) {
                EntityUtils.setCreateFields((BaseEntity)entity);
                entity.setSid(SnowFlake.getInstance().newId());
            }
            EntityUtils.setModifyFields((BaseEntity)entity);
        }
        return pjp.proceed();
    }

    @Around(value="saveAll()")
    public Object addManagerEntityPropertiesValueForAll(ProceedingJoinPoint pjp) throws Throwable {
        Object[] args;
        for (Object arg : args = pjp.getArgs()) {
            if (!(arg instanceof List)) continue;
            for (Object o : (List)arg) {
                if (!(o instanceof BaseEntity)) continue;
                BaseEntity entity = (BaseEntity)o;
                if (entity.getSid() == 0L) {
                    EntityUtils.setCreateFields((BaseEntity)entity);
                    entity.setSid(SnowFlake.getInstance().newId());
                }
                EntityUtils.setModifyFields((BaseEntity)entity);
            }
        }
        return pjp.proceed();
    }
}

