/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.support.helper;

import com.digiwin.dap.middle.cache.lock.CacheLock;
import com.digiwin.dap.middle.cache.lock.CacheParam;
import com.digiwin.dap.middleware.cache.RedisUtils;
import com.digiwin.dap.middleware.gmc.util.SpringBeanUtils;
import com.digiwin.dap.middleware.util.JsonUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class CacheHelper {
    private static final Integer WAIT_CACHE_SPIN_COUNT = 1000;
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheHelper.class);
    private Map<String, HashSet<String>> localCacheKeys = new ConcurrentHashMap();

    @CacheLock
    public Object cacheBlock(Supplier supplier, @CacheParam String cacheKey) {
        return supplier.get();
    }

    public Object antiBreakDown4cache(Supplier supplier, String cacheKey, long timeout, TimeUnit unit) {
        return this.antiBreakDown4caches(supplier, cacheKey, cacheKey, timeout, unit);
    }

    public Object antiBreakDown4caches(Supplier supplier, String cacheKey, String cacheKeyList, long timeout, TimeUnit unit) {
        Object ret;
        block4: {
            ret = null;
            try {
                ret = ((CacheHelper)SpringBeanUtils.getBean(CacheHelper.class)).cacheBlock(() -> this.lambda$antiBreakDown4caches$0((Supplier)supplier, cacheKey, timeout, unit, cacheKeyList), cacheKey);
            }
            catch (Exception e) {
                if (ret != null) break block4;
                for (int i = 0; i < WAIT_CACHE_SPIN_COUNT; ++i) {
                    if (Boolean.TRUE.equals(RedisUtils.getRedisTemplate().hasKey((Object)cacheKey))) {
                        ret = RedisUtils.opsForValue().get((Object)cacheKey);
                        LOGGER.info("\u7f13\u5b58\u5524\u9192==" + Thread.currentThread().getId() + "==" + i);
                        break;
                    }
                    LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(1L));
                }
                if (ret != null) break block4;
                LOGGER.info("\u7f13\u5b58\u8d85\u65f6==" + Thread.currentThread().getId());
                ret = supplier.get();
            }
        }
        return ret;
    }

    private synchronized void localRecord(String cacheKey, String cacheKeyList) {
        HashSet set = (HashSet)this.localCacheKeys.get(cacheKeyList);
        if (set != null) {
            set.add(cacheKey);
        } else {
            HashSet<String> objects = new HashSet<String>();
            objects.add(cacheKey);
            this.localCacheKeys.put(cacheKeyList, objects);
        }
    }

    public void delCorrespondingCaches(String cacheListAll) {
        try {
            Set members = RedisUtils.opsForSet().members((Object)cacheListAll);
            Set membersLocal = (Set)this.localCacheKeys.get(cacheListAll);
            if (!CollectionUtils.isEmpty((Collection)membersLocal)) {
                members.addAll(membersLocal);
            }
            if (!CollectionUtils.isEmpty((Collection)members)) {
                RedisUtils.opsForSet().remove((Object)cacheListAll, members.toArray());
                RedisUtils.delete((Collection)members);
                this.localCacheKeys.remove(cacheListAll);
            }
        }
        catch (Exception e) {
            LOGGER.warn("\u3010redis\u5220\u9664\u7f13\u5b58\u3011", (Throwable)e);
        }
    }

    private /* synthetic */ Object lambda$antiBreakDown4caches$0(Supplier supplier, String cacheKey, long timeout, TimeUnit unit, String cacheKeyList) {
        Object o = supplier.get();
        try {
            RedisUtils.opsForValue().set((Object)cacheKey, (Object)JsonUtils.writeValue(o), timeout, unit);
        }
        catch (Exception e) {
            LOGGER.warn("\u3010redis\u8bbe\u7f6e\u7f13\u5b58\u3011", (Throwable)e);
            return o;
        }
        try {
            RedisUtils.opsForSet().add((Object)cacheKeyList, new Object[]{cacheKey});
        }
        catch (Exception e) {
            LOGGER.warn("\u3010redis\u8bbe\u7f6e\u7f13\u5b58key\u96c6\u5408\u3011", (Throwable)e);
            this.localRecord(cacheKey, cacheKeyList);
        }
        return o;
    }
}

