/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.support.remote.impl;

import com.digiwin.dap.middleware.constant.GlobalConstants;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.gmc.constant.I18nError;
import com.digiwin.dap.middleware.gmc.domain.EnvProperties;
import com.digiwin.dap.middleware.gmc.domain.remote.AuthorizationVO;
import com.digiwin.dap.middleware.gmc.domain.remote.GoodsExpiredDTO;
import com.digiwin.dap.middleware.gmc.domain.remote.PurchaseDetailVO;
import com.digiwin.dap.middleware.gmc.entity.UnitConversion;
import com.digiwin.dap.middleware.gmc.support.remote.CacService;
import com.digiwin.dap.middleware.util.ExceptionUtils;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import com.github.pagehelper.PageSerializable;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class CacServiceImpl
implements CacService {
    private static final Logger logger = LoggerFactory.getLogger(CacServiceImpl.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private RestTemplate restTemplate;
    @Resource(name="dapRetryRestTemplate")
    private RestTemplate restTemplate2;

    public AuthorizationVO getExpiredDateTime(String tenantId, String goodsCode) {
        String url = this.envProperties.getCacUrl() + String.format("/api/cac/v4/authorizations/tenants/%s/goods/%s", tenantId, goodsCode);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        AuthorizationVO authorizationVO = (AuthorizationVO)this.restTemplate.getForObject(url, AuthorizationVO.class, new Object[0]);
        return authorizationVO;
    }

    public List<PurchaseDetailVO> getPurchaseDetailVOs(String beginTime, String endTime) {
        String url = this.envProperties.getCacUrl() + "/api/cac/v4/authorizations/willexpired/apps";
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        HashMap<String, String> requestContent = new HashMap<String, String>();
        requestContent.put("beginTime", beginTime);
        requestContent.put("endTime", endTime);
        HttpEntity request = new HttpEntity(requestContent, (MultiValueMap)headers);
        if (null != this.restTemplate.postForObject(url, (Object)request, PurchaseDetailVO[].class, new Object[0])) {
            return Arrays.asList((Object[])Objects.requireNonNull(this.restTemplate2.postForObject(url, (Object)request, PurchaseDetailVO[].class, new Object[0])));
        }
        return null;
    }

    public List<PurchaseDetailVO> getPurchaseDetailVOs(List<String> productTypes, String beginTime, String endTime) {
        String url = this.envProperties.getCacUrl() + "/api/cac/v4/authorizations/willexpired";
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        HashMap<String, Object> requestContent = new HashMap<String, Object>();
        requestContent.put("productTypes", productTypes);
        requestContent.put("beginTime", beginTime);
        requestContent.put("endTime", endTime);
        HttpEntity request = new HttpEntity(requestContent, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate2.exchange(url, HttpMethod.POST, request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
        return (List)response.getBody();
    }

    public PageSerializable<PurchaseDetailVO> getWillExpiredGoods(Integer pageNum, Integer pageSize, GoodsExpiredDTO dto) {
        HashMap<String, Object> mapParams = new HashMap<String, Object>();
        mapParams.put("tenantId", dto.getTenantId());
        mapParams.put("goodsCodes", dto.getGoodsCode());
        mapParams.put("showUserCount", dto.getShowUserCount());
        mapParams.put("productCodeGoodsCodes", dto.getProductCodeGoodsCodes());
        mapParams.put("bufferPeriod", dto.getBufferPeriod());
        mapParams.put("test", dto.getTestTenant());
        if (Integer.valueOf(1).equals(dto.getState())) {
            if (dto.getDay() != null) {
                mapParams.put("beginTime", LocalDateTime.now().minusDays(Long.valueOf(dto.getDay().intValue()) + 1L).with(LocalTime.MAX));
            }
            mapParams.put("endTime", LocalDateTime.now());
        } else if (Integer.valueOf(2).equals(dto.getState())) {
            if (dto.getDay() != null) {
                mapParams.put("endTime", LocalDateTime.now().plusDays(dto.getDay().intValue()).with(LocalTime.MAX));
            }
            mapParams.put("beginTime", LocalDateTime.now());
        }
        String url = this.envProperties.getCacUrl() + "/api/cac/v4/authorizations/willexpired/apps/query/new" + "?pageNum=%s&pageSize=%s";
        url = String.format(url, pageNum, pageSize);
        HttpHeaders headers = new HttpHeaders();
        HttpEntity entity = new HttpEntity(mapParams, (MultiValueMap)headers);
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
        ResponseEntity response = this.restTemplate2.exchange(url, HttpMethod.POST, entity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
        return (PageSerializable)Optional.ofNullable(response.getBody()).orElse(new PageSerializable());
    }

    @Async
    public void updateCustomUnit(String goodsCode, String customUnit) {
        String url = this.envProperties.getCacUrl() + "/api/cac/v4/counting/update/customunit";
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        HashMap<String, String> requestContent = new HashMap<String, String>();
        requestContent.put("goodsCode", goodsCode);
        requestContent.put("customUnit", customUnit);
        try {
            HttpEntity request = new HttpEntity(requestContent, (MultiValueMap)headers);
            this.restTemplate.postForObject(url, (Object)request, Map.class, new Object[0]);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u81ea\u5b9a\u4e49\u5355\u4f4d\u5f02\u5e38" + e.getMessage());
        }
    }

    public void batchUpdateModule(String appId, List modules) {
        String url = this.envProperties.getCacUrl() + "/api/cac/v4/authorizations/batchupdate";
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        HashMap<String, Object> requestContent = new HashMap<String, Object>();
        requestContent.put("allChecked", true);
        requestContent.put("appId", appId);
        requestContent.put("emailSend", false);
        requestContent.put("paymentType", 1);
        requestContent.put("modules", modules);
        HttpEntity request = new HttpEntity(requestContent, (MultiValueMap)headers);
        try {
            this.restTemplate.postForObject(url, (Object)request, Map.class, new Object[0]);
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528cac\u6279\u91cf\u66f4\u65b0\u6a21\u5757\u6743\u9650\u5f02\u5e38, e : {}", (Object)e.getMessage());
        }
    }

    public void removeGoods(String goodsCode) {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
            HashMap<String, String> body = new HashMap<String, String>();
            body.put("goodsCode", goodsCode);
            HttpEntity requestBody = new HttpEntity(body, (MultiValueMap)headers);
            String url = this.envProperties.getCacUrl() + "/api/cac/v4/authorizations/remove/goods";
            StdData stdData = (StdData)this.restTemplate.postForObject(url, (Object)requestBody, StdData.class, new Object[0]);
        }
        catch (Exception e) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, String.format("\u5220\u9664\u5546\u54c1[%s]\u6388\u6743\u5931\u8d25", goodsCode));
        }
    }

    public AuthorizationVO getAuthorizationVoByTenantIdAndGoodCode(String tenantId, String appId) {
        String uri = this.envProperties.getCacUrl() + String.format("/api/cac/v4/authorizations/tenants/%s/goods/%s", tenantId, appId);
        try {
            return (AuthorizationVO)this.restTemplate.getForObject(uri, AuthorizationVO.class, new Object[0]);
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.logError((String)String.format("\u83b7\u53d6\u79df\u6236%s\u5e94\u7528%s\u6388\u6743\u5f02\u5e38", tenantId, appId), (String)uri, null, (Exception)e), (Throwable)e);
            return null;
        }
    }

    public void addAuthorization(String tenantId, String appId, String userId) {
        Assert.hasText((String)tenantId, (String)"tenantId is null");
        Assert.hasText((String)appId, (String)"appId is null");
        Assert.hasText((String)appId, (String)"userId is null");
        logger.info("[{}]\u7ed9\u79df\u6237[{}]\u4e0b\u7528\u6237[{}]\u6dfb\u52a0\u5e94\u7528[{}]\u7684\u6388\u6743", new Object[]{LocalDateTime.now(), tenantId, userId, appId});
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put("countingId", appId);
        paramsMap.put("tenantId", tenantId);
        paramsMap.put("userId", userId);
        HttpEntity requestEntity = new HttpEntity(paramsMap, (MultiValueMap)headers);
        String url = this.envProperties.getCacUrl() + "/api/cac/v4/counting/user/add";
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            Boolean result = Optional.ofNullable(responseEntity.getBody()).map(x -> (Boolean)x.get("isSuccess")).orElse(Boolean.FALSE);
            if (Boolean.FALSE.equals(result)) {
                throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, "\u7528\u6237" + userId + "\u6388\u6743\u5e94\u7528" + appId + "\u5931\u8d25");
            }
        }
        catch (Exception e) {
            logger.error("\u3010\u8c03\u7528cac\u3011\u6dfb\u52a0\u7528\u6237\u7684\u5e94\u7528\u6388\u6743\u5931\u8d25", (Throwable)e);
        }
    }

    public List<PurchaseDetailVO> getGoodsAuthTenant(String goodsCode) {
        String uri = this.envProperties.getCacUrl() + String.format("/api/cac/v4/authorizations/tenants/goods/%s", goodsCode);
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
            HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.GET, requestEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            return Optional.ofNullable(responseEntity.getBody()).orElse(Collections.emptyList());
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.logError((String)String.format("\u83b7\u53d6\u5e94\u7528%s\u6388\u6743\u79df\u6237\u5f02\u5e38", goodsCode), (String)uri, null, (Exception)e), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public void saveGoodsResource(Object data) {
        String uri = this.envProperties.getCacUrl() + "/api/cac/v4/resource/save";
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
            HttpEntity requestEntity = new HttpEntity(data, (MultiValueMap)headers);
            this.restTemplate.postForObject(uri, (Object)requestEntity, String.class, new Object[0]);
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.logError((String)"\u540c\u6b65\u8ba1\u91cf\u5546\u54c1\u5173\u7cfb", (String)uri, (Object)JsonUtils.writeValue((Object)data), (Exception)e), (Throwable)e);
        }
    }

    public void mergeUnitConversion(UnitConversion unitConversion) {
        String uri = this.envProperties.getCacUrl() + "/api/cac/v4/unit/conversion/merge";
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
            HttpEntity requestEntity = new HttpEntity((Object)unitConversion, (MultiValueMap)headers);
            this.restTemplate.postForObject(uri, (Object)requestEntity, String.class, new Object[0]);
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.logError((String)"\u540c\u6b65\u5355\u4f4d\u6362\u7b97\u914d\u7f6e\u5931\u8d25", (String)uri, (Object)JsonUtils.writeValue((Object)unitConversion), (Exception)e), (Throwable)e);
        }
    }

    public void deleteUnitConversion(String id, String goodsCode) {
        HttpHeaders headers = new HttpHeaders();
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        String url = this.envProperties.getCacUrl() + "/api/cac/v4/unit/conversion/del?id={id}&goodsCode={goodsCode}";
        try {
            this.restTemplate.exchange(url, HttpMethod.GET, request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[]{id, goodsCode});
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
    }
}

