/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.support.remote.impl;

import com.digiwin.dap.middleware.dmc.DMC;
import com.digiwin.dap.middleware.dmc.model.ShareInfo;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.gmc.constant.I18nError;
import com.digiwin.dap.middleware.gmc.domain.remote.ShareFileUrlVO;
import com.digiwin.dap.middleware.gmc.support.remote.DmcService;
import com.digiwin.dap.middleware.util.ObjectCopyUtil;
import com.digiwin.dmc.sdk.entity.FileInfo;
import com.digiwin.dmc.sdk.service.IShareFileService;
import com.digiwin.dmc.sdk.service.impl.ShareFileService;
import com.digiwin.dmc.sdk.service.upload.IShareUploader;
import com.digiwin.dmc.sdk.service.upload.UploadProgressEventArgs;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class DmcServiceImpl
implements DmcService {
    private static final Logger logger = LoggerFactory.getLogger(DmcServiceImpl.class);
    private static IShareFileService shareFileService = ShareFileService.shareFileInstance();
    @Autowired
    @Qualifier(value="dmcClientCloud")
    private DMC dmcClient;

    public ShareFileUrlVO getShareUrl(String name, byte[] image) {
        FileInfo fileInfo = new FileInfo();
        fileInfo.setFileName(name + ".jpg");
        fileInfo.setDisplayName(name);
        fileInfo.setExtension("jpg");
        fileInfo.setTenantId("99990000");
        ShareFileUrlVO shareFileUrlVO = new ShareFileUrlVO();
        try {
            CountDownLatch latch = new CountDownLatch(1);
            UploadProgressEventArgs uploadProgressEventArgs = new UploadProgressEventArgs();
            IShareUploader shareUploader = shareFileService.uploadDocument(image, fileInfo);
            shareUploader.upload().onCompleted(eventArgs -> {
                if (eventArgs.getPercentage() == 1.0) {
                    uploadProgressEventArgs.setPercentage(1.0);
                    shareFileUrlVO.setFileId(eventArgs.getFileId());
                    shareFileUrlVO.setUrl(eventArgs.getUrl());
                    System.out.println("\u6587\u4ef6\u4e0a\u4f20\u5b8c\u6210\uff0cId\u4e3a\uff1a" + eventArgs.getFileId());
                    System.out.println("\u5206\u4eaburl\uff0curl\u4e3a\uff1a" + eventArgs.getUrl());
                    latch.countDown();
                }
            });
            latch.await();
        }
        catch (Exception e) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, "\u751f\u6210\u4e8c\u7ef4\u7801\u5931\u8d25:" + e);
        }
        return shareFileUrlVO;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ShareInfo uploadExcel(File file) {
        try (InputStream input = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            byte[] bytes = new byte[input.available()];
            int read = input.read(bytes);
            if (read <= 0) {
                logger.error("nothing to read");
            }
            FileInfo fileInfo = new FileInfo();
            fileInfo.setFileName(file.getName());
            fileInfo.setExtension("xlsx");
            ShareInfo shareInfo = this.getShareFile(bytes, fileInfo);
            return shareInfo;
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
    }

    public ShareInfo getShareFile(byte[] bytes, FileInfo fileInfo) throws Exception {
        if (StringUtils.isEmpty((Object)fileInfo.getTenantId())) {
            fileInfo.setTenantId("99990000");
        }
        com.digiwin.dap.middleware.dmc.model.FileInfo fileInfo1 = new com.digiwin.dap.middleware.dmc.model.FileInfo();
        ObjectCopyUtil.mergeDifferentTypeObject((Object)fileInfo, (Object)fileInfo1);
        com.digiwin.dap.middleware.dmc.model.FileInfo upload = this.dmcClient.upload(bytes, fileInfo1);
        return this.dmcClient.share(upload.getId());
    }

    public ShareInfo getShareFileInfo(String fileId) {
        try {
            return this.dmcClient.share(fileId);
        }
        catch (Exception e) {
            logger.error("get share file error", (Throwable)e);
            return new ShareInfo();
        }
    }
}

