/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.support.remote.impl;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.constant.GlobalConstants;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.gmc.constant.I18nError;
import com.digiwin.dap.middleware.gmc.domain.CommonVO;
import com.digiwin.dap.middleware.gmc.domain.EnvProperties;
import com.digiwin.dap.middleware.gmc.domain.goods.Goods2CloudMapping;
import com.digiwin.dap.middleware.gmc.domain.goods.GoodsAndLanguageVO;
import com.digiwin.dap.middleware.gmc.domain.goods.GoodsVO;
import com.digiwin.dap.middleware.gmc.domain.remote.DevSys;
import com.digiwin.dap.middleware.gmc.domain.remote.SysFullInfoVO;
import com.digiwin.dap.middleware.gmc.domain.remote.SysNoticeVO;
import com.digiwin.dap.middleware.gmc.domain.remote.UserAndTenantSimpleInfo;
import com.digiwin.dap.middleware.gmc.domain.remote.UserVO;
import com.digiwin.dap.middleware.gmc.entity.CommonParam;
import com.digiwin.dap.middleware.gmc.entity.MultiLanguageResource;
import com.digiwin.dap.middleware.gmc.mapper.GoodsOnPlatformMapper;
import com.digiwin.dap.middleware.gmc.support.remote.IamService;
import com.digiwin.dap.middleware.support.DapHttpService;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.pagehelper.PageSerializable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class IamServiceImpl
implements IamService {
    private static final Logger logger = LoggerFactory.getLogger(IamServiceImpl.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private RestTemplate restTemplate;
    @Resource(name="dapRetryRestTemplate")
    private RestTemplate retryRestTemplate;
    @Autowired
    private DapHttpService dapHttpService;
    @Autowired
    private GoodsOnPlatformMapper goodsOnPlatformMapper;

    public void addDefaultApp(GoodsAndLanguageVO goodsAndLanguageVO) {
        ArrayList languageResources = new ArrayList();
        goodsAndLanguageVO.getMultiLanguageResource().stream().forEach(o -> o.getData().stream().forEach(m -> {
            if ("modules".equals(m.getFieldName())) {
                MultiLanguageResource multiLanguageResource = new MultiLanguageResource();
                multiLanguageResource.setDataSid(o.getDataSid().longValue());
                multiLanguageResource.setFieldName(m.getFieldName());
                multiLanguageResource.setContent(m.getContent());
                multiLanguageResource.setLanguage(o.getLanguage());
                languageResources.add(multiLanguageResource);
            }
        }));
        GoodsVO goodsVO = new GoodsVO();
        goodsVO.setModules((Object)goodsAndLanguageVO.getModules());
        this.addDefaultApp(goodsVO, languageResources, null);
    }

    public void addDefaultApp(GoodsVO goodsVO, List<MultiLanguageResource> languageResources, String sourceIamUri) {
        try {
            ObjectMapper objectMapper = JsonUtils.createObjectMapper();
            String iamUri = this.envProperties.getIamUri();
            String url = iamUri + "/api/iam/v2/app/default/update/withlanguage";
            HttpHeaders headers = new HttpHeaders();
            headers.add("Content-Type", "application/json");
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, StringUtils.hasText((String)UserUtils.getToken()) ? UserUtils.getToken() : this.dapHttpService.getUserToken(this.envProperties.getManagerTenant()));
            HashMap<String, Object> requestBody = new HashMap<String, Object>();
            requestBody.put("sysCascadeVO", goodsVO.getModules());
            ArrayList languageResourceList = new ArrayList();
            languageResources.forEach(multiLanguageResource -> {
                HashMap<String, Object> languageResource = new HashMap<String, Object>();
                languageResource.put("language", multiLanguageResource.getLanguage());
                if (StringUtils.isEmpty((Object)multiLanguageResource.getContent())) {
                    return;
                }
                try {
                    languageResource.put("sysCascadeVO", objectMapper.readValue(multiLanguageResource.getContent(), Object.class));
                }
                catch (IOException e) {
                    throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, "IAM\u6dfb\u52a0\u9884\u8bbe\u5e94\u7528\u5f02\u5e38:" + e.getMessage());
                }
                languageResourceList.add(languageResource);
            });
            requestBody.put("multiLanguageSysDetailVOS", languageResourceList);
            HttpEntity request = new HttpEntity((Object)objectMapper.writeValueAsString(requestBody), (MultiValueMap)headers);
            this.restTemplate.postForObject(url, (Object)request, HashMap.class, new Object[0]);
        }
        catch (Exception ex) {
            logger.error(" IAM\u6dfb\u52a0\u9884\u8bbe\u5e94\u7528\u5f02\u5e38", (Throwable)ex);
            throw new BusinessException((ErrorHandler)I18nError.OMC_REMOTE_IAM_ADD_DEFAULT_APP_ERROR, ex.getMessage());
        }
    }

    public void updateBackUri(GoodsVO goodsVO) {
        try {
            String url = this.envProperties.getIamUri() + "/api/iam/v2/sys/platform/backuri";
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, StringUtils.hasText((String)UserUtils.getToken()) ? UserUtils.getToken() : this.dapHttpService.getUserToken(this.envProperties.getManagerTenant()));
            HashMap<String, Object> requestContent = new HashMap<String, Object>();
            requestContent.put("id", goodsVO.getCode());
            requestContent.put("backUri", goodsVO.getBackUri());
            requestContent.put("platform", goodsVO.getPlatform());
            requestContent.put("productCode", goodsVO.getProductCode());
            requestContent.put("productName", goodsVO.getProductName());
            requestContent.put("showEntry", goodsVO.getShowEntry());
            requestContent.put("showConsolePolicy", goodsVO.getShowConsolePolicy());
            requestContent.put("linked", goodsVO.getLinked());
            requestContent.put("actionFilterUrl", goodsVO.getActionFilterUrl());
            requestContent.put("enableFunctionControl", goodsVO.getEnableFunctionControl());
            List goodsOnPlatformVOS = this.goodsOnPlatformMapper.getPlatformCodeByGoodsCode(goodsVO.getCode());
            requestContent.put("platformVOS", goodsOnPlatformVOS);
            HttpEntity request = new HttpEntity(requestContent, (MultiValueMap)headers);
            this.restTemplate.postForObject(url, (Object)request, String.class, new Object[0]);
        }
        catch (Exception ex) {
            throw new RuntimeException("IAM\u8bbe\u7f6e\u5e94\u7528\u56de\u8c03\u5730\u5740\u5f02\u5e38:" + ex.getMessage());
        }
    }

    public void updateCloudMappings(List<Goods2CloudMapping> mappings) {
        String url = this.envProperties.getIamUri() + "/api/iam/v2/oauth2/sync";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        String userToken = UserUtils.getToken() != null ? UserUtils.getToken() : this.dapHttpService.getUserToken(this.envProperties.getManagerTenant());
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, userToken);
        ArrayList requestList = new ArrayList(mappings.size());
        mappings.forEach(m -> {
            HashMap<String, Object> requestContent = new HashMap<String, Object>();
            requestContent.put("sysId", m.getGoodsCode());
            requestContent.put("platform", m.getPlatform());
            requestContent.put("name", m.getGoodsName());
            m.getDatas().forEach(d -> {
                if ("clientKey".equals(d.getKey())) {
                    requestContent.put("id", d.getValue());
                }
                if ("clientSecret".equals(d.getKey())) {
                    requestContent.put("secret", d.getValue());
                }
            });
            requestList.add(requestContent);
        });
        HttpEntity request = new HttpEntity(requestList, (MultiValueMap)headers);
        try {
            this.restTemplate.postForObject(url, (Object)request, String.class, new Object[0]);
        }
        catch (Exception ex) {
            logger.error("IAM\u540c\u6b65\u4e91\u5e73\u53f0\u96c6\u6210\u6570\u636e{}\u5f02\u5e38:{}", new Object[]{JsonUtils.writeValue(requestList), ex.getMessage(), ex});
            throw new RuntimeException("IAM\u540c\u6b65\u4e91\u5e73\u53f0\u96c6\u6210\u6570\u636e\u5f02\u5e38:" + ex.getMessage());
        }
    }

    public UserAndTenantSimpleInfo getUserAndTenantSimpleInfo(long userSid, long tenantSid) {
        UserAndTenantSimpleInfo userAndTenantSimpleInfo = new UserAndTenantSimpleInfo();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, StringUtils.hasText((String)UserUtils.getToken()) ? UserUtils.getToken() : this.dapHttpService.getUserToken(tenantSid));
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        try {
            String url = this.envProperties.getIamUri() + String.format("/api/iam/v2/user/%s/tenant/%s/simple", userSid, tenantSid);
            ResponseEntity result = this.restTemplate.exchange(url, HttpMethod.GET, request, UserAndTenantSimpleInfo.class, new Object[0]);
            if (null != result && null != result.getBody()) {
                return (UserAndTenantSimpleInfo)result.getBody();
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u79df\u6237\u4e0e\u7528\u6237\u7b80\u5355\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
        return userAndTenantSimpleInfo;
    }

    public List<CommonParam> getTeamInfo() {
        try {
            String userToken = UserUtils.getToken() != null ? UserUtils.getToken() : this.dapHttpService.getUserToken(this.envProperties.getManagerTenant());
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
            headers.add("digi-middleware-auth-user", userToken);
            HttpEntity request = new HttpEntity((MultiValueMap)headers);
            String url = this.envProperties.getIamUri() + "/api/iam/v2/teams" + "?pageNum=1&pageSize=9999";
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            return Optional.ofNullable(responseEntity.getBody()).map(StdData::getData).map(PageSerializable::getList).orElse(Collections.emptyList());
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u516c\u5171\u53c2\u6570\u56e2\u961f\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public SysFullInfoVO getDevSysFullInfo(String sysId, String sourceIamUri) {
        SysFullInfoVO result = new SysFullInfoVO();
        try {
            String userToken;
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity request = new HttpEntity((MultiValueMap)headers);
            String iamUri = this.envProperties.getIamUri();
            if (StringUtils.hasText((String)sourceIamUri)) {
                iamUri = sourceIamUri;
                userToken = this.dapHttpService.getUserToken(this.envProperties.getManagerTenant(), iamUri);
            } else {
                userToken = UserUtils.getToken();
                if (!StringUtils.hasText((String)userToken)) {
                    userToken = this.dapHttpService.getUserToken(this.envProperties.getManagerTenant(), iamUri);
                }
            }
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, userToken);
            String url = iamUri + String.format("/api/iam/v2/dev/app/fullInfo/%s", sysId);
            logger.info("\u83b7\u53d6dev\u5e94\u7528\u4fe1\u606f:{}", (Object)url);
            ResponseEntity response = this.retryRestTemplate.exchange(url, HttpMethod.POST, request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            return Optional.ofNullable(response.getBody()).map(StdData::getData).orElse(null);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6dev \u5e94\u7528\u8be6\u60c5\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            return result;
        }
    }

    public Map<String, Map<String, String>> getDevSysLanguage(String sysId) {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
            HashMap<String, String> body = new HashMap<String, String>();
            body.put("id", sysId);
            HttpEntity requestBody = new HttpEntity(body, (MultiValueMap)headers);
            String url = this.envProperties.getIamUri() + "/api/iam/v2/dev/app/info/language";
            return (Map)this.retryRestTemplate.postForObject(url, (Object)requestBody, Map.class, new Object[0]);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5546\u54c1\u591a\u8bed\u8a00\u4fe1\u606f\u5931\u8d25:{}", (Object)e.getMessage());
            return Collections.emptyMap();
        }
    }

    public List<String> getSysIdSold(String devId) {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
            HttpEntity requestBody = new HttpEntity(Collections.singletonMap("devId", devId), (MultiValueMap)headers);
            String url = this.envProperties.getIamUri() + "/api/iam/v2/dev/sys/id/sold";
            return (List)this.retryRestTemplate.postForObject(url, (Object)requestBody, List.class, new Object[0]);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5e94\u7528ID\u5931\u8d25:{}", (Object)e.getMessage());
            return Collections.emptyList();
        }
    }

    public List<String> getWhiteList(String id) {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
            HashMap<String, String> body = new HashMap<String, String>();
            body.put("id", id);
            HttpEntity requestBody = new HttpEntity(body, (MultiValueMap)headers);
            String url = this.envProperties.getIamUri() + "/api/iam/v2/white/list";
            return (List)this.retryRestTemplate.postForObject(url, (Object)requestBody, List.class, new Object[0]);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5e94\u7528ID\u5931\u8d25:{}", (Object)e.getMessage());
            return Collections.emptyList();
        }
    }

    public List<DevSys> findDevSysByTenant() {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
            String url = this.envProperties.getIamUri() + "/api/iam/v2/dev/sys/devtenant";
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            return (List)responseEntity.getBody();
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5f00\u53d1\u5546\u5e94\u7528\u5931\u8d25", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public List<CommonVO> getTenantSimples(List<String> tenantIds) {
        try {
            if (CollectionUtils.isEmpty(tenantIds)) {
                return Collections.emptyList();
            }
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            String userToken = UserUtils.getToken() != null ? UserUtils.getToken() : this.dapHttpService.getUserToken(tenantIds.get(0));
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, userToken);
            HttpEntity request = new HttpEntity(tenantIds, (MultiValueMap)headers);
            String url = this.envProperties.getIamUri() + "/api/iam/v2/tenant/simples";
            ResponseEntity response = this.retryRestTemplate.exchange(url, HttpMethod.POST, request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            return (List)response.getBody();
        }
        catch (Exception e) {
            logger.error("\u3010IAM\u8c03\u7528\u3011\u83b7\u53d6\u79df\u6237\u7b80\u5355\u4fe1\u606f\u9519\u8bef", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public void deleteSysInfo(String goodsCode) {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
            HashMap<String, String> body = new HashMap<String, String>();
            body.put("id", goodsCode);
            HttpEntity requestBody = new HttpEntity(body, (MultiValueMap)headers);
            String url = this.envProperties.getIamUri() + "/api/iam/v2/app/del";
            this.restTemplate.postForEntity(url, (Object)requestBody, StdData.class, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("\u5220\u9664\u5e94\u7528[%s]\u4fe1\u606f\u5931\u8d25", goodsCode), e);
        }
    }

    public void addNotice(List<String> noticeTypes, String id) {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
            List body = noticeTypes.stream().map(a -> new SysNoticeVO(id, a)).collect(Collectors.toList());
            HttpEntity requestBody = new HttpEntity(body, (MultiValueMap)headers);
            String url = this.envProperties.getIamUri() + "/api/iam/v1/sys/notice/add/auto";
            this.restTemplate.postForEntity(url, (Object)requestBody, StdData.class, new Object[0]);
        }
        catch (Exception e) {
            logger.error("addNotice", (Throwable)e);
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, "\u65b0\u589e\u56de\u8c03\u5931\u8d25");
        }
    }

    public Map getRowPermission(String userToken, String userId) {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, userToken);
            HashMap<String, String> requestContent = new HashMap<String, String>(4);
            requestContent.put("sysId", "boss");
            requestContent.put("moduleId", "boss-goods");
            requestContent.put("actionId", "boss-goods-management");
            requestContent.put("userId", userId);
            HttpEntity request = new HttpEntity(requestContent, (MultiValueMap)headers);
            String url = this.envProperties.getIamUri() + "/api/iam/v2/permission/data/row";
            ResponseEntity responseEntity = this.retryRestTemplate.postForEntity(url, (Object)request, Map.class, new Object[0]);
            return (Map)responseEntity.getBody();
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6570\u636e\u6743\u9650\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    public List<SysNoticeVO> getSysNotice(String appId) {
        try {
            if (ObjectUtils.isEmpty((Object)appId)) {
                return Collections.emptyList();
            }
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("id", appId);
            HttpEntity request = new HttpEntity(params, (MultiValueMap)headers);
            String url = this.envProperties.getIamUri() + "/api/iam/v1/sys/notice/find";
            ResponseEntity response = this.retryRestTemplate.exchange(url, HttpMethod.POST, request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            return Optional.ofNullable(response).map(HttpEntity::getBody).map(StdData::getData).orElse(new ArrayList());
        }
        catch (Exception e) {
            logger.error("\u3010IAM\u8c03\u7528\u3011\u83b7\u53d6\u5e94\u7528\u901a\u77e5\u7c7b\u578b\u9519\u8bef", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public void addNotice(SysNoticeVO vo) {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
            HttpEntity requestBody = new HttpEntity((Object)vo, (MultiValueMap)headers);
            String url = this.envProperties.getIamUri() + "/api/iam/v1/sys/notice/add";
            this.restTemplate.postForEntity(url, (Object)requestBody, StdData.class, new Object[0]);
        }
        catch (Exception e) {
            logger.error("addNotice", (Throwable)e);
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, "\u65b0\u589e\u56de\u8c03\u5931\u8d25");
        }
    }

    public void deleteNotice(SysNoticeVO vo) {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
            HttpEntity requestBody = new HttpEntity((Object)vo, (MultiValueMap)headers);
            String url = this.envProperties.getIamUri() + "/api/iam/v1/sys/notice/del";
            this.restTemplate.postForEntity(url, (Object)requestBody, StdData.class, new Object[0]);
        }
        catch (Exception e) {
            logger.error("deleteNotice", (Throwable)e);
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, "\u65b0\u589e\u56de\u8c03\u5931\u8d25");
        }
    }

    public List<String> getDevSys(String tenantId) {
        if (ObjectUtils.isEmpty((Object)tenantId)) {
            return new ArrayList<String>();
        }
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.set(GlobalConstants.HTTP_HEADER_APP_TOKEN_KEY, "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpYXQiOjE0OTM4OTc3MjI0MTEsInNpZCI6ODIyMDIzMzgxOTg0NjE5NjUwLCJpZCI6ImNvcmVtaWRkbGV3YXJlIn0.DMSIMMmwi5qrq7niOl80nU5VbXjFWlgmclTn2cEiORo");
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, ObjectUtils.isEmpty((Object)UserUtils.getToken()) ? this.dapHttpService.getUserToken(tenantId) : UserUtils.getToken());
            HttpEntity request = new HttpEntity((MultiValueMap)headers);
            String url = this.envProperties.getIamUri() + "/api/iam/v2/dev/app/tenant/id" + "?tenantId=" + tenantId;
            ResponseEntity responseEntity = this.retryRestTemplate.exchange(url, HttpMethod.GET, request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            return Optional.of(responseEntity).map(HttpEntity::getBody).map(StdData::getData).orElse(new ArrayList());
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2iam\u5f00\u53d1\u5546\u5e94\u7528\u5931\u8d25", (Throwable)e);
            return new ArrayList<String>();
        }
    }

    public UserVO getCurrentUser(AuthoredUser authoredUser) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, authoredUser.getToken());
        HttpEntity httpEntity = new HttpEntity(Collections.singletonMap("sid", authoredUser.getSid()), (MultiValueMap)headers);
        try {
            String url = this.envProperties.getIamUri() + "/api/iam/v2/user";
            return (UserVO)this.retryRestTemplate.postForObject(url, (Object)httpEntity, UserVO.class, new Object[0]);
        }
        catch (Exception e) {
            logger.error("\u3010\u67e5\u8be2\u5f53\u524d\u7528\u6237\u4fe1\u606f\u3011\u5931\u8d25", (Throwable)e);
            return null;
        }
    }
}

