/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.support.remote.impl;

import com.digiwin.dap.middleware.dict.constant.enums.DictEnum;
import com.digiwin.dap.middleware.dict.domain.DictDataDTO;
import com.digiwin.dap.middleware.dict.service.DictDataService;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.gmc.constant.enums.GoodsCategoryEnum;
import com.digiwin.dap.middleware.gmc.constant.enums.NoticeTypeEnum;
import com.digiwin.dap.middleware.gmc.domain.CommonVO;
import com.digiwin.dap.middleware.gmc.domain.coupon.ExpiredCouponVO;
import com.digiwin.dap.middleware.gmc.domain.goods.GoodsCounselDTO;
import com.digiwin.dap.middleware.gmc.domain.goods.GoodsVO;
import com.digiwin.dap.middleware.gmc.domain.goods.SearchParamVO;
import com.digiwin.dap.middleware.gmc.domain.remote.GoodsExpireEmailVO;
import com.digiwin.dap.middleware.gmc.domain.remote.GoodsExpireVO;
import com.digiwin.dap.middleware.gmc.domain.remote.Order;
import com.digiwin.dap.middleware.gmc.domain.remote.PreOrderDTO;
import com.digiwin.dap.middleware.gmc.domain.remote.PurchaseDetailVO;
import com.digiwin.dap.middleware.gmc.domain.remote.ShoppingCartOrderVO;
import com.digiwin.dap.middleware.gmc.domain.remote.UserAndTenantSimpleInfo;
import com.digiwin.dap.middleware.gmc.entity.Goods;
import com.digiwin.dap.middleware.gmc.entity.GoodsCounsel;
import com.digiwin.dap.middleware.gmc.entity.SellingStrategy;
import com.digiwin.dap.middleware.gmc.mapper.GoodsMapper;
import com.digiwin.dap.middleware.gmc.mapper.InstallmentOrderMapper;
import com.digiwin.dap.middleware.gmc.mapper.MailDataMapper;
import com.digiwin.dap.middleware.gmc.mapper.MyCouponMapper;
import com.digiwin.dap.middleware.gmc.mapper.OrderDetailMapper;
import com.digiwin.dap.middleware.gmc.mapper.OrderMapper;
import com.digiwin.dap.middleware.gmc.mapper.PreOrderMapper;
import com.digiwin.dap.middleware.gmc.repository.GoodsRepository;
import com.digiwin.dap.middleware.gmc.repository.SellingStrategyRepository;
import com.digiwin.dap.middleware.gmc.service.goods.GoodsCrudService;
import com.digiwin.dap.middleware.gmc.service.goods.SellingStrategyCrudService;
import com.digiwin.dap.middleware.gmc.service.goodscounsel.GoodsCounselCrudService;
import com.digiwin.dap.middleware.gmc.support.remote.CacService;
import com.digiwin.dap.middleware.gmc.support.remote.IamService;
import com.digiwin.dap.middleware.gmc.support.remote.MailService;
import com.digiwin.dap.middleware.gmc.support.stream.PutawayMessageService;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class MailServiceImpl
implements MailService {
    private static final Logger logger = LoggerFactory.getLogger(MailServiceImpl.class);
    private static List<Long> numbers = Arrays.asList(1L, 2L, 3L, 7L, 30L);
    private static List<Long> numbers4TypeFour = Arrays.asList(1L, 3L, 7L, 45L, 60L);
    @Autowired
    PutawayMessageService messageService;
    @Autowired
    CacService cacService;
    @Autowired
    GoodsMapper goodsMapper;
    @Autowired
    SellingStrategyRepository sellingStrategyRepository;
    @Autowired
    GoodsRepository goodsRepository;
    @Autowired
    MyCouponMapper myCouponMapper;
    @Autowired
    IamService iamService;
    @Autowired
    GoodsCrudService goodsCrudService;
    @Autowired
    SellingStrategyCrudService sellingStrategyCrudService;
    @Autowired
    GoodsCounselCrudService goodsCounselCrudService;
    @Autowired
    private MailDataMapper mailDataMapper;
    @Autowired
    private PreOrderMapper preOrderMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrderDetailMapper orderDetailMapper;
    @Autowired
    private DictDataService dictDataService;
    @Autowired
    private InstallmentOrderMapper installmentOrderMapper;

    private static Long getDaysDiff(LocalDateTime dateTime) {
        LocalDate date = LocalDate.of(dateTime.getYear(), dateTime.getMonth(), dateTime.getDayOfMonth());
        return ChronoUnit.DAYS.between(LocalDate.now(), date);
    }

    private static boolean get(Long expired, int type) {
        boolean bool = false;
        if (1 == type) {
            bool = numbers.contains(expired);
        } else if (2 == type) {
            bool = 3L == expired;
        } else if (4 == type) {
            bool = numbers4TypeFour.contains(expired);
        }
        return bool;
    }

    public static Date getFirstMonthDay(Calendar calendar) {
        calendar.set(5, calendar.getActualMinimum(5));
        return calendar.getTime();
    }

    /*
     * WARNING - void declaration
     */
    public void sendGoodsExpire() {
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime nowAfterThirty = LocalDateTime.now().plusDays(31L);
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String beginTime = dtf.format(now);
        String endTime = dtf.format(nowAfterThirty);
        List purchaseGoods = this.cacService.getPurchaseDetailVOs(GoodsCategoryEnum.apps(), beginTime, endTime);
        purchaseGoods.removeIf(a -> StringUtils.hasLength((String)a.getBundleCode()));
        purchaseGoods = this.filterByExpireNotice(purchaseGoods);
        List strategySids = purchaseGoods.stream().map(PurchaseDetailVO::getStrategySid).collect(Collectors.toList());
        List goods = this.goodsMapper.findGoodsAndStrategy(strategySids);
        Map goodsMap = goods.stream().collect(Collectors.toMap(GoodsExpireVO::getStrategySid, Function.identity()));
        ArrayList<GoodsExpireVO> purchaseExpires = new ArrayList<GoodsExpireVO>();
        for (PurchaseDetailVO purchase : purchaseGoods) {
            PreOrderDTO preOrderDTO = new PreOrderDTO();
            preOrderDTO.setTenantId(purchase.getTenantId());
            preOrderDTO.setGoodsCode(purchase.getGoodsCode());
            preOrderDTO.setAuthorization(Boolean.FALSE);
            preOrderDTO.setExpiredDateStart(purchase.getExpiredTime());
            List preOrders = this.preOrderMapper.getPreOrders(preOrderDTO);
            if (!CollectionUtils.isEmpty((Collection)preOrders)) continue;
            GoodsExpireVO goodsExpireVO = new GoodsExpireVO();
            GoodsExpireVO goodsBase = (GoodsExpireVO)goodsMap.get(purchase.getStrategySid());
            if (null != goodsBase) {
                goodsExpireVO.setTenantId(purchase.getTenantId());
                goodsExpireVO.setTenantName(purchase.getTenantName());
                goodsExpireVO.setCode(goodsBase.getCode());
                goodsExpireVO.setGoodsName(goodsBase.getGoodsName());
                goodsExpireVO.setStrategySid(goodsBase.getStrategySid());
                goodsExpireVO.setStrategyName(goodsBase.getStrategyName());
                goodsExpireVO.setExpired(MailServiceImpl.getDaysDiff((LocalDateTime)purchase.getExpiredTime()));
                goodsExpireVO.setExpiredTime(purchase.getExpiredTime());
                goodsExpireVO.setNotificationCycle(goodsBase.getNotificationCycle());
                goodsExpireVO.setPaymentTypeName(goodsBase.getPaymentTypeName());
                goodsExpireVO.setCount(this.decideCount(purchase.getTotalCount(), purchase.getTotalUsage(), goodsBase.getPaymentType()));
                goodsExpireVO.setAdminEmails(goodsBase.getAdminEmails());
                purchaseExpires.add(goodsExpireVO);
                continue;
            }
            System.out.println("\u6ca1\u6709\u627e\u5230\u7b56\u7565\u4fe1\u606f = " + purchase.getStrategySid());
        }
        List emailExpires = purchaseExpires.stream().filter(o -> MailServiceImpl.get((Long)o.getExpired(), (int)o.getNotificationCycle())).collect(Collectors.toList());
        this.sendGoodsEmail(emailExpires);
        HashMap emailExpiresByTenantIdMap = new HashMap();
        for (Object goodsExpireVO : emailExpires) {
            if (CollectionUtils.isEmpty((Collection)((Collection)emailExpiresByTenantIdMap.get(goodsExpireVO.getTenantId())))) {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(goodsExpireVO);
                emailExpiresByTenantIdMap.put(goodsExpireVO.getTenantId(), arrayList);
                continue;
            }
            ((List)emailExpiresByTenantIdMap.get(goodsExpireVO.getTenantId())).add(goodsExpireVO);
        }
        HashMap emailExpiresByTenantAndExpireMap = new HashMap();
        for (Map.Entry entry : emailExpiresByTenantIdMap.entrySet()) {
            List goodsExpireVOList = (List)entry.getValue();
            HashMap map = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)goodsExpireVOList)) {
                List goodCodes = goodsExpireVOList.stream().map(GoodsExpireVO::getCode).collect(Collectors.toList());
                List periodGoodsList = this.installmentOrderMapper.findPeriodGoods((String)entry.getKey(), goodCodes);
                HashSet periodGoodsSet = new HashSet(Optional.ofNullable(periodGoodsList).orElse(Collections.emptyList()));
                for (GoodsExpireVO goodsExpireVO : goodsExpireVOList) {
                    goodsExpireVO.setPeriodGood(periodGoodsSet.contains(goodsExpireVO.getCode()));
                    if (CollectionUtils.isEmpty((Collection)((Collection)map.get(goodsExpireVO.getExpiredTime())))) {
                        ArrayList<GoodsExpireVO> goodsExpireVOs = new ArrayList<GoodsExpireVO>();
                        goodsExpireVOs.add(goodsExpireVO);
                        map.put(goodsExpireVO.getExpiredTime(), goodsExpireVOs);
                        continue;
                    }
                    ((List)map.get(goodsExpireVO.getExpiredTime())).add(goodsExpireVO);
                }
            }
            emailExpiresByTenantAndExpireMap.put(entry.getKey(), map);
        }
        Set tenantIds = emailExpiresByTenantAndExpireMap.keySet();
        HashMap hashMap = new HashMap();
        Map<Object, Object> tenantLanguageMap = new HashMap();
        Set<Object> experienceTenants = new HashSet();
        if (!CollectionUtils.isEmpty(tenantIds)) {
            List tenantSimples = this.iamService.getTenantSimples(new ArrayList(tenantIds));
            Map<String, String> map = tenantSimples.stream().collect(Collectors.toMap(CommonVO::getId, CommonVO::getName));
            experienceTenants = tenantSimples.stream().filter(CommonVO::isExperience).map(CommonVO::getId).collect(Collectors.toSet());
            tenantLanguageMap = tenantSimples.stream().filter(a -> StringUtils.hasLength((String)a.getDefaultLanguage())).collect(Collectors.toMap(CommonVO::getId, CommonVO::getDefaultLanguage));
        }
        for (Map.Entry entry : emailExpiresByTenantAndExpireMap.entrySet()) {
            String tenantId = (String)entry.getKey();
            Map value = (Map)entry.getValue();
            for (Map.Entry entry1 : value.entrySet()) {
                List normalGoods;
                void var15_22;
                LocalDateTime expiredTime = (LocalDateTime)entry1.getKey();
                List goodsExpires = (List)entry1.getValue();
                boolean isExperience = experienceTenants.contains(tenantId);
                String language = (String)tenantLanguageMap.get(tenantId);
                String event = this.getEvent(language, isExperience);
                String tenantName = var15_22.getOrDefault(tenantId, ((GoodsExpireVO)goodsExpires.get(0)).getTenantName());
                if (isExperience) {
                    goodsExpires.forEach(aGood -> {
                        if (aGood.isPeriodGood()) {
                            this.messageService.invokeWithLocale(language, () -> this.messageService.sendGoodsExpireList(Collections.singletonList(aGood), tenantId, tenantName, expiredTime, NoticeTypeEnum.GMC_PERIOD_GOODS_EXPIRE_TENANT.name()));
                        } else {
                            this.messageService.invokeWithLocale(language, () -> this.messageService.sendGoodsExpireList(Collections.singletonList(aGood), tenantId, tenantName, expiredTime, event));
                        }
                    });
                    continue;
                }
                List periodGoods = goodsExpires.stream().filter(GoodsExpireVO::isPeriodGood).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(periodGoods)) {
                    this.messageService.invokeWithLocale(language, () -> this.messageService.sendGoodsExpireList(goodsExpires, tenantId, tenantName, expiredTime, NoticeTypeEnum.GMC_PERIOD_GOODS_EXPIRE_TENANT.name()));
                }
                if (CollectionUtils.isEmpty(normalGoods = goodsExpires.stream().filter(e -> !e.isPeriodGood()).collect(Collectors.toList()))) continue;
                this.messageService.invokeWithLocale(language, () -> this.messageService.sendGoodsExpireList(goodsExpires, tenantId, tenantName, expiredTime, event));
            }
        }
    }

    private void sendGoodsEmail(List<GoodsExpireVO> emailExpires) {
        Map<String, List<GoodsExpireVO>> byGoods = emailExpires.stream().filter(a -> !StringUtils.isEmpty((Object)a.getAdminEmails())).collect(Collectors.groupingBy(GoodsExpireVO::getAdminEmails));
        for (List<GoodsExpireVO> aGood : byGoods.values()) {
            Map<Long, List<GoodsExpireVO>> byExpired = aGood.stream().collect(Collectors.groupingBy(GoodsExpireVO::getExpired));
            for (Map.Entry<Long, List<GoodsExpireVO>> sameExpireDay : byExpired.entrySet()) {
                this.messageService.sendGoodsExpire(new GoodsExpireEmailVO(sameExpireDay.getValue().get(0).getCode(), sameExpireDay.getKey(), sameExpireDay.getValue()));
            }
        }
    }

    private String decideCount(Integer totalCount, Integer totalUsage, Integer paymentType) {
        switch (paymentType) {
            case 0: 
            case 2: {
                return String.valueOf(totalUsage);
            }
            case 1: {
                return String.valueOf(totalCount);
            }
        }
        return "\u221e";
    }

    private String getEvent(String language, boolean isExperience) {
        if (isExperience) {
            return NoticeTypeEnum.GMC_GOODS_EXPIRE_TENANT_EXPERIENCE.name();
        }
        if ("vi_VN".equals(language) || "en_US".equals(language)) {
            return NoticeTypeEnum.GMC_GOODS_EXPIRE_TENANT_EN_US.name();
        }
        return NoticeTypeEnum.GMC_GOODS_EXPIRE_TENANT.name();
    }

    public void sendAuthExpireGoods() {
        List<PurchaseDetailVO> purchaseDetailVOS2;
        List<PurchaseDetailVO> purchaseDetailVOS1;
        SearchParamVO searchParamVO = new SearchParamVO();
        searchParamVO.setCategoryId("app");
        List goodsVOS = this.goodsMapper.selectGoodsVOExcludeLargeFields(searchParamVO);
        List sellingStrategies = this.sellingStrategyRepository.findAll();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String nextMothBeginTime = sdf.format(MailServiceImpl.getFirstMonthDay((Calendar)this.getDate(1)));
        String nextMothEndTime = sdf.format(MailServiceImpl.getFirstMonthDay((Calendar)this.getDate(2)));
        List purchaseDetailVOS = this.cacService.getPurchaseDetailVOs(nextMothBeginTime, nextMothEndTime);
        purchaseDetailVOS = this.filterByExpireNotice(purchaseDetailVOS);
        this.mergeGoodsInfo(purchaseDetailVOS, goodsVOS, sellingStrategies);
        ArrayList<PurchaseDetailVO> purchaseDetailVOSFilterHasAuth = new ArrayList<PurchaseDetailVO>();
        for (PurchaseDetailVO purchaseDetailVO : purchaseDetailVOS) {
            PreOrderDTO preOrderDTO = new PreOrderDTO();
            preOrderDTO.setGoodsCode(purchaseDetailVO.getGoodsCode());
            preOrderDTO.setAuthorization(Boolean.FALSE);
            preOrderDTO.setOrderType(Integer.valueOf(0));
            List preOrders = this.preOrderMapper.getPreOrders(preOrderDTO);
            if (!CollectionUtils.isEmpty((Collection)preOrders)) continue;
            purchaseDetailVOSFilterHasAuth.add(purchaseDetailVO);
        }
        Map<String, List<PurchaseDetailVO>> purchaseDetailMap = purchaseDetailVOSFilterHasAuth.stream().filter(a -> StringUtils.hasLength((String)a.getAdminEmail())).collect(Collectors.groupingBy(PurchaseDetailVO::getAdminEmail));
        String threeMothBeginTime = sdf.format(MailServiceImpl.getFirstMonthDay((Calendar)this.getDate(4)));
        String threeMothEndTime = sdf.format(MailServiceImpl.getFirstMonthDay((Calendar)this.getDate(5)));
        List threePurchaseDetailVOS = this.cacService.getPurchaseDetailVOs(threeMothBeginTime, threeMothEndTime);
        threePurchaseDetailVOS = this.filterByExpireNotice(threePurchaseDetailVOS);
        this.mergeGoodsInfo(threePurchaseDetailVOS, goodsVOS, sellingStrategies);
        ArrayList<PurchaseDetailVO> threePurchaseDetailVOSFilterHasAuth = new ArrayList<PurchaseDetailVO>();
        for (PurchaseDetailVO purchaseDetailVO : threePurchaseDetailVOS) {
            PreOrderDTO preOrderDTO = new PreOrderDTO();
            preOrderDTO.setGoodsCode(purchaseDetailVO.getGoodsCode());
            preOrderDTO.setAuthorization(Boolean.FALSE);
            preOrderDTO.setOrderType(Integer.valueOf(0));
            List preOrders = this.preOrderMapper.getPreOrders(preOrderDTO);
            if (!CollectionUtils.isEmpty((Collection)preOrders)) continue;
            threePurchaseDetailVOSFilterHasAuth.add(purchaseDetailVO);
        }
        Map<String, List<PurchaseDetailVO>> threePurchaseDetailMap = threePurchaseDetailVOSFilterHasAuth.stream().filter(a -> StringUtils.hasLength((String)a.getAdminEmail())).collect(Collectors.groupingBy(PurchaseDetailVO::getAdminEmail));
        for (Map.Entry<String, List<PurchaseDetailVO>> entry : purchaseDetailMap.entrySet()) {
            purchaseDetailVOS1 = entry.getValue();
            purchaseDetailVOS2 = threePurchaseDetailMap.get(entry.getKey());
            this.generateEmailContent(purchaseDetailVOS1.get(0).getGoodsCode(), nextMothBeginTime, nextMothEndTime, purchaseDetailVOS1, threeMothBeginTime, threeMothEndTime, purchaseDetailVOS2);
        }
        for (Map.Entry<String, List<PurchaseDetailVO>> entry : threePurchaseDetailMap.entrySet()) {
            purchaseDetailVOS1 = entry.getValue();
            purchaseDetailVOS2 = purchaseDetailMap.get(entry.getKey());
            if (purchaseDetailVOS2 != null) continue;
            this.generateEmailContent(purchaseDetailVOS1.get(0).getGoodsCode(), nextMothBeginTime, nextMothEndTime, new ArrayList(), threeMothBeginTime, threeMothEndTime, purchaseDetailVOS1);
        }
    }

    private List<PurchaseDetailVO> filterByExpireNotice(List<PurchaseDetailVO> purchaseDetailVOS) {
        ArrayList<PurchaseDetailVO> result = new ArrayList<PurchaseDetailVO>();
        purchaseDetailVOS.forEach(purchaseDetailVO -> {
            if (!"Y".equals(purchaseDetailVO.getExpireNotice())) {
                result.add((PurchaseDetailVO)purchaseDetailVO);
            }
        });
        return result;
    }

    public void sendExpiredCoupon() {
        List expiredCouponVOS = this.myCouponMapper.getExpiredCouponInfos();
        for (ExpiredCouponVO expiredCouponVO : expiredCouponVOS) {
            UserAndTenantSimpleInfo userAndTenantSimpleInfo = this.iamService.getUserAndTenantSimpleInfo(expiredCouponVO.getUserSid().longValue(), expiredCouponVO.getTenantSid().longValue());
            if (userAndTenantSimpleInfo == null) continue;
            BeanUtils.copyProperties((Object)userAndTenantSimpleInfo, (Object)expiredCouponVO);
            this.messageService.send(expiredCouponVO);
        }
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public boolean sendGoodsCounsel(long sid) {
        GoodsCounsel goodsCounsel = (GoodsCounsel)Optional.ofNullable(this.goodsCounselCrudService.findBySid(sid)).orElseThrow(() -> new BusinessException(String.format("\u6b64\u5546\u54c1/\u4fe1\u606f\u54a8\u8be2[%s]\u4e0d\u5b58\u5728", sid)));
        GoodsCounselDTO counselDTO = new GoodsCounselDTO();
        counselDTO.setCounselTime(Optional.ofNullable(goodsCounsel.getCreateDate()).orElse(LocalDateTime.now()).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        counselDTO.doBackward((Object)goodsCounsel);
        counselDTO.setCode(goodsCounsel.getGoodsCode());
        if (!StringUtils.isEmpty((Object)counselDTO.getTrialSource())) {
            Optional.ofNullable(this.dictDataService.selectDictData(new DictDataDTO(DictEnum.TRIAL_SOURCE.getId(), counselDTO.getTrialSource()))).ifPresent(x -> counselDTO.setTrialSourceName(x.getDictValue()));
        }
        boolean success = true;
        if (!StringUtils.isEmpty((Object)goodsCounsel.getOrderCode())) {
            Order order = Optional.ofNullable(this.orderMapper.findByOrderCode(goodsCounsel.getOrderCode())).orElseThrow(() -> new BusinessException(String.format("\u6ca1\u6709\u6b64\u8ba2\u5355\u7f16\u53f7[%s]", goodsCounsel.getOrderCode())));
            ShoppingCartOrderVO dto = new ShoppingCartOrderVO();
            dto.setShopping(Integer.valueOf(0));
            boolean isCartOrder = Integer.valueOf(1).equals(order.getShopping());
            if (isCartOrder) {
                dto.setCartCode(order.getCartCode());
            } else {
                dto.setOrderCode(order.getOrderCode());
            }
            List orderVos = this.orderDetailMapper.getShoppingCartOrderVos(dto);
            if (isCartOrder && !CollectionUtils.isEmpty((Collection)orderVos)) {
                List adminEmailsList = this.goodsMapper.selectAdminEmailsList(orderVos.stream().map(ShoppingCartOrderVO::getGoodsCode).collect(Collectors.toList()));
                counselDTO.setProductAdmin(String.join((CharSequence)String.valueOf(';'), adminEmailsList));
            }
            counselDTO.setShoppingCartOrderVos(orderVos);
        }
        try {
            this.messageService.send(counselDTO);
        }
        catch (Exception e) {
            logger.error(String.format("\u5546\u54c1/\u4fe1\u606f[%s]\u54a8\u8be2\u90ae\u4ef6\u53d1\u9001\u5931\u8d25", sid), (Throwable)e);
            success = false;
        }
        goodsCounsel.setNotified(Boolean.valueOf(success));
        this.goodsCounselCrudService.create((BaseEntity)goodsCounsel);
        return success;
    }

    public void sendChangePaymentType(Goods goods, int oldId, int newId) {
        String oldName = this.mailDataMapper.findPaymentType(goods.getCategoryId(), (long)oldId);
        String newName = this.mailDataMapper.findPaymentType(goods.getCategoryId(), (long)newId);
        HashMap<String, String> content = new HashMap<String, String>();
        content.put("code", goods.getCode());
        content.put("goodsName", goods.getDisplayName());
        content.put("oldName", this.getCustomUnit(goods.getCategoryId(), oldId, oldName, goods.getCustomUnit()));
        content.put("newName", this.getCustomUnit(goods.getCategoryId(), newId, newName, goods.getCustomUnit()));
        this.messageService.send(content, NoticeTypeEnum.GMC_CHANGE_PAYMENT_TYPE.name());
    }

    public String getCustomUnit(String category, int id, String name, String custom) {
        String[] split;
        if (id == 2 && ("app".equals(category) || "device".equals(category)) && name != null && (split = name.split("/")).length == 2) {
            return custom + "/" + split[1];
        }
        return name;
    }

    public Calendar getDate(int plusMonths) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, plusMonths);
        return calendar;
    }

    private void mergeGoodsInfo(List<PurchaseDetailVO> purchaseDetailVOS, List<GoodsVO> goods, List<SellingStrategy> sellingStrategies) {
        purchaseDetailVOS.forEach(purchaseDetailVO -> {
            Optional<GoodsVO> goods1 = goods.stream().filter(g -> g.getCode().equals(purchaseDetailVO.getGoodsCode())).findFirst();
            if (!goods1.isPresent()) {
                return;
            }
            purchaseDetailVO.setAdminEmail(goods1.get().getAdminEmails());
            purchaseDetailVO.setGoodsName(goods1.get().getDisplayName());
            purchaseDetailVO.setPaymentTypeName(goods1.get().getPaymentTypeName());
            if (goods1.get().getPaymentType() == 1) {
                purchaseDetailVO.setCount(purchaseDetailVO.getTotalCount().toString());
            } else if (goods1.get().getPaymentType() == 2) {
                purchaseDetailVO.setCount(purchaseDetailVO.getTotalUsage().toString());
            } else {
                purchaseDetailVO.setCount("\u221e");
            }
            Optional<SellingStrategy> sellingStrategy = sellingStrategies.stream().filter(s -> s.getSid() == purchaseDetailVO.getStrategySid().longValue()).findFirst();
            if (!sellingStrategy.isPresent()) {
                return;
            }
            purchaseDetailVO.setSellingStrategyName(sellingStrategy.get().getName());
        });
    }

    private void generateEmailContent(String goodsCode, String nextMothBeginTime, String nextMothEndTime, List<PurchaseDetailVO> purchaseDetailVOS, String threeMothBeginTime, String threeMothEndTime, List<PurchaseDetailVO> threePurchaseDetailVOS) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        HashMap<String, Object> content = new HashMap<String, Object>();
        Goods goods = this.goodsRepository.findByCode(goodsCode);
        if (goods != null) {
            content.put("goodsName", goods.getDisplayName());
        }
        content.put("code", goodsCode);
        content.put("today", sdf.format(Calendar.getInstance().getTime()));
        content.put("nextMothBeginTime", nextMothBeginTime);
        content.put("nextMothEndTime", nextMothEndTime);
        content.put("purchaseDetailVOS", purchaseDetailVOS);
        content.put("threeMothBeginTime", threeMothBeginTime);
        content.put("threeMothEndTime", threeMothEndTime);
        content.put("threePurchaseDetailVOS", threePurchaseDetailVOS);
        this.messageService.send(content);
    }
}

