/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.support.remote.impl;

import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.gmc.domain.EnvProperties;
import com.digiwin.dap.middleware.gmc.domain.remote.esp.EspRequestInfo;
import com.digiwin.dap.middleware.gmc.domain.remote.esp.EspResponse;
import com.digiwin.dap.middleware.gmc.support.remote.MiswsService;
import com.digiwin.dap.middleware.util.JsonUtils;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class MiswsServiceImpl
implements MiswsService {
    private Logger LOGGER = LoggerFactory.getLogger(MiswsServiceImpl.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private RestTemplate restTemplate;

    public List<String> checkItem(List<String> itemCodes, String area) {
        String uri = String.format("%s%s", this.envProperties.getEspUri(), "/CROSS/RESTful");
        HttpHeaders headers = EspRequestInfo.buildHeader((String)this.envProperties.getGmcTestUri());
        EspRequestInfo.Std_data std_data = new EspRequestInfo.Std_data();
        itemCodes.forEach(c -> {
            EspRequestInfo.EspItemRequestInfo itemRequestInfo = new EspRequestInfo.EspItemRequestInfo(c, this.envProperties.getArea());
            std_data.getParameter().getMaster().add(itemRequestInfo);
        });
        EspRequestInfo espRequestInfo = new EspRequestInfo();
        espRequestInfo.setStdData(std_data);
        HttpEntity requestEntity = new HttpEntity((Object)espRequestInfo, (MultiValueMap)headers);
        List<String> errorItemCodes = itemCodes;
        try {
            ResponseEntity response = this.restTemplate.exchange(uri, HttpMethod.POST, requestEntity, EspResponse.class, new Object[0]);
            if (null == response || null == response.getBody()) {
                this.LOGGER.error("\u83b7\u53d6\u54c1\u53f7\u4fe1\u606f{}\u5931\u8d25\uff0c\u54cd\u5e94\u5bf9\u8c61\u4e3a\u7a7a", (Object)errorItemCodes.stream().collect(Collectors.joining(",")));
                throw new BusinessException("\u83b7\u53d6\u54c1\u53f7\u4fe1\u606f\u5931\u8d25\uff0c\u54cd\u5e94\u5bf9\u8c61\u4e3a\u7a7a");
            }
            if (StringUtils.hasText((String)((EspResponse)response.getBody()).getErrorCode())) {
                this.LOGGER.error("\u83b7\u53d6\u54c1\u53f7\u4fe1\u606f{}\u5931\u8d25\uff0c\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)errorItemCodes.stream().collect(Collectors.joining(",")), (Object)JsonUtils.objToJson((Object)response.getBody()));
                throw new BusinessException(String.format("\u83b7\u53d6\u54c1\u53f7\u4fe1\u606f\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\u662f:%s", ((EspResponse)response.getBody()).getErrorMessage()));
            }
            if (null == ((EspResponse)response.getBody()).getStdData() || null == ((EspResponse)response.getBody()).getStdData().getParameter() || null == ((EspResponse)response.getBody()).getStdData().getParameter().getSuccess_return()) {
                this.LOGGER.error("\u83b7\u53d6\u54c1\u53f7\u4fe1\u606f{}\u5931\u8d25\uff0c\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)errorItemCodes.stream().collect(Collectors.joining(",")), (Object)JsonUtils.objToJson((Object)response.getBody()));
                throw new BusinessException(String.format("\u83b7\u53d6\u54c1\u53f7\u4fe1\u606f\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\u662f:%s", ((EspResponse)response.getBody()).getErrorMessage()));
            }
            List successReturn = ((EspResponse)response.getBody()).getStdData().getParameter().getSuccess_return();
            successReturn.forEach(s -> {
                if (StringUtils.hasText((String)s.getImaa001())) {
                    errorItemCodes.remove(s.getImaa001());
                }
            });
            if (!CollectionUtils.isEmpty(errorItemCodes)) {
                this.LOGGER.error("\u83b7\u53d6\u54c1\u53f7\u4fe1\u606f{}\u5931\u8d25\uff0c\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)errorItemCodes.stream().collect(Collectors.joining(",")), (Object)JsonUtils.objToJson((Object)response.getBody()));
                throw new BusinessException(String.format("\u9500\u552e\u65b9\u6848\u7684\u54c1\u53f7${%s}\u4e0d\u5b58\u5728\uff0c", errorItemCodes.stream().collect(Collectors.joining(",")), JsonUtils.objToJson((Object)((EspResponse)response.getBody()).getStdData().getParameter())));
            }
        }
        catch (Exception ex) {
            this.LOGGER.error("\u83b7\u53d6\u54c1\u53f7\u4fe1\u606f{}\u5931\u8d25\uff0c\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)errorItemCodes.stream().collect(Collectors.joining(",")), (Object)JsonUtils.objToJson((Object)ex.getMessage()));
        }
        return errorItemCodes;
    }
}

