/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.support.remote.impl;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.constant.GlobalConstants;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.gmc.constant.I18nError;
import com.digiwin.dap.middleware.gmc.domain.EnvProperties;
import com.digiwin.dap.middleware.gmc.domain.remote.PreOrderDTO;
import com.digiwin.dap.middleware.gmc.support.remote.OmcService;
import com.digiwin.dap.middleware.util.DateUtils;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class OmcServiceImpl
implements OmcService {
    private static final Logger LOGGER = LoggerFactory.getLogger(OmcServiceImpl.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private RestTemplate restTemplate;

    public void addPreOrder(String appId, AuthoredUser authoredUser) {
        try {
            LOGGER.info("\u521b\u5efa\u79df\u6237[{}]\u4e0b\u5e94\u7528[{}]\u7684\u4eba\u5de5\u6388\u6743\u4fe1\u606f", (Object)authoredUser.getTenantId(), (Object)appId);
            PreOrderDTO preOrderDTO = new PreOrderDTO();
            preOrderDTO.setTenantSid(Long.valueOf(authoredUser.getTenantSid()));
            preOrderDTO.setTenantId(authoredUser.getTenantId());
            preOrderDTO.setTenantName(authoredUser.getTenantName());
            preOrderDTO.setSourceBillCode(String.format("%s_daplcdp_%s", appId, DateUtils.formatDateTimePure((TemporalAccessor)LocalDateTime.now())));
            preOrderDTO.setRemark("\u4f4e\u4ee3\u7801\u5e73\u53f0\u81ea\u52a8\u6388\u6743");
            preOrderDTO.setOrderType(Integer.valueOf(0));
            preOrderDTO.setGoodsCode(appId);
            preOrderDTO.setDaplcdp(Boolean.TRUE);
            HttpHeaders headers = new HttpHeaders();
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, authoredUser.getToken());
            HttpEntity httpEntity = new HttpEntity((Object)preOrderDTO, (MultiValueMap)headers);
            String url = this.envProperties.getOmcUri() + "/api/omc/v2/pre/order/test";
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            Boolean result = Optional.ofNullable(responseEntity.getBody()).map(StdData::getData).orElse(Boolean.FALSE);
            if (Boolean.FALSE.equals(result)) {
                throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, String.format("\u79df\u6237\u4e0b%s\u521b\u5efa\u5546\u54c1%s\u7684\u9884\u552e\u8ba2\u5355\u5931\u8d25", authoredUser.getTenantId(), appId));
            }
        }
        catch (Exception e) {
            throw new BusinessException(String.format("\u79df\u6237\u4e0b%s\u521b\u5efa\u5546\u54c1%s\u7684\u9884\u552e\u8ba2\u5355\u5931\u8d25", authoredUser.getTenantId(), appId), (Throwable)e);
        }
    }
}

