/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.support.remote.impl;

import com.digiwin.dap.middleware.gmc.domain.remote.Order;
import com.digiwin.dap.middleware.gmc.domain.remote.OrderDetailV1;
import com.digiwin.dap.middleware.gmc.domain.remote.OrderV1;
import com.digiwin.dap.middleware.gmc.mapper.OrderDetailMapper;
import com.digiwin.dap.middleware.gmc.mapper.OrderMapper;
import com.digiwin.dap.middleware.gmc.support.remote.OrderService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderServiceImpl
implements OrderService {
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrderDetailMapper orderDetailMapper;

    public List<OrderV1> getOrdersByTenantId(String tenantId) {
        List orders = this.orderMapper.findByTenantId(tenantId);
        return this.orderToDomain(orders);
    }

    private List<OrderV1> orderToDomain(List<Order> orders) {
        ArrayList<OrderV1> orderV1s = new ArrayList<OrderV1>();
        for (Order order : orders) {
            OrderV1 orderV1 = this.orderToDomain(order);
            orderV1s.add(orderV1);
        }
        return orderV1s;
    }

    private OrderV1 orderToDomain(Order order) {
        OrderV1 orderV1 = new OrderV1(order);
        List orderDetails = this.orderDetailMapper.findByOrderSid(order.getSid());
        ArrayList orderDetailV1s = new ArrayList();
        orderDetails.forEach(o -> orderDetailV1s.add(new OrderDetailV1(o)));
        orderV1.setOrderDetailList(orderDetailV1s);
        return orderV1;
    }
}

