/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.support.remote.impl;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.constant.GlobalConstants;
import com.digiwin.dap.middleware.gmc.domain.EnvProperties;
import com.digiwin.dap.middleware.gmc.domain.goods.GoodsAndLanguageVO;
import com.digiwin.dap.middleware.gmc.domain.goods.GoodsDTO;
import com.digiwin.dap.middleware.gmc.entity.Goods;
import com.digiwin.dap.middleware.gmc.support.remote.RemoteLMCService;
import com.digiwin.dap.middleware.lmc.LMC;
import com.digiwin.dap.middleware.lmc.internal.BusinessTypeEnum;
import com.digiwin.dap.middleware.lmc.request.SaveCompareOpLog;
import com.digiwin.dap.middleware.support.DapHttpService;
import com.digiwin.dap.middleware.util.ExceptionUtils;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class RemoteLMCServiceImpl
implements RemoteLMCService {
    private static final Logger logger = LoggerFactory.getLogger(RemoteLMCServiceImpl.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private DapHttpService dapHttpService;
    private static final ObjectMapper OBJECT_MAPPER = JsonUtils.createObjectMapper();
    @Autowired
    private LMC lmcClient;
    @Qualifier(value="dapLogExecutor")
    @Autowired
    private ThreadPoolTaskExecutor dapLogExecutor;

    public void saveGoodsModulesOpLog(GoodsAndLanguageVO goodsVO, GoodsAndLanguageVO oldGoodsVO, Goods goods, AuthoredUser authoredUser) {
        if (StringUtils.isEmpty((Object)this.envProperties.getLmcUri())) {
            logger.error("\u3010LMC\u8c03\u7528\u3011 \u4fdd\u5b58\u53d8\u66f4\u5386\u7a0b\u5931\u8d25\uff0cLMC URL \u4e3a\u7a7a");
            return;
        }
        Object logRequest = null;
        String url = "";
        try {
            SaveCompareOpLog dto = new SaveCompareOpLog();
            dto.setActId("digiwincloud");
            dto.setSource("GMC");
            dto.setActionId("update");
            dto.setTableName("good");
            dto.setOperationType("insert");
            dto.setModuleId("default");
            if (authoredUser != null) {
                dto.setEditUserId(authoredUser.getUserId());
                dto.setEditUserName(authoredUser.getUserName());
            }
            dto.setRemark("\u53d8\u66f4\u6a21\u5757");
            dto.setOperationType(BusinessTypeEnum.UPDATE.getDescribe());
            ArrayList logFieldList = new ArrayList();
            String fieldName = "fieldName";
            String displayName = "displayName";
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(fieldName, "code");
            map.put(displayName, "\u5546\u54c1code");
            logFieldList.add(map);
            map = new HashMap();
            map.put(fieldName, "modules");
            map.put(displayName, "\u5e94\u7528\u6a21\u5757");
            logFieldList.add(map);
            dto.setLogFieldList(logFieldList);
            ArrayList<HashMap<String, String>> primaryKeyList = new ArrayList<HashMap<String, String>>();
            map = new HashMap();
            map.put("path", "");
            map.put("keyName", "id");
            primaryKeyList.add(map);
            dto.setPrimaryKeyList(primaryKeyList);
            dto.setAppId("digiwincloud");
            dto.setRemark("\u7f16\u8f91\u8bed\u7cfb\u5bf9\u5e94\u54a8\u8be2");
            dto.setPrimaryKey(String.valueOf(goods.getSid()));
            dto.setModifyJson((Map)OBJECT_MAPPER.convertValue((Object)goodsVO, Map.class));
            dto.setOriginJson(oldGoodsVO != null ? (Map)OBJECT_MAPPER.convertValue((Object)oldGoodsVO, Map.class) : new HashMap());
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add("Accept", "application/json;charset=UTF-8");
            String userToken = Optional.ofNullable(authoredUser).map(AuthoredUser::getToken).orElseGet(() -> this.dapHttpService.getUserToken(this.envProperties.getManagerTenant()));
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, userToken);
            logRequest = new HttpEntity((Object)dto, (MultiValueMap)headers);
            url = this.envProperties.getLmcUri() + "/api/lmc/v1/oplog/compare/direct";
            this.restTemplate.postForEntity(url, logRequest, Object.class, new Object[0]);
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.logError((String)"\u3010LMC\u8c03\u7528\u3011 \u4fdd\u5b58\u53d8\u66f4\u5386\u7a0b\u5931\u8d25", (String)url, (Object)(logRequest == null ? logRequest : logRequest.getBody()), (Exception)e), (Throwable)e);
        }
    }

    public void logChangeFields(GoodsDTO goodsVO, Goods goods) {
        SaveCompareOpLog dto = new SaveCompareOpLog();
        dto.setActId("digiwincloud");
        dto.setSource("GMC");
        dto.setActionId("update");
        dto.setTableName("goods");
        dto.setModuleId("default");
        dto.setEditUserId(UserUtils.getUserId());
        dto.setEditUserName(UserUtils.getUserName());
        dto.setOperationType(BusinessTypeEnum.UPDATE.getDescribe());
        ArrayList<Map> logFieldList = new ArrayList<Map>();
        dto.setLogFieldList(logFieldList);
        logFieldList.add(RemoteLMCServiceImpl.getDisplayMap((String)"displayName", (String)"\u5546\u54c1\u540d\u79f0"));
        logFieldList.add(RemoteLMCServiceImpl.getDisplayMap((String)"disabled", (String)"\u662f\u5426\u7981\u7528\u72b6\u6001"));
        logFieldList.add(RemoteLMCServiceImpl.getDisplayMap((String)"showEntry", (String)"\u662f\u5426\u663e\u793a\u5728\u667a\u80fd\u5165\u53e3"));
        logFieldList.add(RemoteLMCServiceImpl.getDisplayMap((String)"devId", (String)"\u5f00\u53d1\u5546id"));
        logFieldList.add(RemoteLMCServiceImpl.getDisplayMap((String)"devName", (String)"\u5f00\u53d1\u5546\u540d\u79f0"));
        logFieldList.add(RemoteLMCServiceImpl.getDisplayMap((String)"sourceCloud", (String)"\u6765\u6e90\u4e91\u73af\u5883"));
        logFieldList.add(RemoteLMCServiceImpl.getDisplayMap((String)"sourceArea", (String)"\u6765\u6e90\u533a"));
        logFieldList.add(RemoteLMCServiceImpl.getDisplayMap((String)"optionalOrderPeriod", (String)"\u53ef\u9009\u8ba2\u8d2d\u671f\u6570"));
        ArrayList primaryKeyList = new ArrayList();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("path", "");
        map.put("keyName", "id");
        primaryKeyList.add(map);
        dto.setPrimaryKeyList(primaryKeyList);
        dto.setAppId("digiwincloud");
        dto.setRemark("\u5546\u54c1\u7f16\u8f91");
        dto.setPrimaryKey(String.valueOf(goods.getSid()));
        dto.setModifyJson((Map)OBJECT_MAPPER.convertValue((Object)goodsVO, Map.class));
        dto.setOriginJson((Map)OBJECT_MAPPER.convertValue((Object)goods, Map.class));
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("Accept", "application/json;charset=UTF-8");
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
        HttpEntity logRequest = new HttpEntity((Object)dto, (MultiValueMap)headers);
        String url = this.envProperties.getLmcUri() + "/api/lmc/v1/oplog/compare/direct";
        this.restTemplate.postForEntity(url, (Object)logRequest, Object.class, new Object[0]);
    }

    @NotNull
    private static Map<String, String> getDisplayMap(String key, String value) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("fieldName", key);
        map.put("displayName", value);
        return map;
    }

    public void logChangeFields(Goods before, Goods after) {
        try {
            Field[] fields;
            SaveCompareOpLog dto = new SaveCompareOpLog();
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            dto.setActId(before.getCode());
            dto.setSource(before.getCode());
            dto.setActionId("update");
            dto.setTableName("goods");
            dto.setModuleId(request.getServletPath());
            dto.setEditUserId(UserUtils.getUserId());
            dto.setEditUserName(UserUtils.getUserName());
            dto.setOperationType(BusinessTypeEnum.UPDATE.getDescribe());
            ArrayList<Map> logFieldList = new ArrayList<Map>();
            dto.setLogFieldList(logFieldList);
            for (Field field : fields = before.getClass().getDeclaredFields()) {
                logFieldList.add(RemoteLMCServiceImpl.getDisplayMap((String)field.getName(), (String)field.getName()));
            }
            ArrayList primaryKeyList = new ArrayList();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("path", "");
            map.put("keyName", "id");
            primaryKeyList.add(map);
            dto.setPrimaryKeyList(primaryKeyList);
            dto.setAppId("GMC");
            dto.setRemark("\u540e\u7aef\u5546\u54c1\u7f16\u8f91");
            dto.setPrimaryKey(before.getCode());
            dto.setModifyJson((Map)OBJECT_MAPPER.convertValue((Object)after, Map.class));
            dto.setOriginJson((Map)OBJECT_MAPPER.convertValue((Object)before, Map.class));
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add("Accept", "application/json;charset=UTF-8");
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
            HttpEntity logRequest = new HttpEntity((Object)dto, (MultiValueMap)headers);
            String url = this.envProperties.getLmcUri() + "/api/lmc/v1/oplog/compare/direct";
            this.restTemplate.postForEntity(url, (Object)logRequest, Object.class, new Object[0]);
        }
        catch (Exception e) {
            logger.error("\u3010LMC\u8c03\u7528\u3011 \u4fdd\u5b58\u53d8\u66f4\u5386\u7a0b\u5931\u8d25", (Throwable)e);
        }
    }

    public void logChangeFields(String actionId, Object before, Object after, String appId, List<Map<String, String>> changeFields, List<String> primaryKeyFields, String primaryKey) {
        try {
            SaveCompareOpLog dto = new SaveCompareOpLog();
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            dto.setActId(actionId);
            dto.setAppId(appId);
            dto.setSource("GMC");
            dto.setActionId(actionId);
            dto.setModuleId(request.getServletPath());
            dto.setEditUserId(UserUtils.getUserId());
            dto.setEditUserName(UserUtils.getUserName());
            dto.setOperationType(BusinessTypeEnum.UPDATE.getDescribe());
            dto.setPrimaryKey(primaryKey);
            List<Map<String, String>> logFieldMapList = changeFields;
            if (CollectionUtils.isEmpty(logFieldMapList)) {
                Field[] fields;
                for (Field field : fields = after.getClass().getDeclaredFields()) {
                    logFieldMapList.add(RemoteLMCServiceImpl.getDisplayMap((String)field.getName(), (String)field.getName()));
                }
            }
            dto.setLogFieldList(logFieldMapList);
            ArrayList primaryKeyList = new ArrayList();
            primaryKeyFields.forEach(f -> {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("path", "");
                map.put("keyName", (String)f);
                primaryKeyList.add(map);
            });
            dto.setPrimaryKeyList(primaryKeyList);
            dto.setModifyJson((Map)JsonUtils.jsonToObj((String)JsonUtils.objToJson((Object)after), Map.class));
            dto.setOriginJson((Map)JsonUtils.jsonToObj((String)JsonUtils.objToJson((Object)before), Map.class));
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add("Accept", "application/json;charset=UTF-8");
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
            this.saveChangeLogCore(dto, UserUtils.getToken());
        }
        catch (Exception e) {
            logger.error("\u3010LMC\u8c03\u7528\u3011 \u4fdd\u5b58\u53d8\u66f4\u5386\u7a0b\u5931\u8d25", (Throwable)e);
        }
    }

    public void saveChangeLogCore(SaveCompareOpLog saveOpLog, String userToken) {
        this.dapLogExecutor.execute(() -> {
            try {
                this.lmcClient.saveCompareOpLogDirect(saveOpLog, userToken);
            }
            catch (Exception e) {
                logger.error("\u3010LMC\u8c03\u7528\u3011\u4fdd\u5b58\u53d8\u66f4\u5386\u7a0b\u5931\u8d25", (Throwable)e);
            }
        });
    }
}

