/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.support.schedule.impl;

import com.digiwin.dap.middle.cache.lock.CacheLock;
import com.digiwin.dap.middleware.gmc.constant.enums.NoticeTypeEnum;
import com.digiwin.dap.middleware.gmc.support.remote.MailService;
import com.digiwin.dap.middleware.gmc.support.schedule.ScheduleTaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class ScheduleTaskServiceImpl
implements ScheduleTaskService {
    public static final Integer SLEEP_SECONDS = 30000;
    private static final Logger logger = LoggerFactory.getLogger(ScheduleTaskServiceImpl.class);
    @Autowired
    private MailService mailService;

    @CacheLock(prefix="gmc-schedule-task-01", expired=30L, autoDelete=false)
    @Scheduled(cron="0 0 2 25 * ?")
    public void sendAuthExpireGoods() {
        try {
            this.mailService.sendAuthExpireGoods();
        }
        catch (Exception e) {
            logger.error("\u4e8b\u4ef6[{}]\u6267\u884c\u5931\u8d25", (Object)NoticeTypeEnum.GMC_GOODS_TIME, (Object)e);
        }
    }

    @CacheLock(prefix="gmc-schedule-task-02", expired=30L, autoDelete=false)
    @Scheduled(cron="0 0 23 * * ?")
    public void sendGoodsExpire() {
        try {
            this.mailService.sendGoodsExpire();
            Thread.sleep(SLEEP_SECONDS.intValue());
        }
        catch (Exception e) {
            logger.error("\u4e8b\u4ef6[{}]\u6267\u884c\u5931\u8d25", (Object)NoticeTypeEnum.GMC_GOODS_EXPIRE, (Object)e);
        }
    }

    @CacheLock(prefix="gmc-schedule-task-03", expired=30L, autoDelete=false)
    @Scheduled(cron="0 1 0 1/1 * ?")
    public void sendCouponExpire() {
        try {
            this.mailService.sendExpiredCoupon();
        }
        catch (Exception e) {
            logger.error("\u4e8b\u4ef6[{}]\u6267\u884c\u5931\u8d25", (Object)NoticeTypeEnum.GMC_COUPON_EXPIRED, (Object)e);
        }
    }
}

