/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.support.stream.impl;

import com.digiwin.dap.middle.stream.domain.MessageBody;
import com.digiwin.dap.middle.stream.producer.ProducerService;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.gmc.constant.I18nError;
import com.digiwin.dap.middleware.gmc.constant.enums.GoodsCounselNoticeTypeEnum;
import com.digiwin.dap.middleware.gmc.constant.enums.MarketingConfigTypeEnum;
import com.digiwin.dap.middleware.gmc.constant.enums.NoticeTypeEnum;
import com.digiwin.dap.middleware.gmc.domain.ReferralCodeMessageInfo;
import com.digiwin.dap.middleware.gmc.domain.coupon.CouponExclusiveEmailVO;
import com.digiwin.dap.middleware.gmc.domain.coupon.ExpiredCouponVO;
import com.digiwin.dap.middleware.gmc.domain.goods.GoodsCounselDTO;
import com.digiwin.dap.middleware.gmc.domain.goods.GoodsVO;
import com.digiwin.dap.middleware.gmc.domain.marketing.MarketingConfigChangeMailVO;
import com.digiwin.dap.middleware.gmc.domain.remote.GoodsExpireEmailVO;
import com.digiwin.dap.middleware.gmc.domain.remote.GoodsExpireMergeVO;
import com.digiwin.dap.middleware.gmc.domain.remote.GoodsExpireVO;
import com.digiwin.dap.middleware.gmc.mapper.RecommendUserMapper;
import com.digiwin.dap.middleware.gmc.support.stream.PutawayMessageService;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class PutawayMessageServiceImpl
implements PutawayMessageService {
    private static final Logger logger = LoggerFactory.getLogger(PutawayMessageServiceImpl.class);
    @Autowired
    private ProducerService producerService;
    @Autowired
    private RecommendUserMapper recommendUserMapper;

    public void send(GoodsVO goodsVO, String opType) {
        MessageBody messageBody = new MessageBody();
        messageBody.setOpType(opType);
        messageBody.setData((Object)goodsVO);
        this.producerService.msg(messageBody);
    }

    public void sendGoodsExpire(GoodsExpireEmailVO goodsExpire) {
        MessageBody message = new MessageBody();
        message.setOpType(NoticeTypeEnum.GMC_GOODS_EXPIRE.name());
        message.setData((Object)goodsExpire);
        this.producerService.msg(message);
    }

    public void sendGoodsExpireList(List<GoodsExpireVO> goodsExpires, String tenantId, String tenantName, LocalDateTime expiredTime, String event) {
        logger.info("sendGoodsExpire tenantId:[{}], event:[{}]", (Object)tenantId, (Object)event);
        MessageBody message = new MessageBody();
        message.setOpType(event);
        GoodsExpireMergeVO goodsExpireMergeVO = new GoodsExpireMergeVO();
        goodsExpireMergeVO.setGoodsExpireVOs(goodsExpires);
        goodsExpireMergeVO.setExpired(goodsExpires.get(0).getExpired());
        goodsExpireMergeVO.setTenantId(tenantId);
        goodsExpireMergeVO.setExpiredTime(expiredTime);
        goodsExpireMergeVO.setTenantName(tenantName);
        message.setData((Object)goodsExpireMergeVO);
        this.producerService.msg(message);
    }

    @Async
    public void invokeWithLocale(String language, Runnable runnable) {
        if (StringUtils.hasLength((String)language)) {
            String[] split = language.split("_");
            LocaleContextHolder.setLocale((Locale)new Locale(split[0], split[1]));
        }
        runnable.run();
        LocaleContextHolder.resetLocaleContext();
    }

    public void send(Map<String, Object> map) {
        MessageBody message = new MessageBody();
        message.setOpType(NoticeTypeEnum.GMC_GOODS_TIME.name());
        message.setData(map);
        this.producerService.msg(message);
    }

    public void send(Map<String, Object> map, String opType) {
        MessageBody message = new MessageBody();
        message.setOpType(opType);
        message.setData(map);
        this.producerService.msg(message);
    }

    public void send(long recommendUserSid) {
        ReferralCodeMessageInfo referralCodeMessageInfo = this.recommendUserMapper.getReferralCodeMessageInfo(recommendUserSid);
        if (referralCodeMessageInfo == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_GENERAL, String.format("\u6ca1\u6709\u6b64\u63a8\u8350\u4eba:[%s]", recommendUserSid));
        }
        MessageBody message = new MessageBody();
        message.setOpType(NoticeTypeEnum.GMC_REFERRAL_CODE.name());
        message.setData((Object)referralCodeMessageInfo);
        this.producerService.msg(message);
    }

    public void send(ExpiredCouponVO expiredCouponVO) {
        MessageBody message = new MessageBody();
        message.setOpType(NoticeTypeEnum.GMC_COUPON_EXPIRED.name());
        message.setData((Object)expiredCouponVO);
        this.producerService.msg(message);
    }

    public void send(GoodsCounselDTO dto) {
        MessageBody message = new MessageBody();
        message.setOpType(GoodsCounselNoticeTypeEnum.getOpType((Integer)dto.getNoticeType()).name());
        message.setData((Object)dto);
        this.producerService.msg(message);
    }

    public void send(CouponExclusiveEmailVO couponExclusiveEmailVO) {
        MessageBody message = new MessageBody();
        message.setOpType(NoticeTypeEnum.GMC_COUPON_EXCLUSIVE.name());
        message.setData((Object)couponExclusiveEmailVO);
        this.producerService.msg(message);
    }

    public void sendMarketConfigChangeMail(MarketingConfigChangeMailVO a) {
        String str = "";
        if (!Objects.equals(a.getChangeFlag(), "add")) {
            str = "\u53d6\u6d88";
        }
        MessageBody message = new MessageBody();
        if (MarketingConfigTypeEnum.RELATED.ordinal() == a.getType().intValue()) {
            a.setChangeFlagName(str + MarketingConfigTypeEnum.RELATED.getName());
            message.setOpType(NoticeTypeEnum.NOTIC_MATCH_CONF_CHANGE.name());
        } else if (MarketingConfigTypeEnum.PLATFORM.ordinal() == a.getType().intValue() || MarketingConfigTypeEnum.PLATFORM_STRATEGY.ordinal() == a.getType().intValue()) {
            a.setChangeFlagName(str + MarketingConfigTypeEnum.PLATFORM.getName());
            message.setOpType(NoticeTypeEnum.NOTIC_DPNDNT_CONF_CHANGE.name());
        }
        message.setData((Object)a);
        this.producerService.msg(message);
    }
}

