/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.support.upgrade.impl;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.gmc.constant.enums.GoodsCategoryEnum;
import com.digiwin.dap.middleware.gmc.domain.EnvProperties;
import com.digiwin.dap.middleware.gmc.domain.sellingstrategy.ApportionType;
import com.digiwin.dap.middleware.gmc.entity.AreaTaxRate;
import com.digiwin.dap.middleware.gmc.entity.Category;
import com.digiwin.dap.middleware.gmc.entity.Goods;
import com.digiwin.dap.middleware.gmc.entity.ItemTaxRate;
import com.digiwin.dap.middleware.gmc.entity.MultipleItem;
import com.digiwin.dap.middleware.gmc.entity.PaymentType;
import com.digiwin.dap.middleware.gmc.entity.Product;
import com.digiwin.dap.middleware.gmc.entity.SellingStrategy;
import com.digiwin.dap.middleware.gmc.repository.AreaTaxRateRepository;
import com.digiwin.dap.middleware.gmc.repository.CategoryRepository;
import com.digiwin.dap.middleware.gmc.repository.GoodsRepository;
import com.digiwin.dap.middleware.gmc.repository.ItemTaxRateRepository;
import com.digiwin.dap.middleware.gmc.repository.MultipleItemRepository;
import com.digiwin.dap.middleware.gmc.repository.PaymentTypeRepository;
import com.digiwin.dap.middleware.gmc.repository.ProductRepository;
import com.digiwin.dap.middleware.gmc.repository.SellingStrategyRepository;
import com.digiwin.dap.middleware.gmc.service.goods.AreaTaxRateService;
import com.digiwin.dap.middleware.gmc.service.goods.CategoryService;
import com.digiwin.dap.middleware.gmc.service.goods.GoodsCrudService;
import com.digiwin.dap.middleware.gmc.service.goods.MultipleItemCrudService;
import com.digiwin.dap.middleware.gmc.service.goods.PaymentTypeService;
import com.digiwin.dap.middleware.gmc.service.goods.ProductCrudService;
import com.digiwin.dap.middleware.gmc.service.goods.SellingStrategyCrudService;
import com.digiwin.dap.middleware.gmc.support.upgrade.UpgradeDatabase;
import com.digiwin.dap.middleware.util.JdbcUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UpgradeDatabaseImpl
implements UpgradeDatabase {
    @Autowired
    AreaTaxRateService areaTaxRateService;
    @Autowired
    AreaTaxRateRepository areaTaxRateRepository;
    @Autowired
    CategoryService categoryService;
    @Autowired
    CategoryRepository categoryRepository;
    @Autowired
    GoodsRepository goodsRepository;
    @Autowired
    GoodsCrudService goodsCrudService;
    @Autowired
    PaymentTypeService paymentTypeService;
    @Autowired
    PaymentTypeRepository paymentTypeRepository;
    @Autowired
    private ProductCrudService productCrudService;
    @Autowired
    private ProductRepository productRepository;
    @Autowired
    SellingStrategyRepository sellingStrategyRepository;
    @Autowired
    SellingStrategyCrudService sellingStrategyCrudService;
    @Autowired
    MultipleItemCrudService multipleItemCrudService;
    @Autowired
    MultipleItemRepository multipleItemRepository;
    @Autowired
    ItemTaxRateRepository itemTaxRateRepository;
    @Autowired
    EnvProperties envProperties;

    public void upgradeAreaTaxRate(JdbcUtils jdbcOld) throws Exception {
        String areaTaxRateSql = "SELECT CategoryId as categoryid, TaxRate as taxrate, Area as area FROM mall_areataxrate";
        List areaTaxRates = jdbcOld.findMoreRefResult(areaTaxRateSql, null, AreaTaxRate.class);
        for (AreaTaxRate areaTaxRate : areaTaxRates) {
            Boolean exists = this.areaTaxRateRepository.existsByAreaAndCategoryId(areaTaxRate.getArea(), areaTaxRate.getCategoryId());
            if (exists.booleanValue()) continue;
            this.areaTaxRateService.create((BaseEntity)areaTaxRate);
        }
    }

    public void upgradeCategory(JdbcUtils jdbcOld) throws Exception {
        String categorySql = "SELECT Code as code, Name as name FROM mall_goodscategory";
        List categories = jdbcOld.findMoreRefResult(categorySql, null, Category.class);
        for (Category category : categories) {
            boolean exists = this.categoryRepository.existsByCode(category.getCode());
            if (exists) continue;
            this.categoryService.create((BaseEntity)category);
        }
    }

    public void upgradeGoods(JdbcUtils jdbcOld) throws Exception {
        this.goodsChangeColumnType(jdbcOld);
        String goodsSql = "SELECT id as sid, Code as code, ItemId as itemid, UserNumberCode as usernumbercode, DisplayName as displayname, LogoImage as logoimage, CatoryId as categoryid, ProductCode as productcode, WhetherTax as whethertax, Description as description, DetailDescription as detaildescription, OnSale as onsale, IsInitialize as isinitialize, CloudWebsite as cloudwebsite, PaymentType as paymenttype, SalesArea as salesarea, Version as version, Modules as modules, CustomAttributes as customattributes, Remark as remark, CreateTime as create_date, CreateUser as create_by_id, EditTime as modify_date, EditUser as modify_by_id, SortNumber as sortnumber, PurchasePrice as purchaseprice FROM mall_cloudgoods";
        List goodsList = jdbcOld.findMoreRefResult(goodsSql, null, Goods.class);
        for (Goods goods : goodsList) {
            boolean exists = this.goodsRepository.existsByCode(goods.getCode());
            if (exists) continue;
            this.goodsRepository.save((Object)goods);
        }
    }

    public void upgradePaymentType(JdbcUtils jdbcOld) throws Exception {
        String paymentTypeSql = "SELECT id, name, categoryId as categoryid FROM mall_paymenttype";
        List paymentTypes = jdbcOld.findMoreRefResult(paymentTypeSql, null, PaymentType.class);
        if (paymentTypes.size() > 0) {
            for (PaymentType paymentType : paymentTypes) {
                boolean exists = this.paymentTypeRepository.existsByCategoryIdAndId(paymentType.getCategoryId(), paymentType.getId().intValue());
                if (exists) continue;
                this.paymentTypeService.create((BaseEntity)paymentType);
            }
            this.createPaymentType(GoodsCategoryEnum.APP.id(), 4, "\u6708");
            this.createPaymentType(GoodsCategoryEnum.COURSE.id(), 0, "\u8282/\u4eba");
            if ("TW".equals(this.envProperties.getArea())) {
                this.paymentTypeRepository.updateName("\u9031", "\u5468");
                this.paymentTypeRepository.updateName("\u96d9\u9031", "\u53cc\u5468");
                this.paymentTypeRepository.updateName("\u6642", "\u65f6");
                this.paymentTypeRepository.updateName("\u7bc0/\u4eba", "\u8282/\u4eba");
            }
        }
    }

    public void upgradeProduct(JdbcUtils jdbcOld) throws Exception {
        String productSql = "SELECT ProductCode as productcode, ProductCategory as productcategory, ProductType as producttype, ProductName as productname FROM mars_product";
        List products = jdbcOld.findMoreRefResult(productSql, null, Product.class);
        for (Product product : products) {
            boolean exists = this.productRepository.existsByProductCode(product.getProductCode());
            if (exists) continue;
            this.productCrudService.create((BaseEntity)product);
        }
    }

    public void upgradeSellingStrategy(JdbcUtils jdbcOld) throws Exception {
        this.sellingStrategyChangeColumnType(jdbcOld);
        String sellingStrategySql = "SELECT id as sid, Code as code, GoodsCode as goodscode, Name as name, Description as description, IsEnable as isenable, IsMainPush as ismainpush, UsersNumber as usersnumber, MaxUsersNumber as maxusersnumber, IsLimitUsersNumber as islimitusersnumber, Bata as beta, UseCount as usecount, TenancyPeriod as tenancyperiod, Price as price, PurchasePrice as purchaseprice, PromotionPrice as promotionprice, EnabledModules as enabledmodules, CustomAttributes as customattributes, TrialDays as trialdays, SortNumber as sortnumber, CreateTime as create_date, CreateUser as create_by_id, EditTime as modify_date, EditUser as modify_by_id, IsExperienceScheme as isexperiencescheme, LimitPurchaseQuantity as limitpurchasequantity FROM mall_sellingstrategy";
        List sellingStrategies = jdbcOld.findMoreRefResult(sellingStrategySql, null, SellingStrategy.class);
        for (SellingStrategy sellingStrategy : sellingStrategies) {
            boolean exists = this.sellingStrategyRepository.existsByCode(sellingStrategy.getCode());
            if (exists) continue;
            this.sellingStrategyRepository.save((Object)sellingStrategy);
        }
    }

    public void upgradeMultipleItem() {
        List goodsList = this.goodsRepository.findAll();
        goodsList.forEach(goods -> {
            List sellingStrategies = this.sellingStrategyRepository.findAllByGoodsCode(goods.getCode());
            sellingStrategies.forEach(sellingStrategy -> {
                if (!this.multipleItemRepository.existsByItemCodeAndSellingStrategySid(goods.getItemId(), sellingStrategy.getSid()).booleanValue()) {
                    MultipleItem multipleItem = new MultipleItem();
                    multipleItem.setSellingStrategySid(Long.valueOf(sellingStrategy.getSid()));
                    multipleItem.setPreset(Boolean.valueOf(true));
                    multipleItem.setUnit("\u5355\u4f4d");
                    multipleItem.setQuantity(Integer.valueOf(1));
                    multipleItem.setStandardPrice(sellingStrategy.getPrice());
                    multipleItem.setOriginalPrice(new BigDecimal(0));
                    multipleItem.setContractPrice(sellingStrategy.getPromotionPrice());
                    multipleItem.setItemName(goods.getDisplayName());
                    multipleItem.setItemCode(goods.getItemId());
                    multipleItem.setApportionType(ApportionType.VARIABLECOST);
                    this.multipleItemCrudService.create((BaseEntity)multipleItem);
                }
            });
        });
    }

    public void upgradeMultipleItemTaxRate() {
        ArrayList<ItemTaxRate> itemTaxRates = new ArrayList<ItemTaxRate>();
        itemTaxRates.add(new ItemTaxRate().generateItemTaxRate("1", 13));
        itemTaxRates.add(new ItemTaxRate().generateItemTaxRate("Y", 13));
        itemTaxRates.add(new ItemTaxRate().generateItemTaxRate("YT", 6));
        itemTaxRates.add(new ItemTaxRate().generateItemTaxRate("YS", 13));
        itemTaxRates.add(new ItemTaxRate().generateItemTaxRate("YH", 13));
        itemTaxRates.add(new ItemTaxRate().generateItemTaxRate("3", 6));
        itemTaxRates.add(new ItemTaxRate().generateItemTaxRate("4", 6));
        itemTaxRates.add(new ItemTaxRate().generateItemTaxRate("5", 6));
        itemTaxRates.add(new ItemTaxRate().generateItemTaxRate("6", 6));
        itemTaxRates.add(new ItemTaxRate().generateItemTaxRate("7", 6));
        itemTaxRates.add(new ItemTaxRate().generateItemTaxRate("8", 6));
        this.itemTaxRateRepository.saveAll(itemTaxRates);
    }

    private void createPaymentType(String categoryId, int id, String name) {
        boolean exists = this.paymentTypeRepository.existsByCategoryIdAndId(categoryId, id);
        if (!exists) {
            PaymentType paymentType = new PaymentType();
            paymentType.setCategoryId(categoryId);
            paymentType.setId(Integer.valueOf(id));
            paymentType.setName(name);
            this.paymentTypeService.create((BaseEntity)paymentType);
        }
    }

    private void goodsChangeColumnType(JdbcUtils jdbcOld) throws Exception {
        String alterSql = "alter table mall_cloudgoods modify column PurchasePrice decimal(12,2) NULL DEFAULT NULL COMMENT '\u52a0\u8d2d\u5355\u4ef7';";
        jdbcOld.updateByPreparedStatement(alterSql, null);
        alterSql = "alter table mall_cloudgoods modify column IsInitialize TINYINT(1) NOT NULL DEFAULT '0' COMMENT '\u662f\u5426\u521d\u59cb\u5316';";
        jdbcOld.updateByPreparedStatement(alterSql, null);
        alterSql = "alter table mall_cloudgoods modify column WhetherTax TINYINT(1) NULL DEFAULT '1' COMMENT '\u662f\u5426\u542b\u7a0e';";
        jdbcOld.updateByPreparedStatement(alterSql, null);
    }

    private void sellingStrategyChangeColumnType(JdbcUtils jdbcOld) throws Exception {
        String alterSql = "alter table mall_sellingstrategy modify column IsEnable TINYINT(1) NOT NULL DEFAULT '0' COMMENT '\u662f\u5426\u542f\u7528';";
        jdbcOld.updateByPreparedStatement(alterSql, null);
        alterSql = "alter table mall_sellingstrategy modify column IsMainPush TINYINT(1) NOT NULL DEFAULT '0' COMMENT '\u662f\u5426\u662f\u4e3b\u63a8';";
        jdbcOld.updateByPreparedStatement(alterSql, null);
        alterSql = "alter table mall_sellingstrategy modify column IsLimitUsersNumber TINYINT(1) NOT NULL DEFAULT '0' COMMENT '\u662f\u5426\u9650\u503c\u7528\u6237\u6570';";
        jdbcOld.updateByPreparedStatement(alterSql, null);
        alterSql = "alter table mall_sellingstrategy modify column IsExperienceScheme TINYINT(1) NOT NULL DEFAULT '0' COMMENT '\u662f\u5426\u4f53\u9a8c\u65b9\u6848';";
        jdbcOld.updateByPreparedStatement(alterSql, null);
        alterSql = "alter table mall_sellingstrategy modify column Bata TINYINT(1) NOT NULL DEFAULT '1' COMMENT '\u5373\u5c06\u4e0a\u67b6';";
        jdbcOld.updateByPreparedStatement(alterSql, null);
    }
}

