/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.support.upgrade.impl;

import com.digiwin.dap.middleware.gmc.constant.enums.CommonParamTypeEnum;
import com.digiwin.dap.middleware.gmc.entity.CommonParam;
import com.digiwin.dap.middleware.gmc.entity.Product;
import com.digiwin.dap.middleware.gmc.repository.CommonParamRepository;
import com.digiwin.dap.middleware.gmc.repository.ProductRepository;
import com.digiwin.dap.middleware.gmc.support.remote.IamService;
import com.digiwin.dap.middleware.service.impl.AbstractUpdateDatabaseService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Order(value=41800)
@Service
public class UpgradeDatabaseV417ToV418Service
extends AbstractUpdateDatabaseService {
    private static final Logger logger = LoggerFactory.getLogger(UpgradeDatabaseV417ToV418Service.class);
    @Autowired
    private ProductRepository productRepository;
    @Autowired
    private CommonParamRepository commonParamRepository;
    @Autowired
    private IamService iamService;

    public String version() {
        return "4.18.0.0";
    }

    @Transactional(rollbackFor={Exception.class})
    public void update() {
        List allCommonParams = this.commonParamRepository.findAll();
        ArrayList allCommonParamIds = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)allCommonParams)) {
            allCommonParamIds.addAll(allCommonParams.stream().map(CommonParam::getId).collect(Collectors.toList()));
        }
        this.updateCommonParam4product(allCommonParamIds);
        this.updateCommonParam4Team(allCommonParamIds);
    }

    public void updateCommonParam4product(List<String> allCommonParams) {
        logger.info("4.18\u516c\u5171\u53c2\u6570\u5546\u54c1\u6570\u636e\u5347\u7ea7\u5f00\u59cb: {}", (Object)LocalDateTime.now());
        try {
            List products = this.productRepository.findAllByOrderByProductCode();
            ArrayList<CommonParam> commonParamList = new ArrayList<CommonParam>();
            if (!CollectionUtils.isEmpty((Collection)products)) {
                for (Product product : products) {
                    if (allCommonParams.contains(product.getProductCode())) continue;
                    CommonParam commonParam = new CommonParam();
                    BeanUtils.copyProperties((Object)product, (Object)commonParam);
                    commonParam.setId(product.getProductCode());
                    commonParam.setName(product.getProductName());
                    commonParam.setType(CommonParamTypeEnum.GOODS.getValue());
                    commonParamList.add(commonParam);
                }
            }
            this.commonParamRepository.saveAll(commonParamList);
            logger.info("4.18\u516c\u5171\u53c2\u6570\u5546\u54c1\u6570\u636e\u5347\u7ea7\u7ed3\u675f: \u6570\u91cf {}, {}", (Object)commonParamList.size(), (Object)LocalDateTime.now());
        }
        catch (Exception e) {
            logger.error("4.18\u516c\u5171\u53c2\u6570\u5546\u54c1\u6570\u636e\u5347\u7ea7\u5931\u8d25");
        }
    }

    public void updateCommonParam4Team(List<String> allCommonParams) {
        logger.info("4.18\u516c\u5171\u53c2\u6570\u56e2\u961f\u6570\u636e\u5347\u7ea7\u5f00\u59cb: {}", (Object)LocalDateTime.now());
        try {
            List commonParamList = this.iamService.getTeamInfo();
            if (!CollectionUtils.isEmpty((Collection)commonParamList)) {
                for (CommonParam commonParam : commonParamList) {
                    if (allCommonParams.contains(commonParam.getId())) continue;
                    commonParam.setType(CommonParamTypeEnum.TEAM.getValue());
                }
            }
            this.commonParamRepository.saveAll((Iterable)commonParamList);
            logger.info("4.18\u516c\u5171\u53c2\u6570\u56e2\u961f\u6570\u636e\u5347\u7ea7\u7ed3\u675f: \u6570\u91cf {}, {}", (Object)commonParamList.size(), (Object)LocalDateTime.now());
        }
        catch (Exception e) {
            logger.error("4.18\u516c\u5171\u53c2\u6570\u56e2\u961f\u6570\u636e\u5347\u7ea7\u5931\u8d25");
        }
    }
}

