/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.support.upgrade.impl;

import com.digiwin.dap.middleware.commons.util.StrUtils;
import com.digiwin.dap.middleware.dict.constant.enums.DictEnum;
import com.digiwin.dap.middleware.dict.entity.Dict;
import com.digiwin.dap.middleware.dict.entity.DictData;
import com.digiwin.dap.middleware.dict.service.DictDataService;
import com.digiwin.dap.middleware.dict.service.DictService;
import com.digiwin.dap.middleware.gmc.entity.CommonParam;
import com.digiwin.dap.middleware.gmc.repository.CommonParamRepository;
import com.digiwin.dap.middleware.service.impl.AbstractUpdateDatabaseService;
import com.digiwin.dap.middleware.util.JsonUtils;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Order(value=42000)
@Service
public class UpgradeDatabaseV419ToV420Service
extends AbstractUpdateDatabaseService {
    private static final Logger logger = LoggerFactory.getLogger(UpgradeDatabaseV419ToV420Service.class);
    @Autowired
    private CommonParamRepository commonParamRepository;
    @Autowired
    private DictService dictService;
    @Autowired
    private DictDataService dictDataService;
    private static final String GOODS = DictEnum.GOODS.getId();
    private static final String TEAM = DictEnum.TEAM.getId();
    private static final String COMPANY = DictEnum.COMPANY.getId();
    private static final String TRIAL_SOURCE = DictEnum.TRIAL_SOURCE.getId();

    public String version() {
        return "4.20.0.0";
    }

    @Transactional(rollbackFor={Exception.class})
    public void update() {
        logger.info("4.20\u516c\u5171\u53c2\u6570\u5546\u54c1\u6570\u636e\u5347\u7ea7\u5f00\u59cb: {}", (Object)LocalDateTime.now());
        this.updateDict();
        this.updateDictData();
        logger.info("4.20\u516c\u5171\u53c2\u6570\u5546\u54c1\u6570\u636e\u5347\u7ea7\u7ed3\u675f: {}", (Object)LocalDateTime.now());
    }

    private void updateDictData() {
        List allCommonParams = this.commonParamRepository.findAll();
        logger.info("allCommonParams.size() = {}", (Object)allCommonParams.size());
        List dictDataList = this.dictDataService.selectDictDataList(null);
        logger.info("dictDataList.size() = {}", (Object)dictDataList.size());
        Map dictDataMap = dictDataList.stream().collect(Collectors.groupingBy(DictData::getDictId, Collectors.mapping(DictData::getDictKey, Collectors.toList())));
        for (CommonParam commonParam : allCommonParams) {
            DictData data;
            if (GOODS.equals(commonParam.getType())) {
                if (Optional.ofNullable(dictDataMap.get(GOODS)).orElse(Collections.emptyList()).contains(commonParam.getId())) continue;
                data = new DictData();
                data.setDictId(GOODS);
                data.setDictKey(commonParam.getId());
                data.setDictValue(Optional.ofNullable(commonParam.getName()).filter(x -> !StrUtils.isEmpty((String)commonParam.getName())).orElse(commonParam.getProductCategory()));
                data.setRemark(commonParam.getRemark());
                data.setCreateDate(commonParam.getCreateDate());
                data.setCreateById(commonParam.getCreateById());
                this.dictDataService.insertDictData(data);
                continue;
            }
            if (TEAM.equals(commonParam.getType())) {
                if (Optional.ofNullable(dictDataMap.get(TEAM)).orElse(Collections.emptyList()).contains(commonParam.getId())) continue;
                data = new DictData();
                data.setDictId(TEAM);
                data.setDictKey(commonParam.getId());
                data.setDictValue(commonParam.getName());
                data.setRemark(commonParam.getRemark());
                data.setCreateDate(commonParam.getCreateDate());
                data.setCreateById(commonParam.getCreateById());
                this.dictDataService.insertDictData(data);
                continue;
            }
            if (COMPANY.equals(commonParam.getType())) {
                if (Optional.ofNullable(dictDataMap.get(COMPANY)).orElse(Collections.emptyList()).contains(commonParam.getId())) continue;
                data = new DictData();
                data.setDictId(COMPANY);
                data.setDictKey(commonParam.getId());
                data.setDictValue(commonParam.getName());
                data.setRemark(commonParam.getRemark());
                data.setCreateDate(commonParam.getCreateDate());
                data.setCreateById(commonParam.getCreateById());
                this.dictDataService.insertDictData(data);
                continue;
            }
            logger.error("\u672a\u77e5\u7684\u65e7\u6570\u636e\u7c7b\u578b\u8fc1\u79fb {}", (Object)JsonUtils.objToJson((Object)commonParam));
        }
    }

    private void updateDict() {
        Dict dict;
        List dictList = this.dictService.selectDictList(null);
        List dictIdList = dictList.stream().map(Dict::getId).collect(Collectors.toList());
        logger.info("dictIdList = {}", dictIdList);
        if (!dictIdList.contains(GOODS)) {
            dict = new Dict();
            dict.setId(GOODS);
            dict.setName("\u5546\u54c1\u7c7b\u522b");
            dict.setRemark("\u5546\u54c1\u7c7b\u522b\u7ef4\u62a4");
            this.dictService.insertDict(dict);
        }
        if (!dictIdList.contains(COMPANY)) {
            dict = new Dict();
            dict.setId(COMPANY);
            dict.setName("\u516c\u53f8\u522b");
            dict.setRemark("\u7528\u4e8e\u548c\u8d44\u7ba1\u5bf9\u63a5\u7684\u516c\u53f8\u522b\u7ef4\u62a4");
            this.dictService.insertDict(dict);
        }
        if (!dictIdList.contains(TEAM)) {
            dict = new Dict();
            dict.setId(TEAM);
            dict.setName("\u56e2\u961f\u7c7b\u578b");
            dict.setRemark("\u79df\u6237\u7684\u56e2\u961f\u7c7b\u578b");
            this.dictService.insertDict(dict);
        }
        if (!dictIdList.contains(TRIAL_SOURCE)) {
            dict = new Dict();
            dict.setId(TRIAL_SOURCE);
            dict.setName("\u8bd5\u7528\u6765\u6e90");
            dict.setRemark("\u5546\u54c1\u7684\u8bd5\u7528\u6765\u6e90\uff0c\u5982\u4f55\u5f97\u77e5\u8bd5\u7528\u4fe1\u606f");
            this.dictService.insertDict(dict);
        }
    }
}

