/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.support.upgrade.impl;

import com.digiwin.dap.middleware.dict.constant.enums.DictEnum;
import com.digiwin.dap.middleware.dict.domain.DictDataDTO;
import com.digiwin.dap.middleware.dict.entity.Dict;
import com.digiwin.dap.middleware.dict.entity.DictData;
import com.digiwin.dap.middleware.dict.service.DictDataService;
import com.digiwin.dap.middleware.dict.service.DictService;
import com.digiwin.dap.middleware.service.impl.AbstractUpdateDatabaseService;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Order(value=42600)
@Service
public class UpgradeDatabaseV425ToV426Service
extends AbstractUpdateDatabaseService {
    private static final Logger logger = LoggerFactory.getLogger(UpgradeDatabaseV425ToV426Service.class);
    @Autowired
    private DictService dictService;
    @Autowired
    private DictDataService dictDataService;
    private static final String PLATFORM = DictEnum.PLATFORM.getId();

    public String version() {
        return "4.26.0.0";
    }

    @Transactional(rollbackFor={Exception.class})
    public void update() {
        logger.info("4.26\u516c\u5171\u53c2\u6570\u5e73\u53f0\u7c7b\u578b\u5347\u7ea7\u5f00\u59cb: {}", (Object)LocalDateTime.now());
        this.updateDict();
        this.updateDictData();
        logger.info("4.26\u516c\u5171\u53c2\u6570\u5e73\u53f0\u7c7b\u578b\u5347\u7ea7\u7ed3\u675f: {}", (Object)LocalDateTime.now());
    }

    private void updateDict() {
        List dictList = this.dictService.selectDictList(null);
        List dictIdList = dictList.stream().map(Dict::getId).collect(Collectors.toList());
        logger.info("dictIdList = {}", dictIdList);
        if (!dictIdList.contains(PLATFORM)) {
            Dict dict = new Dict();
            dict.setId(PLATFORM);
            dict.setName(DictEnum.PLATFORM.getName());
            dict.setRemark(DictEnum.getDescribe((String)PLATFORM));
            this.dictService.insertDict(dict);
        }
    }

    private void updateDictData() {
        DictDataDTO dictDataDTO = new DictDataDTO(PLATFORM, null);
        List dictDataList = this.dictDataService.selectDictDataList(dictDataDTO);
        logger.info("dictDataList.size() = {}", (Object)dictDataList.size());
        List dictDatas = dictDataList.stream().map(DictData::getDictKey).collect(Collectors.toList());
        if (!dictDatas.contains("1")) {
            DictData data = new DictData();
            data.setDictId(PLATFORM);
            data.setDictKey("1");
            data.setDictValue("\u4e0a\u6c7d\u5e73\u53f0");
            data.setRemark("\u4e0a\u6c7d\u5e73\u53f0");
            this.dictDataService.insertDictData(data);
        } else if (!dictDatas.contains("2")) {
            DictData data = new DictData();
            data.setDictId(PLATFORM);
            data.setDictKey("2");
            data.setDictValue("\u534e\u4e3a\u5e73\u53f0");
            data.setRemark("\u534e\u4e3a\u5e73\u53f0");
            this.dictDataService.insertDictData(data);
        }
    }
}

