/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.support.upgrade.impl;

import com.digiwin.dap.middleware.gmc.entity.ItemTaxRate;
import com.digiwin.dap.middleware.gmc.repository.ItemTaxRateRepository;
import com.digiwin.dap.middleware.service.impl.AbstractUpdateDatabaseService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Order(value=42900)
@Service
public class UpgradeDatabaseV428ToV429Service
extends AbstractUpdateDatabaseService {
    private static final Logger logger = LoggerFactory.getLogger(UpgradeDatabaseV428ToV429Service.class);
    @Autowired
    private ItemTaxRateRepository itemTaxRateRepository;

    public String version() {
        return "4.29.0.0";
    }

    @Transactional(rollbackFor={Exception.class})
    public void update() {
        logger.info("4.28gmc\u5347\u7ea7\u5f00\u59cb: {}", (Object)LocalDateTime.now());
        this.newTaxRate();
        logger.info("4.28gmc\u5347\u7ea7\u7ed3\u675f: {}", (Object)LocalDateTime.now());
    }

    private void newTaxRate() {
        HashMap<Integer, List<String>> map = new HashMap<Integer, List<String>>();
        map.put(6, Arrays.asList("S1", "S2", "H1", "H2", "T0", "T1", "T2"));
        map.put(13, Arrays.asList("S0", "H0"));
        ArrayList<ItemTaxRate> toAdd = new ArrayList<ItemTaxRate>();
        for (Map.Entry entry : map.entrySet()) {
            for (String items : (List)entry.getValue()) {
                ItemTaxRate itemTaxRate = new ItemTaxRate();
                itemTaxRate.generateItemTaxRate(items, ((Integer)entry.getKey()).intValue());
                toAdd.add(itemTaxRate);
            }
        }
        this.itemTaxRateRepository.saveAll(toAdd);
    }
}

