/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.support.upgrade.impl;

import com.digiwin.dap.middleware.gmc.entity.Goods;
import com.digiwin.dap.middleware.gmc.entity.GoodsOnPlatform;
import com.digiwin.dap.middleware.gmc.repository.GoodsOnPlatformRepository;
import com.digiwin.dap.middleware.gmc.repository.GoodsRepository;
import com.digiwin.dap.middleware.service.impl.AbstractUpdateDatabaseService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Order(value=43200)
@Service
public class UpgradeDatabaseV431ToV432Service
extends AbstractUpdateDatabaseService {
    private static final Logger logger = LoggerFactory.getLogger(UpgradeDatabaseV431ToV432Service.class);
    @Autowired
    private GoodsOnPlatformRepository goodsOnPlatformRepository;
    @Autowired
    private GoodsRepository goodsRepository;

    public String version() {
        return "4.32.0.0";
    }

    @Transactional(rollbackFor={Exception.class})
    public void update() {
        logger.info("4.31gmc\u5347\u7ea7\u5f00\u59cb: {}", (Object)LocalDateTime.now());
        this.upgradeShowConsole4LCDP();
        logger.info("4.31gmc\u5347\u7ea7\u7ed3\u675f: {}", (Object)LocalDateTime.now());
    }

    private void upgradeShowConsole4LCDP() {
        ArrayList<Goods> update = new ArrayList<Goods>();
        for (GoodsOnPlatform goodsOnPlatform : this.goodsOnPlatformRepository.findByPlatformCode("athena-lcdp")) {
            Goods goods = this.goodsRepository.findByCode(goodsOnPlatform.getCode());
            if (goods == null || !Boolean.TRUE.equals(goods.getShowConsole())) continue;
            update.add(goods);
            goods.setShowConsole(Boolean.valueOf(false));
        }
        this.goodsRepository.saveAll(update);
    }
}

