/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.support.upgrade.impl;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.gmc.domain.EnvProperties;
import com.digiwin.dap.middleware.gmc.entity.Category;
import com.digiwin.dap.middleware.gmc.entity.PaymentType;
import com.digiwin.dap.middleware.gmc.repository.CategoryRepository;
import com.digiwin.dap.middleware.gmc.repository.PaymentTypeRepository;
import com.digiwin.dap.middleware.service.impl.AbstractUpdateDatabaseService;
import com.digiwin.dap.middleware.util.EntityUtils;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Order(value=43604)
@Service
public class UpgradeDatabaseV43604ToV43605Service
extends AbstractUpdateDatabaseService {
    private static final Logger logger = LoggerFactory.getLogger(UpgradeDatabaseV43604ToV43605Service.class);
    @Autowired
    private CategoryRepository categoryRepository;
    @Autowired
    private PaymentTypeRepository paymentTypeRepository;
    @Autowired
    private EnvProperties envProperties;

    public String version() {
        return "4.36.4.0";
    }

    @Transactional(rollbackFor={Exception.class})
    public void update() {
        List bundle1;
        logger.info("4.36.4.0gmc\u5347\u7ea7\u5f00\u59cb: {}", (Object)LocalDateTime.now());
        Category bundle = this.categoryRepository.findByCode("bundle");
        if (bundle == null) {
            bundle = new Category();
            bundle.setCode("bundle");
            if (Locale.TRADITIONAL_CHINESE.getCountry().equalsIgnoreCase(this.envProperties.getArea())) {
                bundle.setName("\u9589\u74b0\u5546\u54c1");
            } else {
                bundle.setName("\u95ed\u73af\u5546\u54c1");
            }
            this.categoryRepository.save((Object)bundle);
        }
        if ((bundle1 = this.paymentTypeRepository.findAllByCategoryId("bundle")).isEmpty()) {
            List app = this.paymentTypeRepository.findAllByCategoryId("app");
            List bundles = app.stream().map(a -> {
                PaymentType paymentType = new PaymentType();
                paymentType.setName(a.getName());
                paymentType.setId(a.getId());
                paymentType.setCategoryId("bundle");
                EntityUtils.setCreateFields((BaseEntity)paymentType);
                EntityUtils.setModifyFields((BaseEntity)paymentType);
                return paymentType;
            }).collect(Collectors.toList());
            this.paymentTypeRepository.saveAll(bundles);
        }
        logger.info("4.36.4.0gmc\u5347\u7ea7\u7ed3\u675f: {}", (Object)LocalDateTime.now());
    }
}

