/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.support.upgrade.impl;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.gmc.domain.goods.GoodsAttributes;
import com.digiwin.dap.middleware.gmc.domain.goods.TrialButton;
import com.digiwin.dap.middleware.gmc.entity.PaymentType;
import com.digiwin.dap.middleware.gmc.repository.GoodsRepository;
import com.digiwin.dap.middleware.gmc.repository.PaymentTypeRepository;
import com.digiwin.dap.middleware.service.impl.AbstractUpdateDatabaseService;
import com.digiwin.dap.middleware.util.EntityUtils;
import com.digiwin.dap.middleware.util.JsonUtils;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Order(value=43608)
@Service
public class UpgradeDatabaseV43607ToV43608Service
extends AbstractUpdateDatabaseService {
    private static final Logger logger = LoggerFactory.getLogger(UpgradeDatabaseV43607ToV43608Service.class);
    @Autowired
    private PaymentTypeRepository paymentTypeRepository;
    @Autowired
    private GoodsRepository goodsRepository;

    public String version() {
        return "4.36.8.0";
    }

    public void update() {
        logger.info("4.36.8.0gmc\u5347\u7ea7\u5f00\u59cb: {}", (Object)LocalDateTime.now());
        this.saveCourse();
        this.changeTrialButtonStorage();
        logger.info("4.36.8.0gmc\u5347\u7ea7\u7ed3\u675f: {}", (Object)LocalDateTime.now());
    }

    private void changeTrialButtonStorage() {
        List sids = this.jdbcTemplate.queryForList("select sid from goods where app_trial_url is not null", Long.class);
        if (!CollectionUtils.isEmpty((Collection)sids)) {
            for (Long sid : sids) {
                Optional byId = this.goodsRepository.findById((Object)sid);
                byId.ifPresent(a -> {
                    GoodsAttributes goodsAttributes = new GoodsAttributes();
                    TrialButton trialButton = new TrialButton();
                    trialButton.setUrl(a.getAppTrialUrl());
                    trialButton.setName(a.getAppTrialButton());
                    goodsAttributes.setTrial(Collections.singletonList(trialButton));
                    a.setGoodsAttributes(JsonUtils.objToJson((Object)goodsAttributes));
                    this.goodsRepository.save(a);
                });
            }
        }
    }

    private void saveCourse() {
        if (!this.paymentTypeRepository.existsByCategoryIdAndId("course", 1)) {
            PaymentType paymentType = new PaymentType();
            paymentType.setCategoryId("course");
            paymentType.setName("\u81ea\u8a02\u55ae\u4f4d");
            paymentType.setId(Integer.valueOf(1));
            EntityUtils.setCreateFields((BaseEntity)paymentType);
            this.paymentTypeRepository.save((Object)paymentType);
        }
    }
}

