/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.support.upgrade.impl;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.gmc.domain.EnvProperties;
import com.digiwin.dap.middleware.gmc.entity.Category;
import com.digiwin.dap.middleware.gmc.entity.PaymentType;
import com.digiwin.dap.middleware.gmc.repository.CategoryRepository;
import com.digiwin.dap.middleware.gmc.repository.PaymentTypeRepository;
import com.digiwin.dap.middleware.service.impl.AbstractUpdateDatabaseService;
import com.digiwin.dap.middleware.util.EntityUtils;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Order(value=43612)
@Service
public class UpgradeDatabaseV43611ToV43612Service
extends AbstractUpdateDatabaseService {
    private static final Logger logger = LoggerFactory.getLogger(UpgradeDatabaseV43611ToV43612Service.class);
    @Autowired
    private CategoryRepository categoryRepository;
    @Autowired
    private PaymentTypeRepository paymentTypeRepository;
    @Autowired
    private EnvProperties envProperties;

    public String version() {
        return "4.36.12.0";
    }

    public void update() {
        List api1;
        logger.info("4.36.12.0gmc\u5347\u7ea7\u5f00\u59cb: {}", (Object)LocalDateTime.now());
        Category api = this.categoryRepository.findByCode("api");
        if (api == null) {
            api = new Category();
            api.setCode("api");
            api.setName("API");
            this.categoryRepository.save((Object)api);
        }
        if ((api1 = this.paymentTypeRepository.findAllByCategoryId("api")).isEmpty()) {
            List app = this.paymentTypeRepository.findAllByCategoryId("app");
            List apis = app.stream().filter(a -> a.getId() == 0 || a.getId() == 3).map(a -> {
                PaymentType paymentType = new PaymentType();
                paymentType.setName(a.getName());
                paymentType.setId(a.getId());
                paymentType.setCategoryId("api");
                EntityUtils.setCreateFields((BaseEntity)paymentType);
                EntityUtils.setModifyFields((BaseEntity)paymentType);
                return paymentType;
            }).collect(Collectors.toList());
            this.paymentTypeRepository.saveAll(apis);
        }
        logger.info("4.36.12.0gmc\u5347\u7ea7\u7ed3\u675f: {}", (Object)LocalDateTime.now());
    }
}

