/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.support.upgrade.impl;

import com.digiwin.dap.middleware.dict.domain.DictDataDTO;
import com.digiwin.dap.middleware.dict.entity.Dict;
import com.digiwin.dap.middleware.dict.entity.DictData;
import com.digiwin.dap.middleware.dict.service.DictDataService;
import com.digiwin.dap.middleware.dict.service.DictService;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.gmc.domain.EnvProperties;
import com.digiwin.dap.middleware.gmc.entity.Category;
import com.digiwin.dap.middleware.gmc.entity.PaymentType;
import com.digiwin.dap.middleware.gmc.repository.CategoryRepository;
import com.digiwin.dap.middleware.gmc.service.goods.PaymentTypeService;
import com.digiwin.dap.middleware.service.impl.AbstractUpdateDatabaseService;
import com.digiwin.dap.middleware.util.EntityUtils;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Order(value=43701)
@Service
public class UpgradeDatabaseV43612ToV43701Service
extends AbstractUpdateDatabaseService {
    private static final Logger logger = LoggerFactory.getLogger(UpgradeDatabaseV43612ToV43701Service.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private DictService dictService;
    @Autowired
    private DictDataService dictDataService;
    @Autowired
    private CategoryRepository categoryRepository;
    @Autowired
    private PaymentTypeService paymentTypeService;

    public String version() {
        return "4.37.1.0";
    }

    public void update() {
        this.goodsCategory();
        this.resourceCategory();
    }

    private void goodsCategory() {
        List paymentTypes;
        Category category = this.categoryRepository.findByCode("resource");
        if (category == null) {
            category = new Category();
            category.setCode("resource");
            category.setName("\u8ba1\u91cf\u5546\u54c1");
            this.categoryRepository.save((Object)category);
        }
        if ((paymentTypes = this.paymentTypeService.getPaymentTypeListByCategoryId("resource")).isEmpty()) {
            List app = this.paymentTypeService.getPaymentTypeListByCategoryId("app");
            app.stream().filter(a -> a.getId() == 0).forEach(a -> {
                PaymentType paymentType = new PaymentType();
                paymentType.setCategoryId("resource");
                paymentType.setId(a.getId());
                paymentType.setName("\u81ea\u5b9a\u5355\u4f4d");
                if (Locale.TRADITIONAL_CHINESE.getCountry().equalsIgnoreCase(this.envProperties.getArea())) {
                    paymentType.setName("\u81ea\u8a02\u55ae\u4f4d");
                }
                EntityUtils.setCreateFields((BaseEntity)paymentType);
                this.paymentTypeService.create((BaseEntity)paymentType);
            });
        }
    }

    public void resourceCategory() {
        DictData dictData;
        String category = "resourceCategory";
        List dictList = this.dictService.selectDictList(null);
        List dictIdList = dictList.stream().map(Dict::getId).collect(Collectors.toList());
        if (!dictIdList.contains(category)) {
            Dict dict = new Dict();
            dict.setId(category);
            dict.setName("\u8ba1\u91cf\u5206\u7c7b");
            dict.setRemark("\u8ba1\u91cf\u5206\u7c7b");
            if (Locale.TRADITIONAL_CHINESE.getCountry().equalsIgnoreCase(this.envProperties.getArea())) {
                dict.setName("\u8a08\u91cf\u5206\u985e");
                dict.setRemark("\u8a08\u91cf\u5206\u985e");
            }
            this.dictService.insertDict(dict);
        }
        DictDataDTO condition = new DictDataDTO();
        condition.setDictId(category);
        List dictDataList = this.dictDataService.selectDictDataList(condition);
        List keys = dictDataList.stream().map(DictData::getDictKey).collect(Collectors.toList());
        if (!keys.contains("count")) {
            dictData = new DictData();
            dictData.setDictId(category);
            dictData.setDictKey("count");
            dictData.setDictValue("\u6b21\u6570");
            if (Locale.TRADITIONAL_CHINESE.getCountry().equalsIgnoreCase(this.envProperties.getArea())) {
                dictData.setDictValue("\u6b21\u6578");
            }
            this.dictDataService.insertDictData(dictData);
        }
        if (!keys.contains("points")) {
            dictData = new DictData();
            dictData.setDictId(category);
            dictData.setDictKey("points");
            dictData.setDictValue("\u70b9\u6570");
            if (Locale.TRADITIONAL_CHINESE.getCountry().equalsIgnoreCase(this.envProperties.getArea())) {
                dictData.setDictValue("\u9ede\u6578");
            }
            this.dictDataService.insertDictData(dictData);
        }
        if (!keys.contains("cloudStorage")) {
            dictData = new DictData();
            dictData.setDictId(category);
            dictData.setDictKey("cloudStorage");
            dictData.setDictValue("\u4e91\u7aef\u7a7a\u95f4\u5bb9\u91cf");
            if (Locale.TRADITIONAL_CHINESE.getCountry().equalsIgnoreCase(this.envProperties.getArea())) {
                dictData.setDictValue("\u96f2\u7aef\u7a7a\u9593\u5bb9\u91cf");
            }
            this.dictDataService.insertDictData(dictData);
        }
        if (!keys.contains("dmcStorage")) {
            dictData = new DictData();
            dictData.setDictId(category);
            dictData.setDictKey("dmcStorage");
            dictData.setDictValue("\u6587\u6863\u4e2d\u5fc3\u5bb9\u91cf");
            if (Locale.TRADITIONAL_CHINESE.getCountry().equalsIgnoreCase(this.envProperties.getArea())) {
                dictData.setDictValue("\u6587\u6a94\u4e2d\u5fc3\u7a7a\u9593");
            }
            this.dictDataService.insertDictData(dictData);
        }
    }
}

