/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.support.upgrade.impl;

import com.digiwin.dap.middleware.dict.constant.enums.DictEnum;
import com.digiwin.dap.middleware.dict.domain.DictDataDTO;
import com.digiwin.dap.middleware.dict.entity.Dict;
import com.digiwin.dap.middleware.dict.entity.DictData;
import com.digiwin.dap.middleware.dict.service.DictDataService;
import com.digiwin.dap.middleware.dict.service.DictService;
import com.digiwin.dap.middleware.gmc.entity.GoodsOnPlatform;
import com.digiwin.dap.middleware.gmc.mapper.GoodsOnPlatformMapper;
import com.digiwin.dap.middleware.gmc.service.authoritysummary.AuthoritySummaryService;
import com.digiwin.dap.middleware.service.impl.AbstractUpdateDatabaseService;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Order(value=43702)
@Service
public class UpgradeDatabaseV43701ToV43702Service
extends AbstractUpdateDatabaseService {
    private static final Logger logger = LoggerFactory.getLogger(UpgradeDatabaseV43701ToV43702Service.class);
    private static final String PLATFORM = DictEnum.PLATFORM.getId();
    @Autowired
    private GoodsOnPlatformMapper goodsOnPlatformMapper;
    @Autowired
    private AuthoritySummaryService authoritySummaryService;
    @Autowired
    private DictDataService dictDataService;
    @Autowired
    private DictService dictService;

    public String version() {
        return "4.37.2.0";
    }

    public void update() {
        logger.info("4.37.2.0gmc\u5347\u7ea7\u5f00\u59cb: {}", (Object)LocalDateTime.now());
        this.authoritySummaryInit();
        this.updateDict();
        this.updateDictData();
        logger.info("4.37.2.0gmc\u5347\u7ea7\u7ed3\u675f: {}", (Object)LocalDateTime.now());
    }

    private void authoritySummaryInit() {
        List goodsOnPlatformList = this.goodsOnPlatformMapper.selectAllDisplayPlatform();
        if (CollectionUtils.isEmpty((Collection)goodsOnPlatformList)) {
            return;
        }
        Map goodsOnPlatformMap = goodsOnPlatformList.stream().collect(Collectors.groupingBy(GoodsOnPlatform::getPlatformCode, Collectors.mapping(GoodsOnPlatform::getCode, Collectors.toList())));
        goodsOnPlatformMap.forEach((platformCode, codeList) -> this.authoritySummaryService.saveAuthoritySummary(platformCode, codeList));
    }

    private void updateDictData() {
        DictDataDTO dictDataDTO = new DictDataDTO(PLATFORM, null);
        List dictDataList = this.dictDataService.selectDictDataList(dictDataDTO);
        logger.info("dictDataList.size() = {}", (Object)dictDataList.size());
        List dictDatas = dictDataList.stream().map(DictData::getDictKey).collect(Collectors.toList());
        if (!dictDatas.contains("5")) {
            DictData data = new DictData();
            data.setDictId(PLATFORM);
            data.setDictKey("5");
            data.setDictValue("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f");
            data.setRemark("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f");
            this.dictDataService.insertDictData(data);
        }
    }

    private void updateDict() {
        List dictList = this.dictService.selectDictList(null);
        List dictIdList = dictList.stream().map(Dict::getId).collect(Collectors.toList());
        logger.info("dictIdList = {}", dictIdList);
        if (!dictIdList.contains(PLATFORM)) {
            Dict dict = new Dict();
            dict.setId(PLATFORM);
            dict.setName(DictEnum.PLATFORM.getName());
            dict.setRemark(DictEnum.getDescribe((String)PLATFORM));
            this.dictService.insertDict(dict);
        }
    }
}

