/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.support.upgrade.impl;

import cn.hutool.core.map.CaseInsensitiveMap;
import com.digiwin.dap.middleware.dict.domain.DictDataDTO;
import com.digiwin.dap.middleware.dict.entity.DictData;
import com.digiwin.dap.middleware.dict.service.DictDataService;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.gmc.constant.enums.MarketingConfigTypeEnum;
import com.digiwin.dap.middleware.gmc.domain.EnvProperties;
import com.digiwin.dap.middleware.gmc.entity.AccessoryGoods;
import com.digiwin.dap.middleware.gmc.entity.Goods;
import com.digiwin.dap.middleware.gmc.entity.GoodsOnPlatform;
import com.digiwin.dap.middleware.gmc.entity.MarketingConfig;
import com.digiwin.dap.middleware.gmc.entity.Product;
import com.digiwin.dap.middleware.gmc.entity.SellingStrategy;
import com.digiwin.dap.middleware.gmc.repository.AccessoryGoodsRepository;
import com.digiwin.dap.middleware.gmc.repository.GoodsOnPlatformRepository;
import com.digiwin.dap.middleware.gmc.repository.GoodsRepository;
import com.digiwin.dap.middleware.gmc.repository.MarketingConfigRepository;
import com.digiwin.dap.middleware.gmc.repository.ProductRepository;
import com.digiwin.dap.middleware.gmc.repository.SellingStrategyRepository;
import com.digiwin.dap.middleware.service.impl.AbstractUpdateDatabaseService;
import com.digiwin.dap.middleware.util.EntityUtils;
import com.digiwin.dap.middleware.util.SnowFlake;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Order(value=43703)
@Service
public class UpgradeDatabaseV43702ToV43703Service
extends AbstractUpdateDatabaseService {
    private static final Logger logger = LoggerFactory.getLogger(UpgradeDatabaseV43702ToV43703Service.class);
    @Autowired
    private DictDataService dictDataService;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private ProductRepository productRepository;
    @Autowired
    private AccessoryGoodsRepository accessoryGoodsRepository;
    @Autowired
    private SellingStrategyRepository sellingStrategyRepository;
    @Autowired
    private MarketingConfigRepository marketingConfigRepository;
    @Autowired
    private GoodsOnPlatformRepository goodsOnPlatformRepository;
    @Autowired
    private GoodsRepository goodsRepository;

    public String version() {
        return "4.37.3.0";
    }

    public void update() {
        this.updateDictData();
        this.rollbackProductType();
        this.migrateAccessoryToMarketConfig();
    }

    private void migrateAccessoryToMarketConfig() {
        List allMarketConfig = this.marketingConfigRepository.findAll();
        List all = this.accessoryGoodsRepository.findAll();
        HashMap strategyGoodsMap = new HashMap();
        ArrayList<Object> toAdd = new ArrayList<Object>();
        for (AccessoryGoods accessoryGoods : all) {
            MarketingConfig marketingConfig = new MarketingConfig();
            if (accessoryGoods.getType() == 1) {
                marketingConfig.setType(Integer.valueOf(MarketingConfigTypeEnum.PLATFORM_STRATEGY.ordinal()));
            } else {
                marketingConfig.setType(Integer.valueOf(MarketingConfigTypeEnum.RELATED.ordinal()));
            }
            marketingConfig.setAttachedGoodsCode(accessoryGoods.getAccessoryCode());
            marketingConfig.setAttachedStrategySid(accessoryGoods.getAccessoryStrategySid());
            marketingConfig.setMainStrategySid(accessoryGoods.getStrategySid());
            if (strategyGoodsMap.get(accessoryGoods.getStrategySid()) == null) {
                Optional optionalSellingStrategy = this.sellingStrategyRepository.findById((Object)accessoryGoods.getStrategySid());
                optionalSellingStrategy.ifPresent(a -> strategyGoodsMap.put(a.getSid(), a.getGoodsCode()));
            }
            marketingConfig.setMainGoodsCode((String)strategyGoodsMap.get(accessoryGoods.getStrategySid()));
            marketingConfig.setSort(accessoryGoods.getSort());
            marketingConfig.setCreateDate(accessoryGoods.getCreateDate());
            marketingConfig.setCreateById(accessoryGoods.getCreateById());
            marketingConfig.setModifyDate(accessoryGoods.getModifyDate());
            marketingConfig.setModifyById(accessoryGoods.getModifyById());
            if (marketingConfig.getMainGoodsCode() == null) {
                logger.info("\u9500\u552e\u65b9\u6848\u4e0d\u5b58\u5728{}", (Object)marketingConfig.getMainStrategySid());
            }
            if (marketingConfig.getMainGoodsCode() == null || allMarketConfig.contains(marketingConfig) || toAdd.contains(marketingConfig)) continue;
            toAdd.add(marketingConfig);
        }
        List allGoodsOnPlatform = this.goodsOnPlatformRepository.findAll();
        HashMap<String, Goods> goodsMap = new HashMap<String, Goods>();
        for (GoodsOnPlatform goodsOnPlatform : allGoodsOnPlatform) {
            String platformCode = goodsOnPlatform.getPlatformCode();
            Goods platformGoods = goodsMap.computeIfAbsent(platformCode, code -> this.goodsRepository.findByCode(code));
            if (platformGoods == null) {
                logger.info("\u5546\u54c1\u4e0d\u5b58\u5728\uff1a{}", (Object)platformCode);
                continue;
            }
            Long defaultStrategySid = platformGoods.getDefaultStrategySid();
            if (defaultStrategySid == null || defaultStrategySid == 0L) continue;
            MarketingConfig marketingConfig = new MarketingConfig();
            marketingConfig.setType(Integer.valueOf(MarketingConfigTypeEnum.PLATFORM.ordinal()));
            marketingConfig.setMainGoodsCode(goodsOnPlatform.getCode());
            marketingConfig.setMainStrategySid(null);
            marketingConfig.setAttachedGoodsCode(platformCode);
            marketingConfig.setAttachedStrategySid(defaultStrategySid);
            marketingConfig.setCreateDate(goodsOnPlatform.getCreateDate());
            marketingConfig.setCreateById(goodsOnPlatform.getCreateById());
            marketingConfig.setModifyDate(goodsOnPlatform.getModifyDate());
            marketingConfig.setModifyById(goodsOnPlatform.getModifyById());
            if (allMarketConfig.contains(marketingConfig) || toAdd.contains(marketingConfig)) continue;
            toAdd.add(marketingConfig);
        }
        this.marketingConfigRepository.saveAll(toAdd);
        this.marketingConfigRepository.flush();
        List allNow = this.marketingConfigRepository.findAll();
        Map<String, List<MarketingConfig>> groupedConfigs = allNow.stream().collect(Collectors.groupingBy(MarketingConfig::getMainGoodsCode));
        ArrayList<MarketingConfig> configsToAdd = new ArrayList<MarketingConfig>();
        ArrayList<MarketingConfig> configsToRemove = new ArrayList<MarketingConfig>();
        for (Map.Entry<String, List<MarketingConfig>> entry : groupedConfigs.entrySet()) {
            String mainGoodsCode = entry.getKey();
            List<MarketingConfig> configs = entry.getValue();
            boolean hasType0 = configs.stream().anyMatch(c -> Integer.valueOf(0).equals(c.getType()));
            boolean hasType2 = configs.stream().anyMatch(c -> Integer.valueOf(2).equals(c.getType()));
            if (!hasType0 || !hasType2) continue;
            List type0Configs = configs.stream().filter(c -> Integer.valueOf(0).equals(c.getType())).collect(Collectors.toList());
            for (MarketingConfig type0Config : type0Configs) {
                List strategies = this.sellingStrategyRepository.findAllByGoodsCode(mainGoodsCode);
                for (SellingStrategy strategy : strategies) {
                    MarketingConfig newConfig = new MarketingConfig();
                    newConfig.setType(Integer.valueOf(2));
                    newConfig.setMainGoodsCode(type0Config.getMainGoodsCode());
                    newConfig.setMainStrategySid(Long.valueOf(strategy.getSid()));
                    newConfig.setAttachedGoodsCode(type0Config.getAttachedGoodsCode());
                    newConfig.setAttachedStrategySid(type0Config.getAttachedStrategySid());
                    newConfig.setSort(type0Config.getSort());
                    if (allNow.contains(newConfig)) continue;
                    logger.info("\u8425\u9500\u5546\u54c1\u5347\u7ea7\uff0c\u5546\u54c1\u62c6\u5230\u65b9\u6848\uff1a{}", (Object)newConfig.getMainGoodsCode());
                    configsToAdd.add(newConfig);
                }
                configsToRemove.add(type0Config);
            }
        }
        if (!configsToAdd.isEmpty()) {
            this.marketingConfigRepository.saveAll(configsToAdd);
        }
        if (!configsToRemove.isEmpty()) {
            this.marketingConfigRepository.deleteAll(configsToRemove);
        }
    }

    private void rollbackProductType() {
        DictDataDTO dictDataDTO = new DictDataDTO("goods", null);
        List dictData = this.dictDataService.selectDictDataList(dictDataDTO);
        List all = this.productRepository.findAll();
        CaseInsensitiveMap productMap = new CaseInsensitiveMap();
        all.forEach(arg_0 -> UpgradeDatabaseV43702ToV43703Service.lambda$rollbackProductType$5((Map)productMap, arg_0));
        ArrayList<Product> changed = new ArrayList<Product>();
        for (DictData dictDatum : dictData) {
            Product product = (Product)productMap.get(dictDatum.getDictKey());
            if (product == null) {
                Product newProduct = new Product();
                newProduct.setSid(SnowFlake.getInstance().newId());
                EntityUtils.setCreateFields((BaseEntity)newProduct);
                changed.add(newProduct);
                newProduct.setProductCode(dictDatum.getDictKey());
                newProduct.setProductName(dictDatum.getDictValue());
                newProduct.setProductCategory(dictDatum.getDictValue());
                continue;
            }
            if (ObjectUtils.nullSafeEquals((Object)product.getProductName(), (Object)dictDatum.getDictValue())) continue;
            changed.add(product);
            product.setProductCode(dictDatum.getDictKey());
            product.setProductName(dictDatum.getDictValue());
            product.setProductCategory(dictDatum.getDictValue());
        }
        this.productRepository.saveAll(changed);
    }

    private void updateDictData() {
        String category = "resourceCategory";
        DictDataDTO dictDataDTO = new DictDataDTO(category, null);
        List dictDataList = this.dictDataService.selectDictDataList(dictDataDTO);
        logger.info("dictDataList.size() = {}", (Object)dictDataList.size());
        for (DictData dictData : dictDataList) {
            this.dictDataService.deleteDictDataBySid(Long.valueOf(dictData.getSid()));
        }
        DictData dictData = new DictData();
        dictData.setDictId(category);
        dictData.setDictKey("points");
        dictData.setDictValue("\u7edf\u4e00\u70b9\u6570");
        if (Locale.TRADITIONAL_CHINESE.getCountry().equalsIgnoreCase(this.envProperties.getArea())) {
            dictData.setDictValue("\u7d71\u4e00\u9ede\u6578");
        }
        this.dictDataService.insertDictData(dictData);
        DictData dictData2 = new DictData();
        dictData2.setDictId(category);
        dictData2.setDictKey("dmcStorage");
        dictData2.setDictValue("\u7edf\u4e00\u6587\u6863\u4e2d\u5fc3\u5bb9\u91cf");
        if (Locale.TRADITIONAL_CHINESE.getCountry().equalsIgnoreCase(this.envProperties.getArea())) {
            dictData2.setDictValue("\u7d71\u4e00\u6587\u6a94\u4e2d\u5fc3\u5bb9\u91cf");
        }
        this.dictDataService.insertDictData(dictData2);
        DictData dictData3 = new DictData();
        dictData3.setDictId(category);
        dictData3.setDictKey("other");
        dictData3.setDictValue("\u5176\u4ed6");
        if (Locale.TRADITIONAL_CHINESE.getCountry().equalsIgnoreCase(this.envProperties.getArea())) {
            dictData3.setDictValue("\u5176\u4ed6");
        }
        this.dictDataService.insertDictData(dictData3);
    }

    private static /* synthetic */ void lambda$rollbackProductType$5(Map productMap, Product product) {
        productMap.putIfAbsent(product.getProductCode(), product);
    }
}

