/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.support.upgrade.impl;

import com.digiwin.dap.middleware.dict.domain.DictDataDTO;
import com.digiwin.dap.middleware.dict.entity.Dict;
import com.digiwin.dap.middleware.dict.entity.DictData;
import com.digiwin.dap.middleware.dict.service.DictDataService;
import com.digiwin.dap.middleware.dict.service.DictService;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.gmc.entity.PaymentType;
import com.digiwin.dap.middleware.gmc.repository.PaymentTypeRepository;
import com.digiwin.dap.middleware.service.impl.AbstractUpdateDatabaseService;
import com.digiwin.dap.middleware.util.EntityUtils;
import com.digiwin.dap.middleware.util.SnowFlake;
import java.time.LocalDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Order(value=43705)
@Service
public class UpgradeDatabaseV43704ToV43705Service
extends AbstractUpdateDatabaseService {
    private static final Logger logger = LoggerFactory.getLogger(UpgradeDatabaseV43704ToV43705Service.class);
    @Autowired
    private PaymentTypeRepository paymentTypeRepository;
    @Autowired
    private DictService dictService;
    @Autowired
    private DictDataService dictDataService;

    public String version() {
        return "4.37.5.0";
    }

    public void update() {
        logger.info("4.37.5.0 gmc\u5347\u7ea7\u5f00\u59cb: {}", (Object)LocalDateTime.now());
        this.createPaymentType();
        this.createDict();
        logger.info("4.37.5.0 gmc\u5347\u7ea7\u7ed3\u675f: {}", (Object)LocalDateTime.now());
    }

    private void createPaymentType() {
        List existedTypes = this.paymentTypeRepository.findAllByCategoryId("api");
        if (!existedTypes.isEmpty()) {
            if (!existedTypes.stream().anyMatch(p -> p.getId().equals(2))) {
                PaymentType paymentType = new PaymentType();
                paymentType.setName("\u81ea\u5b9a\u5355\u4f4d");
                paymentType.setId(Integer.valueOf(2));
                paymentType.setCategoryId("api");
                EntityUtils.setCreateFields((BaseEntity)paymentType);
                EntityUtils.setModifyFields((BaseEntity)paymentType);
                this.paymentTypeRepository.save((Object)paymentType);
            }
        } else {
            PaymentType paymentType = new PaymentType();
            paymentType.setName("\u81ea\u5b9a\u5355\u4f4d");
            paymentType.setId(Integer.valueOf(2));
            paymentType.setCategoryId("api");
            EntityUtils.setCreateFields((BaseEntity)paymentType);
            EntityUtils.setModifyFields((BaseEntity)paymentType);
            this.paymentTypeRepository.save((Object)paymentType);
        }
    }

    private void createDict() {
        Dict dict;
        Dict supportSystemDict = this.dictService.selectDictById("supportSystem");
        if (null == supportSystemDict) {
            supportSystemDict = new Dict();
            supportSystemDict.setSid(SnowFlake.getInstance().newId());
            supportSystemDict.setId("supportSystem");
            supportSystemDict.setName("\u642d\u914d\u7cfb\u7d71");
            supportSystemDict.setRemark("\u642d\u914d\u7cfb\u7d71");
            this.dictService.insertDict(supportSystemDict);
        }
        if (null == (dict = this.dictService.selectDictById("GOODS_PURPOSE"))) {
            dict = new Dict();
            dict.setSid(SnowFlake.getInstance().newId());
            dict.setId("GOODS_PURPOSE");
            dict.setName("\u5546\u54c1\u7528\u9014");
            this.dictService.insertDict(dict);
        }
        DictDataDTO condition = new DictDataDTO();
        condition.setDictId("GOODS_PURPOSE");
        List dictDataList = this.dictDataService.selectDictDataList(condition);
        this.insertDictData(dictDataList, "formal", "\u6b63\u5f0f\u9500\u552e", Integer.valueOf(0));
        this.insertDictData(dictDataList, "dev", "\u5f00\u53d1\u4f53\u9a8c", Integer.valueOf(1));
        this.insertDictData(dictDataList, "test", "\u6d4b\u8bd5", Integer.valueOf(2));
    }

    private void insertDictData(List<DictData> dictDataList, String dictKey, String dictValue, Integer sort) {
        if (!dictDataList.stream().anyMatch(d -> d.getDictKey().equals(dictKey))) {
            DictData data = new DictData();
            data.setDictId("GOODS_PURPOSE");
            data.setDictKey(dictKey);
            data.setDictValue(dictValue);
            data.setDictSort(sort);
            this.dictDataService.insertDictData(data);
        }
    }
}

