/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.support.upgrade.impl;

import com.digiwin.dap.middleware.dict.domain.DictDataDTO;
import com.digiwin.dap.middleware.dict.entity.Dict;
import com.digiwin.dap.middleware.dict.entity.DictData;
import com.digiwin.dap.middleware.dict.service.DictDataService;
import com.digiwin.dap.middleware.dict.service.DictService;
import com.digiwin.dap.middleware.gmc.domain.goods.GoodsVO;
import com.digiwin.dap.middleware.gmc.entity.GoodsExtra;
import com.digiwin.dap.middleware.gmc.mapper.GoodsMapper;
import com.digiwin.dap.middleware.gmc.service.goodsextra.GoodsExtraCrudService;
import com.digiwin.dap.middleware.service.impl.AbstractUpdateDatabaseService;
import com.digiwin.dap.middleware.util.SnowFlake;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Order(value=43706)
@Service
public class UpgradeDatabaseV43705ToV43706Service
extends AbstractUpdateDatabaseService {
    private static final Logger logger = LoggerFactory.getLogger(UpgradeDatabaseV43705ToV43706Service.class);
    @Autowired
    private DictService dictService;
    @Autowired
    private DictDataService dictDataService;
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private GoodsExtraCrudService goodsExtraCrudService;

    public String version() {
        return "4.37.6.0";
    }

    public void update() {
        logger.info("4.37.6.0 gmc\u5347\u7ea7\u5f00\u59cb: {}", (Object)LocalDateTime.now());
        this.createDict();
        this.updateGoodsPurpose();
        logger.info("4.37.6.0 gmc\u5347\u7ea7\u7ed3\u675f: {}", (Object)LocalDateTime.now());
    }

    private void createDict() {
        Dict dict = this.dictService.selectDictById("GOODS_PURPOSE");
        if (null == dict) {
            dict = new Dict();
            dict.setSid(SnowFlake.getInstance().newId());
            dict.setId("GOODS_PURPOSE");
            dict.setName("\u5546\u54c1\u7528\u9014");
            this.dictService.insertDict(dict);
        }
        DictDataDTO condition = new DictDataDTO();
        condition.setDictId("GOODS_PURPOSE");
        List dictDataList = this.dictDataService.selectDictDataList(condition);
        this.insertDictData(dictDataList, "official", "\u6b63\u5f0f\u9500\u552e", Integer.valueOf(0));
    }

    private void insertDictData(List<DictData> dictDataList, String dictKey, String dictValue, Integer sort) {
        DictData matchDictData = dictDataList.stream().filter(d -> "formal".equalsIgnoreCase(d.getDictKey())).findFirst().orElse(null);
        if (null != matchDictData) {
            this.dictDataService.deleteDictDataBySid(Long.valueOf(matchDictData.getSid()));
        }
        if (!dictDataList.stream().anyMatch(d -> d.getDictKey().equals(dictKey))) {
            DictData data = new DictData();
            data.setDictId("GOODS_PURPOSE");
            data.setDictKey(dictKey);
            data.setDictValue(dictValue);
            data.setDictSort(sort);
            this.dictDataService.insertDictData(data);
        }
    }

    private void updateGoodsPurpose() {
        this.goodsMapper.updatePurpose();
        List goodsCodes = this.goodsMapper.findAllGoodsCodesExclude();
        Lists.partition((List)goodsCodes, (int)200).forEach(arg_0 -> this.processBatch(arg_0));
    }

    private void processBatch(List<GoodsVO> addList) {
        ArrayList goodsExtras = new ArrayList();
        addList.forEach(a -> {
            GoodsExtra goodsExtra = new GoodsExtra();
            goodsExtra.setSid(SnowFlake.getInstance().newId());
            goodsExtra.setGoodsPurpose(ObjectUtils.nullSafeEquals((Object)true, (Object)a.getMarket()) ? "official" : "dev");
            goodsExtra.setGoodsCode(a.getCode());
            goodsExtras.add(goodsExtra);
        });
        this.goodsExtraCrudService.saveAll(goodsExtras);
    }
}

