/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.support.upgrade.impl;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.gmc.constant.enums.GoodsCategoryEnum;
import com.digiwin.dap.middleware.gmc.constant.enums.GoodsTrialTypeEnum;
import com.digiwin.dap.middleware.gmc.domain.EnvProperties;
import com.digiwin.dap.middleware.gmc.entity.Category;
import com.digiwin.dap.middleware.gmc.entity.Goods;
import com.digiwin.dap.middleware.gmc.entity.PaymentType;
import com.digiwin.dap.middleware.gmc.entity.tag.TagOwned;
import com.digiwin.dap.middleware.gmc.repository.CategoryRepository;
import com.digiwin.dap.middleware.gmc.repository.GoodsRepository;
import com.digiwin.dap.middleware.gmc.repository.TagOwnedRepository;
import com.digiwin.dap.middleware.gmc.service.goods.PaymentTypeService;
import com.digiwin.dap.middleware.gmc.service.tag.TagOwnedCrudService;
import com.digiwin.dap.middleware.service.impl.AbstractUpdateDatabaseService;
import com.digiwin.dap.middleware.util.EntityUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Order(value=43707)
@Service
public class UpgradeDatabaseV43706ToV43707Service
extends AbstractUpdateDatabaseService {
    private static final Logger logger = LoggerFactory.getLogger(UpgradeDatabaseV43706ToV43707Service.class);
    @Autowired
    private GoodsRepository goodsRepository;
    @Autowired
    private CategoryRepository categoryRepository;
    @Autowired
    private PaymentTypeService paymentTypeService;
    @Autowired
    private TagOwnedCrudService tagOwnedCrudService;
    @Autowired
    private TagOwnedRepository tagOwnedRepository;
    @Autowired
    private EnvProperties envProperties;

    public String version() {
        return "4.37.7.0";
    }

    public void update() {
        logger.info("\u5f00\u59cb\u5347\u7ea7...");
        this.updateGoodsTrialType();
        this.createAgentCategory();
        this.createTag();
        logger.info("\u5347\u7ea7\u5b8c\u6210");
    }

    private void createTag() {
        TagOwned tagOwned = this.tagOwnedRepository.getFirstById("agent");
        if (null == tagOwned) {
            tagOwned = new TagOwned();
            tagOwned.setId("agent");
            tagOwned.setName("\u667a\u80fd\u4f53");
            this.tagOwnedCrudService.create((BaseEntity)tagOwned);
        }
    }

    private void createAgentCategory() {
        Category category = this.categoryRepository.findByCode("agent");
        if (category == null) {
            category = new Category();
            category.setCode("agent");
            category.setName("\u667a\u80fd\u4f53");
            this.categoryRepository.save((Object)category);
        }
        List existedPaymentTypes = this.paymentTypeService.getPaymentTypeListByCategoryId("agent");
        ArrayList<PaymentType> paymentTypes = new ArrayList<PaymentType>();
        List paymentTypesInApp = this.paymentTypeService.getPaymentTypeListByCategoryId("app");
        paymentTypesInApp.stream().forEach(a -> {
            if (!existedPaymentTypes.stream().anyMatch(p -> ObjectUtils.nullSafeEquals((Object)a.getId(), (Object)p.getId()))) {
                PaymentType paymentType = new PaymentType();
                paymentType.setCategoryId("agent");
                paymentType.setId(a.getId());
                paymentType.setName(a.getName());
                EntityUtils.setCreateFields((BaseEntity)paymentType);
                paymentTypes.add(paymentType);
            }
        });
        if (!existedPaymentTypes.stream().anyMatch(p -> ObjectUtils.nullSafeEquals((Object)5, (Object)p.getId()))) {
            PaymentType paymentType = new PaymentType();
            paymentType.setCategoryId("agent");
            paymentType.setId(Integer.valueOf(5));
            paymentType.setName("\u5957");
            if (Locale.TRADITIONAL_CHINESE.getCountry().equalsIgnoreCase(this.envProperties.getArea())) {
                paymentType.setName("\u5957");
            }
            EntityUtils.setCreateFields((BaseEntity)paymentType);
            paymentTypes.add(paymentType);
        }
        if (paymentTypes.size() > 0) {
            this.paymentTypeService.saveAll(paymentTypes);
        }
    }

    private void updateGoodsTrialType() {
        List goods = this.goodsRepository.findTrialTypeCandidates(GoodsCategoryEnum.APP.id());
        logger.info("\u5f00\u59cb\u5347\u7ea7\u5546\u54c1\u4f53\u9a8c\u7c7b\u578b\u6570\u636e\uff0c\u7b26\u5408\u6761\u4ef6\u7684\u5546\u54c1\u6570\u91cf: {}", (Object)goods.size());
        if (goods.isEmpty()) {
            return;
        }
        for (Goods g : goods) {
            g.setTrialType(null);
            if (Objects.nonNull(g.getTrialCloudWebsite())) {
                g.setTrialType(GoodsTrialTypeEnum.APPLY_TRIAL.getValue());
                continue;
            }
            if (Objects.nonNull(g.getDevTrialUrl())) {
                g.setTrialType(GoodsTrialTypeEnum.TRIAL_EXPERIENCE.getValue());
                continue;
            }
            if (!Objects.nonNull(g.getGoodsAttributes()) && !Objects.nonNull(g.getMobileTrialUrl())) continue;
            if (Objects.nonNull(g.getGoodsAttributes()) && !"{\"trial\":[]}".equals(g.getGoodsAttributes())) {
                g.setTrialType(GoodsTrialTypeEnum.SIMULATED_EXPERIENCE.getValue());
            }
            if (!Objects.nonNull(g.getMobileTrialUrl()) || "{}".equals(g.getMobileTrialUrl())) continue;
            g.setTrialType(GoodsTrialTypeEnum.SIMULATED_EXPERIENCE.getValue());
        }
        this.goodsRepository.saveAll((Iterable)goods);
    }
}

