/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.gmc.support.upgrade.impl;

import com.digiwin.dap.middleware.gmc.domain.remote.DevSys;
import com.digiwin.dap.middleware.gmc.entity.Goods;
import com.digiwin.dap.middleware.gmc.repository.GoodsRepository;
import com.digiwin.dap.middleware.gmc.support.remote.IamService;
import com.digiwin.dap.middleware.service.impl.AbstractUpdateDatabaseService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Order(value=40900)
@Service
public class UpgradeDatabaseV48ToV49Service
extends AbstractUpdateDatabaseService {
    private static final Logger logger = LoggerFactory.getLogger(UpgradeDatabaseV48ToV49Service.class);
    @Autowired
    private IamService iamService;
    @Autowired
    private GoodsRepository goodsRepository;

    public String version() {
        return "4.9.0.0000";
    }

    @Transactional(rollbackFor={Exception.class})
    public void update() {
        logger.info("\u6570\u636e\u5347\u7ea7\u5f00\u59cb:{}", (Object)LocalDateTime.now());
        try {
            List devSysList = this.iamService.findDevSysByTenant();
            if (devSysList.isEmpty()) {
                return;
            }
            ArrayList<String> updateCodes = new ArrayList<String>();
            for (DevSys devSys : devSysList) {
                Goods goods = this.goodsRepository.findByCode(devSys.getId());
                if (goods == null || !StringUtils.isEmpty((Object)goods.getDevId())) continue;
                goods.setDevId(devSys.getTenantId());
                goods.setDevName(devSys.getTenantName());
                this.goodsRepository.save((Object)goods);
                updateCodes.add(goods.getCode());
            }
            logger.info("\u6570\u636e\u5347\u7ea7\u7ed3\u675f:{}, {}", updateCodes, (Object)LocalDateTime.now());
        }
        catch (Exception e) {
            logger.error("4.9.0.0000\u6570\u636e\u5347\u7ea7\u5931\u8d25");
        }
    }
}

