/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware;

import com.digiwin.dap.middleware.cache.RedisUtils;
import com.digiwin.dap.middleware.dict.service.DictService;
import com.digiwin.dap.middleware.iam.constant.enums.CloudTypeEnum;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.dict.DictInitDTO;
import com.digiwin.dap.middleware.iam.domain.tenant.metadata.TenantMetadataColumnDTO;
import com.digiwin.dap.middleware.iam.entity.TenantMetadataColumn;
import com.digiwin.dap.middleware.iam.service.tenantmetadata.TenantMetadataColumnCrudService;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;

@Component
public class IamApplicationRunner
implements ApplicationRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(IamApplicationRunner.class);
    private static final String PATH_JSON = "/static/templates/%s.json";
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private TenantMetadataColumnCrudService tenantMetadataColumnCrudService;
    @Autowired
    private DictService dictService;

    public void run(ApplicationArguments args) throws Exception {
        if (CloudTypeEnum.isCloud((Integer)this.envProperties.getCloud())) {
            return;
        }
        LOGGER.info("iam \u521d\u59cb\u5316\u6570\u636e \u5f00\u59cb...");
        this.initOnce();
        this.init();
        LOGGER.info("iam \u521d\u59cb\u5316\u6570\u636e \u5b8c\u6210...");
    }

    public void initOnce() {
        boolean exists = RedisUtils.setIfAbsent((String)"iam:init:data", (Object)1, (Duration)Duration.ofSeconds(30L));
        if (!exists) {
            return;
        }
        LOGGER.info("initialize once starting...");
        this.initTenantMetadataColumn();
        this.initDict();
        LOGGER.info("initialize once end...");
    }

    public void init() {
    }

    private void initTenantMetadataColumn() {
        InputStream stream = this.getClass().getResourceAsStream(String.format(PATH_JSON, "tenant_metadata_column"));
        List baseList = new ArrayList();
        try {
            baseList = (List)JsonUtils.createObjectMapper().readValue(stream, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (IOException e) {
            LOGGER.error("\u521d\u59cb\u79df\u6237\u5143\u6570\u636e\u8f6c\u5316\u8d44\u6599\u5931\u8d25", (Throwable)e);
        }
        ArrayList<TenantMetadataColumn> list = new ArrayList<TenantMetadataColumn>();
        for (TenantMetadataColumnDTO dto : baseList) {
            TenantMetadataColumn column = (TenantMetadataColumn)this.tenantMetadataColumnCrudService.findByUnionKey(new Object[]{dto.getCatalogId(), dto.getKey()});
            if (column != null) continue;
            list.add(dto.fillName(this.envProperties.getLocale()).get());
        }
        if (!list.isEmpty()) {
            this.tenantMetadataColumnCrudService.saveAll(list);
        }
    }

    private void initDict() {
        InputStream stream = this.getClass().getResourceAsStream(String.format(PATH_JSON, "dict"));
        List baseList = new ArrayList();
        try {
            baseList = (List)JsonUtils.createObjectMapper().readValue(stream, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (IOException e) {
            LOGGER.error("\u521d\u59cb\u5b57\u5178\u5143\u6570\u636e\u8f6c\u5316\u8d44\u6599\u5931\u8d25", (Throwable)e);
        }
        List allDict = this.dictService.selectDictList(null);
        for (DictInitDTO dto : baseList) {
            if (!allDict.stream().noneMatch(dict -> dict.getId().equals(dto.getId()))) continue;
            this.dictService.insertDict(dto.fillName(this.envProperties.getLocale()).get());
        }
    }
}

