/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.api;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.app.ActionQueryResultVO;
import com.digiwin.dap.middleware.iam.domain.app.ActionVO;
import com.digiwin.dap.middleware.iam.domain.app.RelocateActionVO;
import com.digiwin.dap.middleware.iam.domain.dev.DevAppVO;
import com.digiwin.dap.middleware.iam.domain.request.BatchDelActionsRequest;
import com.digiwin.dap.middleware.iam.domain.sys.SysModuleCondition;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.service.app.ActionCrudService;
import com.digiwin.dap.middleware.iam.service.app.ActionQueryService;
import com.digiwin.dap.middleware.iam.service.app.ActionService;
import com.digiwin.dap.middleware.iam.service.app.ActionTenantCrudService;
import com.digiwin.dap.middleware.iam.service.app.impl.RelocateActionService;
import com.digiwin.dap.middleware.iam.service.sys.SysCrudService;
import com.digiwin.dap.middleware.iam.support.clean.RefreshCacheService;
import com.digiwin.dap.middleware.iam.support.clean.SysCacheDeleteService;
import com.digiwin.dap.middleware.iam.support.remote.CacService;
import com.digiwin.dap.middleware.iam.support.validate.SysValidateService;
import com.digiwin.dap.middleware.util.UserUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/iam/v2/app"})
public class ActionController {
    @Autowired
    private SysCrudService sysCrudService;
    @Autowired
    private ActionCrudService actionCrudService;
    @Autowired
    private ActionQueryService actionQueryService;
    @Autowired
    private ActionService actionService;
    @Autowired
    private ActionTenantCrudService actionTenantCrudService;
    @Autowired
    private CacService cacService;
    @Autowired
    private RelocateActionService relocateActionService;
    @Autowired
    private SysValidateService sysValidateService;
    @Autowired
    private RefreshCacheService refreshCacheService;
    @Autowired
    private SysCacheDeleteService sysCacheDeleteService;

    @PostMapping(value={"/action"})
    public ResponseEntity<?> getAction(@RequestBody ActionVO actionVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        long actionSid = this.sysValidateService.check9(actionVO);
        ActionQueryResultVO action = this.actionQueryService.getAction(actionVO.getTenantSid(), actionVO.getAppSid(), actionVO.getModuleSid(), actionSid);
        return ResponseEntity.ok((Object)action);
    }

    @PostMapping(value={"/action/update"})
    public ResponseEntity<?> updateAction(@RequestBody ActionVO actionVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        this.actionService.saveAction(actionVO, Boolean.TRUE.equals(actionVO.getUpdateCondition()));
        this.refreshCacheService.deletePermissionBySys(actionVO.getAppSid(), actionVO.getAppId(), actionVO.getTenantSid());
        return ResponseEntity.ok((Object)actionVO.getSid());
    }

    @PostMapping(value={"/action/custom"})
    public ResponseEntity<?> getActionCustom(@RequestBody ActionVO actionVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        actionVO.setTenantSid(authoredUser.getTenantSid());
        return this.getAction(actionVO, authoredUser);
    }

    @PostMapping(value={"/action/custom/update"})
    public ResponseEntity<?> updateActionCustom(@RequestBody ActionVO actionVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        actionVO.setTenantSid(authoredUser.getTenantSid());
        return this.updateAction(actionVO, authoredUser);
    }

    @PostMapping(value={"/action/tenant/detach"})
    public StdData<?> updateActionSeparate(@RequestBody ActionVO actionVO) {
        Assert.hasLength((String)actionVO.getAppId(), (String)"\u5e94\u7528Id\u4e0d\u53ef\u4e3a\u7a7a");
        Sys sys = (Sys)this.sysCrudService.findById(actionVO.getAppId());
        if (sys != null) {
            this.actionTenantCrudService.deleteBySysSid(sys.getSid());
        }
        return StdData.ok().build();
    }

    @PostMapping(value={"/action/batch/update"})
    public ResponseEntity<?> batchUpdateAction(@RequestBody ActionVO actionVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        this.actionService.saveAction(actionVO, true);
        this.refreshCacheService.deletePermissionBySys(actionVO.getAppSid(), actionVO.getAppId(), actionVO.getTenantSid());
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @PostMapping(value={"/action/disable"})
    public ResponseEntity<?> disAction(@RequestBody ActionVO actionVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        long actionSid = this.sysValidateService.check9(actionVO);
        this.actionService.disAction(actionVO.getTenantSid(), actionSid);
        this.refreshCacheService.deletePermissionBySys(actionVO.getAppSid(), actionVO.getAppId(), actionVO.getTenantSid());
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @PostMapping(value={"/action/disable/force"})
    public ResponseEntity<?> forceDisAction(@RequestBody ActionVO actionVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        long actionSid = this.sysValidateService.check9(actionVO);
        this.actionService.forceDisAction(actionVO.getTenantSid(), actionSid);
        this.refreshCacheService.deletePermissionBySys(actionVO.getAppSid(), actionVO.getAppId(), actionVO.getTenantSid());
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }

    @PostMapping(value={"/action/del"})
    public void deleteAction(@RequestBody ActionVO actionVO) {
        long actionSid = this.sysValidateService.check10(actionVO);
        if (actionSid > 0L) {
            this.actionCrudService.deleteById(actionVO.getSid());
            this.refreshCacheService.deletePermissionBySys(actionVO.getAppSid(), actionVO.getAppId(), actionVO.getTenantSid());
        }
    }

    @PostMapping(value={"/action/batch/del"})
    public StdData<?> deleteActions(@RequestBody BatchDelActionsRequest body) {
        body.paramCheck();
        Sys sys = (Sys)this.sysCrudService.findById(body.getSysId());
        if (sys == null) {
            throw new BusinessException((ErrorHandler)I18nError.SYS_NOT_EXISTED, new Object[]{body.getSysId()});
        }
        List tenantSids = this.actionService.deleteActionBatch(sys.getSid(), body.getActions());
        tenantSids.forEach(tenantSid -> this.sysCacheDeleteService.deleteTreeBySysSid(sys.getSid(), tenantSid.longValue()));
        this.refreshCacheService.deletePermissionBySys(sys.getSid(), sys.getId(), 0L);
        return StdData.ok().build();
    }

    @PostMapping(value={"/action/tenant/current/del"})
    public StdData<?> deleteActionTenant(@RequestBody ActionVO actionVO, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser) {
        actionVO.setTenantSid(authoredUser.getTenantSid());
        long actionSid = this.sysValidateService.check9(actionVO);
        List sids = this.actionService.deleteTenantAction(actionVO.getAppSid(), actionSid, actionVO.getTenantSid());
        this.refreshCacheService.deletePermissionBySys(actionVO.getAppSid(), actionVO.getAppId(), actionVO.getTenantSid());
        return StdData.ok((Object)sids);
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/action/relocate"})
    public StdData<?> deleteAction(@RequestBody RelocateActionVO request) {
        this.relocateActionService.relocateAction(request);
        return StdData.ok().build();
    }

    @PostMapping(value={"/action/ids"})
    public StdData<?> getActionIds(@RequestBody(required=false) DevAppVO body) {
        if (body == null || body.getAppIds().isEmpty()) {
            return StdData.ok(Collections.emptyList());
        }
        ArrayList actionIds = new ArrayList();
        for (String appId : body.getAppIds()) {
            List moduleIds = this.cacService.getAuthModuleIds(UserUtils.getTenantId(), appId);
            actionIds.addAll(this.actionQueryService.getActionIdBySysIds(appId, moduleIds));
        }
        return StdData.ok(actionIds);
    }

    @GetMapping(value={"/action/public"})
    public StdData<?> getPublicAction(@RequestParam String appId) {
        return StdData.ok((Object)this.actionQueryService.getPublicAction(appId));
    }

    @RequestMapping(value={"/action/model"}, method={RequestMethod.GET, RequestMethod.POST})
    public StdData<?> getModelAction(@RequestParam(required=false) List<String> modelIds, @RequestParam(required=false) List<String> paths, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser authoredUser, @RequestBody(required=false) SysModuleCondition cond) {
        if (null != cond) {
            modelIds = CollectionUtils.isEmpty(modelIds) ? cond.getModelIds() : modelIds;
            paths = CollectionUtils.isEmpty(paths) ? cond.getPaths() : paths;
        }
        return StdData.ok((Object)this.actionQueryService.findModelAction(authoredUser.getTenantSid(), modelIds, paths));
    }
}

